/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.auth.Credentials;
import org.limewire.collection.IntervalSet;
import org.limewire.io.Address;
import org.limewire.util.Objects;

public class RemoteFileDescContext {
    private static final Log LOG = LogFactory.getLog(RemoteFileDescContext.class);
    private final RemoteFileDesc remoteFileDesc;
    private int lastHttpCode = -1;
    private int failedCount;
    private IntervalSet availableRanges;
    private boolean thexFailed;
    private int queueStatus = Integer.MAX_VALUE;
    private volatile long earliestRetryTime;
    private volatile long pingTime = 0L;
    private volatile long pongTime = 0L;

    public RemoteFileDescContext(RemoteFileDesc remoteFileDesc) {
        this.remoteFileDesc = Objects.nonNull(remoteFileDesc, "remoteFileDesc");
    }

    public RemoteFileDesc getRemoteFileDesc() {
        return this.remoteFileDesc;
    }

    public int getFailedCount() {
        return this.failedCount;
    }

    public void incrementFailedCount() {
        ++this.failedCount;
    }

    public void resetFailedCount() {
        this.failedCount = 0;
    }

    public void setLastHttpCode(int code) {
        this.lastHttpCode = code;
    }

    public int getLastHttpCode() {
        return this.lastHttpCode;
    }

    public IntervalSet getAvailableRanges() {
        return this.availableRanges.clone();
    }

    public void setAvailableRanges(IntervalSet availableRanges) {
        this.availableRanges = availableRanges;
    }

    public boolean isPartialSource() {
        return this.availableRanges != null;
    }

    public boolean isBusy() {
        return this.isBusy(System.currentTimeMillis());
    }

    public boolean isBusy(long now) {
        return now < this.earliestRetryTime;
    }

    public int getWaitTime(long now) {
        return this.isBusy(now) ? (int)(this.earliestRetryTime - now) / 1000 + 1 : 0;
    }

    public void setRetryAfter(int seconds) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("setting retry after to be [" + seconds + "] seconds for " + this);
        }
        this.earliestRetryTime = System.currentTimeMillis() + (long)(seconds * 1000);
    }

    public void recordPingTime(long now) {
        this.pingTime = now;
    }

    public void recordPongTime(long now) {
        this.pongTime = now;
    }

    public long getRoundTripTime() {
        if (this.pongTime > this.pingTime) {
            return this.pongTime - this.pingTime;
        }
        return Long.MAX_VALUE;
    }

    public boolean hasTHEXFailed() {
        return this.thexFailed;
    }

    public void setTHEXFailed() {
        this.thexFailed = true;
    }

    public URN getSHA1Urn() {
        return this.remoteFileDesc.getSHA1Urn();
    }

    public boolean isReplyToMulticast() {
        return this.remoteFileDesc.isReplyToMulticast();
    }

    public int getQueueStatus() {
        return this.queueStatus;
    }

    public void setQueueStatus(int queueStatus) {
        this.queueStatus = queueStatus;
    }

    public Address getAddress() {
        return this.remoteFileDesc.getAddress();
    }

    public Credentials getCredentials() {
        return this.remoteFileDesc.getCredentials();
    }

    public boolean isFromAlternateLocation() {
        return this.remoteFileDesc.isFromAlternateLocation();
    }

    public String toString() {
        return this.remoteFileDesc.toString();
    }
}

