/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.downloader.DownloadWorker;
import com.limegroup.gnutella.downloader.HTTPDownloader;
import org.limewire.core.api.transfer.SourceInfo;
import org.limewire.util.StringUtils;

class SourceDetails
implements SourceInfo {
    private final String name;
    private final float speed;
    private final String addr;
    private final boolean encrypted;

    public SourceDetails(DownloadWorker worker) {
        HTTPDownloader downloader = worker.getDownloader();
        if (downloader != null) {
            String agent = downloader.getServer();
            this.name = !StringUtils.isEmpty(agent) ? agent : worker.getRFD().getVendor();
            this.encrypted = downloader.isEncrypted();
            float measured = 0.0f;
            try {
                measured = downloader.getMeasuredBandwidth() * 1024.0f;
            }
            catch (InsufficientDataException id) {
                // empty catch block
            }
            this.speed = measured;
        } else {
            this.speed = 0.0f;
            this.encrypted = false;
            this.name = worker.getRFD().getVendor();
        }
        this.addr = worker.getRFD().getAddress().getAddressDescription();
    }

    @Override
    public String getClientName() {
        return this.name;
    }

    @Override
    public float getDownloadSpeed() {
        return this.speed;
    }

    @Override
    public String getIPAddress() {
        return this.addr;
    }

    @Override
    public float getUploadSpeed() {
        return 0.0f;
    }

    @Override
    public boolean isEncyrpted() {
        return this.encrypted;
    }
}

