/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.downloader.AbstractSourceRanker;
import com.limegroup.gnutella.downloader.FriendsFirstSourceRanker;
import com.limegroup.gnutella.downloader.LegacyRanker;
import com.limegroup.gnutella.downloader.PingRanker;
import com.limegroup.gnutella.downloader.SourceRanker;
import org.limewire.core.settings.DownloadSettings;

@Singleton
public class SourceRankerFactory {
    private final NetworkManager networkManager;
    private final Provider<PingRanker> pingRanker;

    @Inject
    public SourceRankerFactory(NetworkManager networkManager, Provider<PingRanker> pingRanker) {
        this.networkManager = networkManager;
        this.pingRanker = pingRanker;
    }

    FriendsFirstSourceRanker createFriendsFirstSourceRanker() {
        return new FriendsFirstSourceRanker(this.pingRanker.get());
    }

    public SourceRanker getAppropriateRanker() {
        if (this.networkManager.canReceiveSolicited() && DownloadSettings.USE_HEADPINGS.getValue()) {
            return this.createFriendsFirstSourceRanker();
        }
        return new LegacyRanker();
    }

    public SourceRanker getAppropriateRanker(SourceRanker original) {
        AbstractSourceRanker better;
        if (original == null) {
            return this.getAppropriateRanker();
        }
        if (this.networkManager.canReceiveSolicited() && DownloadSettings.USE_HEADPINGS.getValue()) {
            if (original instanceof FriendsFirstSourceRanker) {
                return original;
            }
            better = this.createFriendsFirstSourceRanker();
        } else {
            if (original instanceof LegacyRanker) {
                return original;
            }
            better = new LegacyRanker();
        }
        better.setMeshHandler(original.getMeshHandler());
        better.setRfdVisitor(original.getRfdVisitor());
        better.addToPool(original.getShareableHosts());
        original.stop();
        return better;
    }
}

