/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.messages.Message;
import org.limewire.inspection.InspectionHistogram;
import org.limewire.inspection.InspectionPoint;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;

public class CompositeFilter
implements SpamFilter {
    private static Log LOG = LogFactory.getLog(CompositeFilter.class);
    @InspectionPoint(value="filter hits")
    private static final InspectionHistogram<String> hitCounts = new InspectionHistogram();
    SpamFilter[] delegates;

    public CompositeFilter(SpamFilter[] filters) {
        this.delegates = filters;
    }

    @Override
    public boolean allow(Message m) {
        for (int i = 0; i < this.delegates.length; ++i) {
            if (this.delegates[i].allow(m)) continue;
            String name = this.delegates[i].getClass().getSimpleName();
            hitCounts.count(name);
            LOG.debugf("{0} blocked {1}", (Object)name, (Object)m);
            return false;
        }
        return true;
    }
}

