/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters.response;

import com.google.inject.Singleton;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.filters.KeywordFilter;
import com.limegroup.gnutella.filters.response.ResponseFilter;
import com.limegroup.gnutella.filters.response.XMLDocFilter;
import com.limegroup.gnutella.messages.QueryReply;
import java.util.Set;
import java.util.TreeSet;
import org.limewire.io.GUID;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;

@Singleton
public final class MutableGUIDFilter
implements ResponseFilter {
    private static Log LOG = LogFactory.getLog(MutableGUIDFilter.class);
    private Set<byte[]> _guids = new TreeSet<byte[]>(new GUID.GUIDByteComparator());
    private final KeywordFilter keywordFilter;

    MutableGUIDFilter() {
        this.keywordFilter = new XMLDocFilter(true, false);
    }

    MutableGUIDFilter(KeywordFilter keywordFilter) {
        this.keywordFilter = keywordFilter;
    }

    public synchronized void addGUID(byte[] guid) {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("adding guid: {0}", (Object)new GUID(guid));
        }
        TreeSet<byte[]> guids = new TreeSet<byte[]>(new GUID.GUIDByteComparator());
        guids.addAll(this._guids);
        guids.add(guid);
        this._guids = guids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGUID(byte[] guid) {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("removing guid: {0}", (Object)new GUID(guid));
        }
        if (this._guids.size() == 0) {
            return;
        }
        MutableGUIDFilter mutableGUIDFilter = this;
        synchronized (mutableGUIDFilter) {
            if (this._guids.size() > 0) {
                TreeSet<byte[]> guids = new TreeSet<byte[]>(new GUID.GUIDByteComparator());
                guids.addAll(this._guids);
                guids.remove(guid);
                this._guids = guids;
            }
        }
    }

    @Override
    public boolean allow(QueryReply qr, Response response) {
        if (this._guids.contains(qr.getGUID())) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("filtering for guid: {0}", (Object)new GUID(qr.getGUID()));
            }
            boolean allowed = this.keywordFilter.allow(qr, response);
            if (LOG.isDebugEnabled()) {
                LOG.debugf("{0} allowed {1}", (Object)allowed, (Object)response);
            }
            return allowed;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("not filtering for guid: {0}", (Object)new GUID(qr.getGUID()));
        }
        return true;
    }
}

