/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters.response;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.filters.KeywordFilter;
import com.limegroup.gnutella.filters.PhraseFilter;
import com.limegroup.gnutella.filters.URNFilter;
import com.limegroup.gnutella.filters.response.AltLocFilter;
import com.limegroup.gnutella.filters.response.CompoundResponseFilter;
import com.limegroup.gnutella.filters.response.MandragoreWormFilter;
import com.limegroup.gnutella.filters.response.MutableGUIDFilter;
import com.limegroup.gnutella.filters.response.NoExtensionFilter;
import com.limegroup.gnutella.filters.response.ProgramsFilter;
import com.limegroup.gnutella.filters.response.ResponseFilter;
import com.limegroup.gnutella.filters.response.ResponseFilterFactory;
import com.limegroup.gnutella.filters.response.ResponseQueryFilter;
import com.limegroup.gnutella.filters.response.ResponseTypeFilter;
import com.limegroup.gnutella.filters.response.SecureResultFilter;
import com.limegroup.gnutella.filters.response.WhiteListUpdateUrnFilter;
import com.limegroup.gnutella.filters.response.XMLDocFilter;
import java.util.ArrayList;
import java.util.Collections;
import org.limewire.core.settings.FilterSettings;

@Singleton
class ResponseFilterFactoryImpl
implements ResponseFilterFactory {
    private final Provider<XMLDocFilter> xmlDocFilter;
    private final Provider<MandragoreWormFilter> wormFilter;
    private final Provider<ResponseQueryFilter> queryFilter;
    private final Provider<ProgramsFilter> programsFilter;
    private final Provider<SecureResultFilter> secureResultFilter;
    private final Provider<ResponseTypeFilter> typeFilter;
    private final Provider<WhiteListUpdateUrnFilter> whiteListUpdateUrnFilter;
    private final Provider<MutableGUIDFilter> mutableGUIDFilter;
    private final Provider<KeywordFilter> keywordFilter;
    private final Provider<URNFilter> urnFilter;
    private final Provider<AltLocFilter> altLocFilter;
    private final Provider<PhraseFilter> phraseFilter;
    private final Provider<NoExtensionFilter> noExtensionFilter;

    @Inject
    public ResponseFilterFactoryImpl(Provider<XMLDocFilter> xmlDocFilter, Provider<MandragoreWormFilter> wormFilter, Provider<ResponseQueryFilter> queryFilter, Provider<ProgramsFilter> programsFilter, Provider<SecureResultFilter> secureResultFilter, Provider<ResponseTypeFilter> typeFilter, Provider<WhiteListUpdateUrnFilter> whiteListUpdateUrnFilter, Provider<MutableGUIDFilter> mutableGUIDFilter, Provider<KeywordFilter> keywordFilter, Provider<URNFilter> urnFilter, Provider<AltLocFilter> altLocFilter, Provider<PhraseFilter> phraseFilter, Provider<NoExtensionFilter> noExtensionFilter) {
        this.xmlDocFilter = xmlDocFilter;
        this.wormFilter = wormFilter;
        this.queryFilter = queryFilter;
        this.programsFilter = programsFilter;
        this.secureResultFilter = secureResultFilter;
        this.typeFilter = typeFilter;
        this.whiteListUpdateUrnFilter = whiteListUpdateUrnFilter;
        this.mutableGUIDFilter = mutableGUIDFilter;
        this.keywordFilter = keywordFilter;
        this.urnFilter = urnFilter;
        this.altLocFilter = altLocFilter;
        this.phraseFilter = phraseFilter;
        this.noExtensionFilter = noExtensionFilter;
    }

    @Override
    public ResponseFilter createResponseFilter() {
        ArrayList<ResponseFilter> filters = new ArrayList<ResponseFilter>();
        filters.add(this.altLocFilter.get());
        filters.add(this.urnFilter.get());
        filters.add(this.keywordFilter.get());
        if (FilterSettings.FILTER_ADULT.getValue()) {
            filters.add(this.mutableGUIDFilter.get());
        }
        filters.add(this.wormFilter.get());
        filters.add(this.queryFilter.get());
        filters.add(this.typeFilter.get());
        filters.add(this.secureResultFilter.get());
        filters.add(this.programsFilter.get());
        filters.add(this.xmlDocFilter.get());
        filters.add(this.phraseFilter.get());
        filters.add(this.noExtensionFilter.get());
        return new CompoundResponseFilter(filters, Collections.singletonList(this.whiteListUpdateUrnFilter.get()));
    }
}

