/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.hashing;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.hashing.FLACNonMetaDataHasher;
import com.limegroup.gnutella.hashing.MP3NonMetaDataHasher;
import com.limegroup.gnutella.hashing.NonMetaDataHasher;
import com.limegroup.gnutella.hashing.OGGNonMetaDataHasher;
import java.io.File;
import java.io.IOException;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.util.FileUtils;

public class AudioHashingUtils {
    private static final Log LOG = LogFactory.getLog(AudioHashingUtils.class);

    public static URN generateNonMetaDataSHA1FromFile(File file) throws InterruptedException {
        if (!AudioHashingUtils.canCreateNonMetaDataSHA1(file)) {
            return null;
        }
        try {
            NonMetaDataHasher hasher = AudioHashingUtils.getHasher(file);
            long startPosition = hasher.getStartPosition();
            long length = hasher.getEndPosition();
            return URN.generateNMS1FromFile(file, startPosition, length -= startPosition);
        }
        catch (IOException e) {
            LOG.error("IOException reading file: " + file.getName(), e);
        }
        catch (NumberFormatException e) {
            LOG.error("Illegal value while parsing tag size: " + file.getName(), e);
        }
        return null;
    }

    public static NonMetaDataHasher getHasher(File file) {
        String ext = FileUtils.getFileExtension(file);
        if (ext.equalsIgnoreCase("mp3")) {
            return new MP3NonMetaDataHasher(file);
        }
        if (ext.equalsIgnoreCase("flac")) {
            return new FLACNonMetaDataHasher(file);
        }
        if (ext.equalsIgnoreCase("ogg")) {
            return new OGGNonMetaDataHasher(file);
        }
        LOG.error("Attempted to create a Hasher for an unsupported file type: " + file.getName());
        throw new IllegalArgumentException(ext + " not supported nmsha1 format");
    }

    public static boolean canCreateNonMetaDataSHA1(File file) {
        String ext = FileUtils.getFileExtension(file);
        return ext.equalsIgnoreCase("mp3") || ext.equalsIgnoreCase("flac") || ext.equalsIgnoreCase("ogg");
    }
}

