/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.hashing;

import com.limegroup.gnutella.hashing.NonMetaDataHasher;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.TagException;
import org.limewire.util.StringUtils;

class MP3NonMetaDataHasher
extends NonMetaDataHasher {
    private static final String LYRICSBEGIN = "LYRICSBEGIN";
    private static final String LYRICSEND_V1 = "LYRICSEND";
    private static final String LYRICSEND_V2 = "LYRICS200";
    private static final String APETAG = "APETAGEX";
    private final File file;

    MP3NonMetaDataHasher(File file) {
        this.file = file;
    }

    @Override
    public long getStartPosition() throws IOException {
        try {
            AudioFile audioFile = AudioFileIO.read(this.file);
            if (!(audioFile instanceof MP3File)) {
                throw new IOException("Cannot cast to a MP3File");
            }
            MP3File mp3File = (MP3File)audioFile;
            return mp3File.getMP3StartByte(mp3File.getFile());
        }
        catch (InvalidAudioFrameException e) {
            throw new IOException(e);
        }
        catch (CannotReadException e) {
            throw new IOException(e);
        }
        catch (TagException e) {
            throw new IOException(e);
        }
        catch (ReadOnlyFileException e) {
            throw new IOException(e);
        }
    }

    @Override
    public long getEndPosition() throws IOException {
        AudioFile audioFile;
        try {
            audioFile = AudioFileIO.read(this.file);
        }
        catch (CannotReadException e) {
            throw new IOException(e);
        }
        catch (TagException e) {
            throw new IOException(e);
        }
        catch (ReadOnlyFileException e) {
            throw new IOException(e);
        }
        catch (InvalidAudioFrameException e) {
            throw new IOException(e);
        }
        if (!(audioFile instanceof MP3File)) {
            throw new IOException("Cannot cast to a MP3File");
        }
        MP3File mp3File = (MP3File)audioFile;
        long fileLength = this.file.length();
        int offset = 0;
        if (mp3File.hasID3v1Tag()) {
            LOG.debug("found ID3v1 tag");
            offset = 128;
            fileLength -= 128L;
        }
        ByteBuffer buffer = ByteBuffer.allocate(32);
        MP3NonMetaDataHasher.fillBuffer(buffer, mp3File.getFile(), offset);
        if (buffer.limit() < 32) {
            throw new IOException("Couldn't fill buffer while parsing footers");
        }
        String lyricsTag = MP3NonMetaDataHasher.getLyricsFooterTag(buffer);
        if (LYRICSEND_V1.equals(lyricsTag)) {
            LOG.debug("found LYRICS3 footer tag");
            ByteBuffer newByteBuffer = ByteBuffer.allocate(5109);
            MP3NonMetaDataHasher.fillBuffer(newByteBuffer, mp3File.getFile(), offset);
            fileLength -= MP3NonMetaDataHasher.getSizeLyricsTagV1(newByteBuffer);
        } else if (LYRICSEND_V2.equals(lyricsTag)) {
            LOG.debug("found LYRICS3v2 footer tag");
            fileLength -= MP3NonMetaDataHasher.getSizeLyricsTagV2(buffer, offset, mp3File);
        }
        if (MP3NonMetaDataHasher.containsAPETag(buffer)) {
            LOG.debug("found APE footer tag");
            fileLength -= MP3NonMetaDataHasher.getSizeAPETag(buffer, offset, mp3File);
        }
        return fileLength;
    }

    private static String getLyricsFooterTag(ByteBuffer buffer) {
        byte[] bytes = new byte[9];
        buffer.position(buffer.limit() - 9);
        buffer.get(bytes);
        return StringUtils.getASCIIString(bytes);
    }

    private static long getSizeLyricsTagV1(ByteBuffer buffer) throws IOException {
        byte[] bytes = new byte[11];
        for (int i = 0; i < buffer.limit() - bytes.length; ++i) {
            buffer.position(i);
            buffer.get(bytes);
            if (!LYRICSBEGIN.equals(StringUtils.getASCIIString(bytes))) continue;
            LOG.debug("found LYRICS3 header tag");
            return buffer.limit() - i;
        }
        throw new IOException("Could not find BEGIN LYRICS3v1 tag");
    }

    private static long getSizeLyricsTagV2(ByteBuffer buffer, int offset, MP3File mp3File) throws NumberFormatException, IOException {
        buffer.position(buffer.limit() - 9 - 6);
        byte[] bytes = new byte[6];
        buffer.get(bytes);
        long startOfTag = Long.parseLong(StringUtils.getASCIIString(bytes));
        if (startOfTag <= 0L || startOfTag + 9L + 6L + (long)offset > mp3File.getFile().length()) {
            throw new IOException("LYRICS3v2 tag size too large");
        }
        ByteBuffer newByteBuffer = ByteBuffer.allocate(11);
        MP3NonMetaDataHasher.fillBuffer(newByteBuffer, mp3File.getFile(), (int)((long)offset + startOfTag + 6L + 9L - (long)newByteBuffer.capacity()));
        String beginTag = StringUtils.getASCIIString(newByteBuffer.array());
        if (LYRICSBEGIN.equals(beginTag)) {
            LOG.debug("found LYRICS3v2 header tag");
            return 15L + startOfTag;
        }
        throw new IOException("Could not locate BEGIN LYRICS3v2 tag");
    }

    private static boolean containsAPETag(ByteBuffer buffer) {
        byte[] bytes = new byte[8];
        buffer.position(buffer.limit() - 32);
        buffer.get(bytes);
        String footerTag = StringUtils.getASCIIString(bytes);
        return APETAG.equals(footerTag);
    }

    private static long getSizeAPETag(ByteBuffer buffer, int offset, MP3File mp3File) throws IOException {
        byte[] bytes = new byte[32];
        buffer.position(buffer.limit() - 32);
        buffer.get(bytes);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int tagSize = buffer.getInt(12);
        if (tagSize <= 0 || (long)(offset + tagSize + 32) > mp3File.getFile().length()) {
            throw new IOException("APE tagsize too large");
        }
        ByteBuffer newByteBuffer = ByteBuffer.allocate(8);
        MP3NonMetaDataHasher.fillBuffer(newByteBuffer, mp3File.getFile(), offset + tagSize + 32 - newByteBuffer.capacity());
        String headerTag = StringUtils.getASCIIString(newByteBuffer.array());
        LOG.debug("found APE header tag");
        if (APETAG.equals(headerTag)) {
            return tagSize + 32;
        }
        return tagSize;
    }
}

