/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.hashing;

import com.limegroup.gnutella.hashing.NonMetaDataHasher;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.ogg.OggVorbisTagReader;
import org.limewire.io.IOUtils;

class OGGNonMetaDataHasher
extends NonMetaDataHasher {
    private final File file;

    OGGNonMetaDataHasher(File file) {
        this.file = file;
    }

    @Override
    public long getStartPosition() throws IOException {
        long l;
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(this.file, "r");
            OggVorbisTagReader reader = new OggVorbisTagReader();
            OggVorbisTagReader.OggVorbisHeaderSizes tag = reader.readOggVorbisHeaderSizes(raf);
            l = tag.getCommentHeaderStartPosition() + (long)tag.getCommentHeaderSize() + (long)tag.getSetupHeaderSize() + (long)tag.getExtraPacketDataSize();
        }
        catch (CannotReadException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.close(raf);
                throw throwable;
            }
        }
        IOUtils.close(raf);
        return l;
    }

    @Override
    public long getEndPosition() throws IOException {
        return this.file.length();
    }
}

