/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.library;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnSet;
import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.library.FileDescChangeEvent;
import com.limegroup.gnutella.library.RareFileStrategy;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.licenses.LicenseFactory;
import com.limegroup.gnutella.licenses.LicenseType;
import com.limegroup.gnutella.routing.HashFunction;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.limewire.core.settings.DHTSettings;
import org.limewire.listener.EventListener;
import org.limewire.listener.SourcedEventMulticaster;
import org.limewire.util.I18NConvert;
import org.limewire.util.Objects;

class FileDescImpl
implements FileDesc {
    private final int index;
    private volatile UrnSet urns;
    private final File file;
    private License _license;
    private final CopyOnWriteArrayList<LimeXMLDocument> _limeXMLDocs = new CopyOnWriteArrayList();
    private final long fileSize;
    private final long lastModified;
    private int hits;
    private int _attemptedUploads;
    private long lastAttemptedUploadTime = System.currentTimeMillis();
    private int _completedUploads;
    private volatile boolean storeFile;
    private volatile boolean isShareable = true;
    private final SourcedEventMulticaster<FileDescChangeEvent, FileDesc> multicaster;
    private final RareFileStrategy rareFileStrategy;
    private final LicenseFactory licenseFactory;
    private final ConcurrentHashMap<String, Object> clientProperties = new ConcurrentHashMap(4, 0.75f, 1);

    FileDescImpl(RareFileStrategy rareFileStrategy, LicenseFactory licenseFactory, SourcedEventMulticaster<FileDescChangeEvent, FileDesc> multicaster, File file, Set<? extends URN> urns, int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("negative index (" + index + ") not permitted in FileDesc");
        }
        this.fileSize = file.length();
        assert (this.fileSize >= 0L && this.fileSize <= 0xFFFFFFFFFFL) : "invalid size " + this.fileSize + " of file " + file;
        Objects.nonNull(urns, "urns");
        this.rareFileStrategy = rareFileStrategy;
        this.multicaster = multicaster;
        this.licenseFactory = licenseFactory;
        this.file = Objects.nonNull(file, "file");
        this.index = index;
        this.urns = UrnSet.unmodifiableSet(urns);
        this.lastModified = file.lastModified();
        this.hits = 0;
    }

    @Override
    public boolean isRareFile() {
        return this.rareFileStrategy.isRareFile(this);
    }

    public boolean hasUrns() {
        return !this.urns.isEmpty();
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public long getFileSize() {
        return this.fileSize;
    }

    @Override
    public String getFileName() {
        return I18NConvert.instance().compose(this.file.getName());
    }

    @Override
    public long lastModified() {
        return this.lastModified;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public URN getTTROOTUrn() {
        return this.urns.getTTRoot();
    }

    @Override
    public URN getSHA1Urn() {
        return this.urns.getSHA1();
    }

    @Override
    public URN getNMS1Urn() {
        return this.urns.getNMS1();
    }

    @Override
    public void addUrn(URN urn) {
        boolean contained = this.urns.contains(urn);
        if (!contained) {
            UrnSet newSet = UrnSet.modifiableSet(this.urns);
            newSet.add(urn);
            this.urns = UrnSet.unmodifiableSet(newSet);
            if (this.multicaster != null && urn.isTTRoot()) {
                this.multicaster.handleEvent(new FileDescChangeEvent((FileDesc)this, FileDescChangeEvent.Type.TT_ROOT_ADDED, urn));
            }
            if (this.multicaster != null && urn.isNMS1()) {
                this.multicaster.handleEvent(new FileDescChangeEvent((FileDesc)this, FileDescChangeEvent.Type.NMS1_ADDED, urn));
            }
        }
    }

    @Override
    public Set<URN> getUrns() {
        return this.urns;
    }

    @Override
    public String getPath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public void addLimeXMLDocument(LimeXMLDocument doc) {
        this._limeXMLDocs.add(doc);
        doc.initIdentifier(this.file);
        this.assignLicense(doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replaceLimeXMLDocument(LimeXMLDocument oldDoc, LimeXMLDocument newDoc) {
        CopyOnWriteArrayList<LimeXMLDocument> copyOnWriteArrayList = this._limeXMLDocs;
        synchronized (copyOnWriteArrayList) {
            int index = this._limeXMLDocs.indexOf(oldDoc);
            if (index == -1) {
                return false;
            }
            this._limeXMLDocs.set(index, newDoc);
        }
        newDoc.initIdentifier(this.file);
        this.assignLicense(newDoc);
        return true;
    }

    private void assignLicense(LimeXMLDocument doc) {
        String license;
        this._license = null;
        this._license = doc.isLicenseAvailable() ? ((license = doc.getLicenseString()) != null ? this.licenseFactory.create(license) : null) : null;
        boolean bl = this.storeFile = doc.getLicenseString() != null && (doc.getLicenseString().equals(LicenseType.LIMEWIRE_STORE_PURCHASE.name()) || doc.getLicenseString().equals(LicenseType.LIMEWIRE_STORE_RESHAREABLE.name()));
        if (doc.getLicenseString() != null && doc.getLicenseString().equals(LicenseType.LIMEWIRE_STORE_PURCHASE.name())) {
            this.isShareable = false;
        }
    }

    @Override
    public boolean removeLimeXMLDocument(LimeXMLDocument toRemove) {
        if (!this._limeXMLDocs.remove(toRemove)) {
            return false;
        }
        if (this._license != null && toRemove.isLicenseAvailable()) {
            this._license = null;
        }
        return true;
    }

    @Override
    public List<LimeXMLDocument> getLimeXMLDocuments() {
        return this._limeXMLDocs;
    }

    @Override
    public LimeXMLDocument getXMLDocument() {
        List<LimeXMLDocument> docs = this.getLimeXMLDocuments();
        return docs.isEmpty() ? null : docs.get(0);
    }

    @Override
    public LimeXMLDocument getXMLDocument(String schemaURI) {
        for (LimeXMLDocument doc : this.getLimeXMLDocuments()) {
            if (!doc.getSchemaURI().equalsIgnoreCase(schemaURI)) continue;
            return doc;
        }
        return null;
    }

    @Override
    public boolean isLicensed() {
        return this._license != null;
    }

    @Override
    public License getLicense() {
        return this._license;
    }

    @Override
    public boolean containsUrn(URN urn) {
        return this.urns.contains(urn);
    }

    @Override
    public int incrementHitCount() {
        return ++this.hits;
    }

    @Override
    public int getHitCount() {
        return this.hits;
    }

    @Override
    public synchronized int incrementAttemptedUploads() {
        this.lastAttemptedUploadTime = System.currentTimeMillis();
        return ++this._attemptedUploads;
    }

    @Override
    public synchronized int getAttemptedUploads() {
        return this._attemptedUploads;
    }

    @Override
    public synchronized long getLastAttemptedUploadTime() {
        return this.lastAttemptedUploadTime;
    }

    @Override
    public int incrementCompletedUploads() {
        return ++this._completedUploads;
    }

    @Override
    public int getCompletedUploads() {
        return this._completedUploads;
    }

    public String toString() {
        return "FileDesc:\r\nname:     " + this.getFileName() + "\r\n" + "index:    " + this.index + "\r\n" + "path:     " + this.getPath() + "\r\n" + "size:     " + this.getFileSize() + "\r\n" + "modTime:  " + this.lastModified() + "\r\n" + "File:     " + this.file + "\r\n" + "urns:     " + this.urns + "\r\n" + "docs:     " + this._limeXMLDocs + "\r\n";
    }

    @Override
    public String lookup(String key) {
        if (key == null) {
            return null;
        }
        if ("hits".equals(key)) {
            return String.valueOf(this.getHitCount());
        }
        if ("ups".equals(key)) {
            return String.valueOf(this.getAttemptedUploads());
        }
        if ("cups".equals(key)) {
            return String.valueOf(this.getCompletedUploads());
        }
        if ("lastup".equals(key)) {
            return String.valueOf(System.currentTimeMillis() - this.getLastAttemptedUploadTime());
        }
        if ("licensed".equals(key)) {
            return String.valueOf(this.isLicensed());
        }
        if ("atUpSet".equals(key)) {
            return DHTSettings.RARE_FILE_ATTEMPTED_UPLOADS.getValueAsString();
        }
        if ("cUpSet".equals(key)) {
            return DHTSettings.RARE_FILE_COMPLETED_UPLOADS.getValueAsString();
        }
        if ("rftSet".equals(key)) {
            return DHTSettings.RARE_FILE_TIME.getValueAsString();
        }
        if ("hasXML".equals(key)) {
            return String.valueOf(this.getXMLDocument() != null);
        }
        if ("size".equals(key)) {
            return String.valueOf(this.getFileSize());
        }
        if ("lastM".equals(key)) {
            return String.valueOf(this.lastModified());
        }
        if ("numKW".equals(key)) {
            return String.valueOf(HashFunction.keywords(this.getPath()).length);
        }
        if ("numKWP".equals(key)) {
            return String.valueOf(HashFunction.getPrefixes(HashFunction.keywords(this.getPath())).length);
        }
        if (key.startsWith("xml_") && this.getXMLDocument() != null) {
            key = key.substring(4, key.length());
            return this.getXMLDocument().lookup(key);
        }
        return null;
    }

    @Override
    public boolean isStoreFile() {
        return this.storeFile;
    }

    @Override
    public boolean isShareable() {
        return this.isShareable;
    }

    @Override
    public void addListener(EventListener<FileDescChangeEvent> listener) {
        this.multicaster.addListener(this, listener);
    }

    @Override
    public boolean removeListener(EventListener<FileDescChangeEvent> listener) {
        return this.multicaster.removeListener(this, listener);
    }

    @Override
    public Object getClientProperty(String property) {
        return this.clientProperties.get(property);
    }

    @Override
    public void putClientProperty(String property, Object value) {
        this.clientProperties.put(property, value);
    }
}

