/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.library;

import com.limegroup.gnutella.library.LibraryUtils;
import com.limegroup.gnutella.library.OldLibrarySettings;
import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.limewire.core.api.Category;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.settings.SharingSettings;
import org.limewire.util.FileUtils;

class LibraryConverterHelper {
    private final FileAdder fileAdder;
    private final CategoryManager categoryManager;

    LibraryConverterHelper(FileAdder fileAdder, CategoryManager categoryManager) {
        this.fileAdder = fileAdder;
        this.categoryManager = categoryManager;
    }

    void convertSaveDirectories(List<File> excludedFolders, List<File> excludedFiles, Set<File> convertedDirectories) {
        this.convertDirectory(SharingSettings.getSaveDirectory(), null, excludedFolders, excludedFiles, convertedDirectories, false);
        this.convertDirectory(SharingSettings.getFileSettingForCategory(Category.AUDIO).get(), null, excludedFolders, excludedFiles, convertedDirectories, false);
        this.convertDirectory(SharingSettings.getFileSettingForCategory(Category.VIDEO).get(), null, excludedFolders, excludedFiles, convertedDirectories, false);
        this.convertDirectory(SharingSettings.getFileSettingForCategory(Category.IMAGE).get(), null, excludedFolders, excludedFiles, convertedDirectories, false);
        this.convertDirectory(SharingSettings.getFileSettingForCategory(Category.OTHER).get(), null, excludedFolders, excludedFiles, convertedDirectories, false);
        this.convertDirectory(SharingSettings.getFileSettingForCategory(Category.PROGRAM).get(), null, excludedFolders, excludedFiles, convertedDirectories, false);
        this.convertDirectory(SharingSettings.getFileSettingForCategory(Category.DOCUMENT).get(), null, excludedFolders, excludedFiles, convertedDirectories, false);
        this.convertDirectory(OldLibrarySettings.DIRECTORY_FOR_SAVING_LWS_FILES.get(), Collections.singletonList("mp3"), excludedFolders, excludedFiles, convertedDirectories, true);
    }

    void convertDirectory(File directory, final List<String> extensions, final List<File> excludedFolders, final List<File> excludedFiles, Set<File> convertedDirectories, boolean recurse) {
        File[] dirList;
        if (!directory.exists() || convertedDirectories.contains(directory) || excludedFolders.contains(directory)) {
            return;
        }
        convertedDirectories.add(directory);
        File[] fileList = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return LibraryUtils.isFileManagable(file, LibraryConverterHelper.this.categoryManager) && (extensions == null || extensions.contains(FileUtils.getFileExtension(file).toLowerCase(Locale.US))) && !excludedFiles.contains(file);
            }
        });
        if (fileList != null) {
            for (File file : fileList) {
                file = FileUtils.canonicalize(file);
                this.fileAdder.addFile(file);
            }
        }
        if (!LibraryUtils.isForcedShareDirectory(directory) && recurse && (dirList = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File folder) {
                return folder.isDirectory() && folder.canRead() && !LibraryConverterHelper.isIncompleteDirectory(folder) && !LibraryUtils.isApplicationSpecialShareDirectory(folder) && !LibraryUtils.isFolderBanned(folder) && !excludedFolders.contains(folder);
            }
        })) != null) {
            for (File subdir : dirList) {
                this.convertDirectory(subdir, extensions, excludedFolders, excludedFiles, convertedDirectories, recurse);
            }
        }
    }

    private static boolean isIncompleteDirectory(File folder) {
        return FileUtils.canonicalize(SharingSettings.INCOMPLETE_DIRECTORY.get()).equals(folder);
    }

    static interface FileAdder {
        public void addFile(File var1);
    }
}

