/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.malware;

import com.google.inject.Inject;
import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.ComFailException;
import com.jacob.com.ComThread;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import com.limegroup.gnutella.malware.AntivirusSupportConfiguration;
import com.limegroup.gnutella.malware.VirusDefinitionManager;
import com.limegroup.gnutella.malware.VirusScanException;
import com.limegroup.gnutella.malware.VirusScanner;
import com.limegroup.gnutella.malware.VirusUtils;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIFunctionMapper;
import com.sun.jna.win32.W32APITypeMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.limewire.activation.api.ActivationID;
import org.limewire.activation.api.ActivationManager;
import org.limewire.activation.api.ActivationModuleEvent;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.concurrent.ThreadPoolListeningExecutor;
import org.limewire.core.api.malware.VirusEngine;
import org.limewire.core.settings.DownloadSettings;
import org.limewire.inject.EagerSingleton;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.listener.EventListener;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.setting.IntSetting;
import org.limewire.setting.PropertiesSetting;
import org.limewire.util.FileUtils;
import org.limewire.util.StringUtils;
import org.limewire.util.SystemUtils;

@EagerSingleton
class VirusScannerImpl
implements VirusScanner,
Service {
    private static final Log LOG = LogFactory.getLog(VirusScannerImpl.class);
    private final VirusDefinitionManager virusDefinitionManager;
    private final ExecutorService queue;
    private volatile int definitionsVersion = -1;
    private boolean comInitialized = false;
    private Dispatch avg = null;
    private boolean vdbLoaded = false;
    private volatile boolean loadFailed = false;
    private AntivirusSupportConfiguration supportConfiguration;
    private volatile Thread comThread;
    private volatile Boolean canLoadAvg = null;

    @Inject
    VirusScannerImpl(VirusDefinitionManager virusDefinitionManager, AntivirusSupportConfiguration supportConfiguration) {
        LOG.debug("Creating VirusScannerImpl");
        this.virusDefinitionManager = virusDefinitionManager;
        this.supportConfiguration = supportConfiguration;
        ThreadPoolListeningExecutor executor = ExecutorsHelper.newSingleThreadExecutor(ExecutorsHelper.daemonThreadFactory("VirusScannerThread"));
        executor.allowCoreThreadTimeOut(false);
        this.queue = ExecutorsHelper.unconfigurableExecutorService(executor);
        this.queue.execute(new Runnable(){

            @Override
            public void run() {
                VirusScannerImpl.this.comThread = Thread.currentThread();
            }
        });
    }

    @Inject
    public void register(ServiceRegistry serviceRegistry, ActivationManager activationManager) {
        serviceRegistry.register(this);
        activationManager.addModuleListener(new EventListener<ActivationModuleEvent>(){

            @Override
            public void handleEvent(ActivationModuleEvent event) {
                if (event.getData() == ActivationID.AVG_MODULE) {
                    VirusScannerImpl.this.stop();
                }
            }
        });
    }

    @Override
    public void initialize() {
    }

    @Override
    public void start() {
    }

    @Override
    public String getServiceName() {
        return "AntiVirusService";
    }

    private <T> T runAndGet(Callable<T> callable) throws InterruptedException, ExecutionException {
        if (Thread.currentThread() == this.comThread) {
            try {
                return callable.call();
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            catch (Throwable e) {
                throw new ExecutionException(e);
            }
        }
        return this.queue.submit(callable).get();
    }

    @Override
    public void stop() {
        try {
            this.runAndGet(new StopCommand());
        }
        catch (ExecutionException e) {
            LOG.debug("Failed to stop", e);
        }
        catch (InterruptedException e) {
            LOG.debug("Failed to stop", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldBeSupported() {
        VirusScannerImpl virusScannerImpl = this;
        synchronized (virusScannerImpl) {
            if (!this.supportConfiguration.isAVGCompatibleWindows()) {
                LOG.debug("Not supported: incompatible OS");
                return false;
            }
            if (this.supportConfiguration.isAVGModuleActivated()) {
                LOG.debug("Supported: AVG Module Activated");
                return true;
            }
            LOG.debug("Not supported: AVG Module not activated");
            return false;
        }
    }

    @Override
    public boolean isSupported() {
        LOG.debug("entered isSupported();");
        boolean canSupport = false;
        boolean canLoad = false;
        if (this.shouldBeSupported()) {
            if (this.supportConfiguration.isTemporaryDirectoryInUse()) {
                LOG.debug("Not supported: temporary settings directory");
            } else {
                canSupport = true;
            }
            if (canSupport) {
                canLoad = this.isAvgLoadable();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("shouldBeSupported(); canSupport <" + canSupport + "> canLoad <" + canLoad + ">");
        }
        return canSupport && canLoad;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAvgLoadable() {
        VirusScannerImpl virusScannerImpl = this;
        synchronized (virusScannerImpl) {
            if (this.canLoadAvg == null) {
                try {
                    this.canLoadAvg = this.loadAvgInComThread();
                }
                catch (VirusScanException e) {
                    this.canLoadAvg = false;
                }
            }
        }
        return this.canLoadAvg;
    }

    @Override
    public boolean isEnabled() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("entered isEnabled(); shouldBeSupported() <" + this.shouldBeSupported() + "> supportConfiguration.isVirusScannerEnabledInSettings() <" + this.supportConfiguration.isVirusScannerEnabledInSettings() + ">");
        }
        return this.shouldBeSupported() && this.supportConfiguration.isVirusScannerEnabledInSettings();
    }

    private String readLicense() throws IOException {
        try {
            return new String(new byte[]{76, 105, 99, 66, 101, 103, 44, 32, 86, 101, 114, 61, 49, 46, 48, 44, 32, 78, 97, 109, 101, 61, 34, 76, 105, 109, 101, 87, 105, 114, 101, 34, 44, 32, 69, 120, 112, 61, 50, 48, 49, 50, 45, 49, 49, 45, 49, 57, 44, 32, 83, 105, 103, 110, 61, 100, 54, 108, 98, 120, 102, 100, 122, 84, 88, 65, 106, 111, 81, 52, 110, 107, 79, 75, 89, 85, 99, 104, 47, 86, 69, 68, 49, 78, 67, 118, 53, 55, 120, 49, 69, 97, 48, 97, 122, 106, 110, 89, 114, 118, 50, 80, 87, 86, 110, 104, 69, 49, 100, 76, 90, 70, 72, 74, 87, 71, 55, 71, 122, 122, 51, 88, 90, 76, 82, 72, 74, 112, 76, 70, 57, 104, 113, 101, 120, 99, 70, 69, 75, 48, 100, 98, 57, 110, 82, 112, 103, 50, 115, 47, 53, 115, 85, 117, 104, 86, 88, 121, 50, 84, 103, 116, 79, 87, 101, 48, 110, 81, 81, 113, 71, 71, 52, 57, 82, 107, 108, 73, 76, 68, 72, 108, 85, 119, 104, 113, 84, 83, 74, 122, 82, 75, 90, 112, 71, 74, 97, 70, 57, 51, 57, 90, 70, 87, 90, 89, 75, 70, 70, 79, 51, 85, 97, 54, 76, 72, 108, 47, 120, 95, 79, 50, 70, 53, 89, 73, 44, 32, 76, 105, 99, 69, 110, 100}, "UTF8");
        }
        catch (UnsupportedEncodingException ignored) {
            File licenseFile = VirusUtils.getLicenseFile();
            if (!licenseFile.exists()) {
                throw new IOException("License file not found");
            }
            byte[] license = FileUtils.readFileFully(licenseFile);
            if (license == null || license.length == 0) {
                throw new IOException("Error reading license");
            }
            return new String(license);
        }
    }

    private boolean loadAvgInComThread() throws VirusScanException {
        if (this.loadFailed) {
            throw new VirusScanException("failed to load AVG last time we tried, aborting early.");
        }
        try {
            return this.runAndGet(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    if (VirusScannerImpl.this.avg == null) {
                        VirusScannerImpl.this.loadAvgDirectly();
                    }
                    return VirusScannerImpl.this.avg != null;
                }
            });
        }
        catch (InterruptedException e) {
            throw new VirusScanException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof VirusScanException) {
                throw (VirusScanException)e.getCause();
            }
            throw new VirusScanException(e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadAvgDirectly() throws VirusScanException {
        boolean bl;
        LOG.debug("Loading AVG SDK...");
        try {
            ComThread.InitMTA();
            this.comInitialized = true;
            this.avg = new ActiveXComponent("AvgSdkCom.AvgSdk", 4).getObject();
            Dispatch.call((Dispatch)this.avg, (String)"InitializeLicense", (Object)this.readLicense());
            LOG.debug("...Loaded AVG");
            bl = this.avg == null;
        }
        catch (ComFailException e) {
            try {
                this.uninitialize();
                int hr = e.getHResult();
                LOG.debugf(e, "Failed to initialize: {0}", hr);
                throw new VirusScanException("hr: " + hr, e);
                catch (IOException e2) {
                    this.uninitialize();
                    LOG.debugf(e2, "Error reading license", new Object[0]);
                    throw new VirusScanException(e2);
                }
            }
            catch (Throwable throwable) {
                this.loadFailed = this.avg == null;
                throw throwable;
            }
        }
        this.loadFailed = bl;
    }

    private void initializeLazily() throws VirusScanException {
        if (this.avg == null) {
            this.loadAvgDirectly();
        }
        if (!this.vdbLoaded) {
            LOG.debug("Loading VDBs...");
            this.getDefinitionsVersion();
            if (this.definitionsVersion == 0) {
                throw new VirusScanException("No virus definitions", VirusEngine.HintReason.NO_DEFINITIONS);
            }
            File db = VirusUtils.getDatabaseDirectory();
            try {
                Dispatch.call((Dispatch)this.avg, (String)"LoadVdbFiles", (Object)db.getAbsolutePath());
                this.vdbLoaded = true;
                LOG.debug("... Loaded VDBs");
            }
            catch (ComFailException e) {
                this.uninitialize();
                FileUtils.forceDeleteRecursive(db);
                this.definitionsVersion = 0;
                this.virusDefinitionManager.checkForDefinitions();
                int hr = e.getHResult();
                LOG.debugf(e, "Failed to load definitions: {0}", hr);
                throw new VirusScanException("hr: " + hr, e);
            }
        }
    }

    @Override
    public int getDefinitionsVersion() {
        if (this.definitionsVersion == -1) {
            File db = VirusUtils.getDatabaseDirectory();
            File nfo = new File(db, "version.nfo");
            try {
                String version = VirusUtils.getNfoValue(nfo, "VDB_RELEASE_VERSION");
                this.definitionsVersion = Integer.parseInt(version);
            }
            catch (FileNotFoundException e) {
                LOG.debug("Cannot find version.nfo");
                this.definitionsVersion = 0;
            }
            catch (IOException e) {
                LOG.debug("Cannot find VBD_RELEASE_VERSION");
                this.definitionsVersion = 0;
            }
            catch (NumberFormatException e) {
                LOG.debug("Cannot parse VDB_RELEASE_VERSION");
                this.definitionsVersion = 0;
            }
        }
        LOG.debugf("Virus definitions version {0}", (Object)this.definitionsVersion);
        return this.definitionsVersion;
    }

    @Override
    public long getLibraryBuildVersion() throws IOException {
        try {
            Long v = this.runAndGet(new GetLibraryVersionCommand());
            if (v == null) {
                return 0L;
            }
            return v;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean isInfected(File file) throws VirusScanException {
        if (!this.isSupported()) {
            throw new VirusScanException("Not supported!", VirusEngine.HintReason.NOT_SUPPORTED);
        }
        try {
            boolean result = this.runAndGet(new ScanCommand(file));
            return result;
        }
        catch (ExecutionException e) {
            DownloadSettings.NUM_SCANS_FAILED.set(DownloadSettings.NUM_SCANS_FAILED.get() + 1);
            if (e.getCause() instanceof VirusScanException) {
                throw (VirusScanException)e.getCause();
            }
            throw new VirusScanException(e);
        }
        catch (InterruptedException e) {
            DownloadSettings.NUM_SCANS_FAILED.set(DownloadSettings.NUM_SCANS_FAILED.get() + 1);
            throw new VirusScanException(e);
        }
    }

    private void updateStats(File file, boolean infected) {
        IntSetting numScannedInfected = DownloadSettings.NUM_SCANNED_INFECTED;
        IntSetting numScannedClean = DownloadSettings.NUM_SCANNED_CLEAN;
        PropertiesSetting infectedExtensions = DownloadSettings.INFECTED_EXTENSIONS;
        if (infected) {
            Integer numInfectedForExtension;
            numScannedInfected.set(numScannedInfected.get() + 1);
            String ext = FileUtils.getFileExtension(file);
            Properties props = infectedExtensions.get();
            String inf = props.getProperty(ext);
            Integer n = numInfectedForExtension = Integer.valueOf(inf != null ? Integer.valueOf(inf) : 0);
            Integer n2 = numInfectedForExtension = Integer.valueOf(numInfectedForExtension + 1);
            props.put(ext, numInfectedForExtension.toString());
            infectedExtensions.set(props);
        } else {
            numScannedClean.set(numScannedClean.get() + 1);
        }
    }

    @Override
    public void stopScanner() {
        this.stop();
    }

    @Override
    public void loadFullUpdate(File updateDir) throws VirusScanException {
        if (!this.isSupported()) {
            throw new VirusScanException("not supported", VirusEngine.HintReason.NOT_SUPPORTED);
        }
        try {
            this.runAndGet(new LoadFullUpdateCommand(updateDir));
        }
        catch (ExecutionException e) {
            DownloadSettings.NUM_AV_FULL_UPDATES_FAILED.set(DownloadSettings.NUM_AV_FULL_UPDATES_FAILED.get() + 1);
            if (e.getCause() instanceof VirusScanException) {
                throw (VirusScanException)e.getCause();
            }
            throw new VirusScanException(e);
        }
        catch (InterruptedException e) {
            DownloadSettings.NUM_AV_FULL_UPDATES_FAILED.set(DownloadSettings.NUM_AV_FULL_UPDATES_FAILED.get() + 1);
            throw new VirusScanException(e);
        }
        DownloadSettings.NUM_AV_FULL_UPDATES_SUCCEEDED.set(DownloadSettings.NUM_AV_FULL_UPDATES_SUCCEEDED.get() + 1);
    }

    @Override
    public void loadIncrementalUpdate(File updateDir) throws IOException, VirusScanException {
        if (!this.isSupported()) {
            throw new VirusScanException("not supported", VirusEngine.HintReason.NOT_SUPPORTED);
        }
        try {
            this.runAndGet(new LoadIncrementalUpdateCommand(updateDir));
        }
        catch (ExecutionException e) {
            DownloadSettings.NUM_AV_INCREMENTAL_UPDATES_FAILED.set(DownloadSettings.NUM_AV_INCREMENTAL_UPDATES_FAILED.get() + 1);
            if (e.getCause() instanceof VirusScanException) {
                throw (VirusScanException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new VirusScanException(e);
        }
        catch (InterruptedException e) {
            DownloadSettings.NUM_AV_INCREMENTAL_UPDATES_FAILED.set(DownloadSettings.NUM_AV_INCREMENTAL_UPDATES_FAILED.get() + 1);
            throw new VirusScanException(e);
        }
        DownloadSettings.NUM_AV_INCREMENTAL_UPDATES_SUCCEEDED.set(DownloadSettings.NUM_AV_INCREMENTAL_UPDATES_SUCCEEDED.get() + 1);
    }

    private void uninitialize() {
        if (this.avg != null) {
            LOG.debug("Releasing AvgSdk instance");
            this.avg.safeRelease();
            this.avg = null;
        }
        this.vdbLoaded = false;
        if (this.comInitialized) {
            try {
                LOG.debug("Uninitializing COM");
                ComThread.Release();
            }
            catch (ComFailException e) {
                int hr = e.getHResult();
                LOG.debugf(e, "Failed to uninitialize COM: {0}", hr);
            }
            this.comInitialized = false;
        }
        this.definitionsVersion = -1;
    }

    private static interface VersionDll
    extends StdCallLibrary {
        public static final Map UNICODE_OPTIONS = new HashMap(){
            {
                this.put("type-mapper", W32APITypeMapper.UNICODE);
                this.put("function-mapper", W32APIFunctionMapper.UNICODE);
            }
        };
        public static final Map ASCII_OPTIONS = new HashMap(){
            {
                this.put("type-mapper", W32APITypeMapper.ASCII);
                this.put("function-mapper", W32APIFunctionMapper.ASCII);
            }
        };
        public static final Map DEFAULT_OPTIONS = Boolean.getBoolean("w32.ascii") ? ASCII_OPTIONS : UNICODE_OPTIONS;
        public static final VersionDll INSTANCE = (VersionDll)Native.loadLibrary("version", VersionDll.class, DEFAULT_OPTIONS);

        public int GetFileVersionInfoSize(String var1, IntByReference var2);

        public boolean GetFileVersionInfo(String var1, int var2, int var3, Buffer var4);

        public boolean VerQueryValue(Buffer var1, String var2, PointerByReference var3, IntByReference var4);

        public static class VS_FIXEDFILEINFO
        extends Structure {
            public int dwSignature;
            public int dwStrucVersion;
            public int dwFileVersionMS;
            public int dwFileVersionLS;
            public int dwProductVersionMS;
            public int dwProductVersionLS;
            public int dwFileFlagsMask;
            public int dwFileFlags;
            public int dwFileOS;
            public int dwFileType;
            public int dwFileSubtype;
            public int dwFileDateMS;
            public int dwFileDateLS;

            public VS_FIXEDFILEINFO(Pointer p) {
                super(p);
                this.read();
            }
        }
    }

    private static class GetLibraryVersionCommand
    implements Callable<Long> {
        private GetLibraryVersionCommand() {
        }

        @Override
        public Long call() throws IOException {
            LOG.debug("Getting library version.");
            String clsid = SystemUtils.registryReadText("HKEY_CLASSES_ROOT", "AvgSdkCom.AvgSdk\\CLSID", "");
            if (StringUtils.isEmpty(clsid)) {
                throw new IOException("unable to get clsid (registry not setup?)");
            }
            String sdkPath = SystemUtils.registryReadText("HKEY_CLASSES_ROOT", "CLSID\\" + clsid + "\\InprocServer32", "");
            if (StringUtils.isEmpty(sdkPath)) {
                throw new IOException("unable to get path (registry not setup right?)");
            }
            File avgSdkCom = new File(sdkPath).getAbsoluteFile();
            if (avgSdkCom.getParentFile() == null) {
                throw new IOException("No parent path for avgSdkCom [" + avgSdkCom + "]");
            }
            VersionDll v = VersionDll.INSTANCE;
            File avgCoreEx = new File(avgSdkCom.getParentFile(), "avgcorex.dll");
            String corePath = avgCoreEx.getAbsolutePath();
            int size = v.GetFileVersionInfoSize(corePath, new IntByReference());
            if (size == 0) {
                throw new IOException("unable to get size data");
            }
            ByteBuffer buffer = ByteBuffer.allocateDirect(size);
            boolean result = v.GetFileVersionInfo(corePath, 0, size, buffer);
            if (!result) {
                throw new IOException("unable to get version info");
            }
            PointerByReference versionData = new PointerByReference();
            IntByReference vdLen = new IntByReference();
            result = v.VerQueryValue(buffer, "\\", versionData, vdLen);
            if (!result) {
                throw new IOException("Unable to get value out of version info");
            }
            VersionDll.VS_FIXEDFILEINFO info = new VersionDll.VS_FIXEDFILEINFO(versionData.getValue());
            long v1 = (short)(info.dwFileVersionMS >> 16);
            long v4 = (short)(info.dwFileVersionLS & 0xFFFF);
            return v1 * 1000L + v4;
        }
    }

    private class LoadFullUpdateCommand
    implements Callable<Void> {
        private final File updateDir;

        LoadFullUpdateCommand(File updateDir) {
            this.updateDir = updateDir;
        }

        @Override
        public Void call() throws VirusScanException {
            LOG.debugf("Loading full update from {0}", (Object)this.updateDir);
            VirusScannerImpl.this.uninitialize();
            VirusScannerImpl.this.definitionsVersion = 0;
            File db = VirusUtils.getDatabaseDirectory();
            FileUtils.forceDeleteRecursive(db);
            db.mkdirs();
            db.mkdir();
            File[] files = this.updateDir.listFiles();
            if (files == null) {
                throw new VirusScanException("Update directory is empty");
            }
            for (File file : files) {
                if (file.renameTo(new File(db, file.getName()))) continue;
                throw new VirusScanException("Failed to rename file");
            }
            VirusScannerImpl.this.definitionsVersion = -1;
            VirusScannerImpl.this.getDefinitionsVersion();
            return null;
        }
    }

    private class LoadIncrementalUpdateCommand
    implements Callable<Void> {
        private final File updateDir;

        LoadIncrementalUpdateCommand(File updateDir) {
            this.updateDir = updateDir;
        }

        @Override
        public Void call() throws IOException, VirusScanException {
            LOG.debugf("Loading incremental update from {0}", (Object)this.updateDir);
            VirusScannerImpl.this.definitionsVersion = -1;
            try {
                VirusScannerImpl.this.initializeLazily();
            }
            catch (VirusScanException e) {
                throw new IOException(e);
            }
            File patch = null;
            File[] files = this.updateDir.listFiles();
            if (files == null) {
                throw new IOException("Update directory is empty");
            }
            for (File file : files) {
                if (!file.getName().endsWith(".trs")) continue;
                patch = file;
                break;
            }
            if (patch == null) {
                throw new IOException("Could not find patch file");
            }
            File db = VirusUtils.getDatabaseDirectory();
            File source = new File(db, "incavi.avm");
            if (!source.exists()) {
                throw new IOException("Could not find source file");
            }
            File temp = VirusUtils.getTemporaryDirectory();
            temp.mkdirs();
            File destination = new File(temp, "incavi.avm");
            try {
                Dispatch avgVDBUpdate = new ActiveXComponent("AvgSdkCom.AvgVdbUpd", 4).getObject();
                Dispatch.call((Dispatch)avgVDBUpdate, (String)"UpdateIncrementalVdbFile", (Object)source.getAbsolutePath(), (Object)destination.getAbsolutePath(), (Object)1, (Object)patch.getAbsolutePath(), (Object)new Variant());
                avgVDBUpdate.safeRelease();
            }
            catch (ComFailException e) {
                int hr = e.getHResult();
                LOG.debugf(e, "Failed to merge incremental update: {0}", hr);
                throw new IOException("hr: " + hr, e);
            }
            VirusScannerImpl.this.definitionsVersion = 0;
            source.delete();
            if (!destination.renameTo(source)) {
                throw new VirusScanException("Failed to rename incavi.avm");
            }
            File newVersion = new File(this.updateDir, "version.nfo");
            File oldVersion = new File(db, "version.nfo");
            oldVersion.delete();
            if (!newVersion.renameTo(oldVersion)) {
                throw new VirusScanException("Failed to rename version.nfo");
            }
            try {
                Dispatch.call((Dispatch)VirusScannerImpl.this.avg, (String)"ReloadVdbFiles");
            }
            catch (ComFailException e) {
                int hr = e.getHResult();
                LOG.debugf(e, "Failed to reload definitions: {0}", hr);
                throw new VirusScanException("hr: " + hr, e);
            }
            VirusScannerImpl.this.definitionsVersion = -1;
            VirusScannerImpl.this.getDefinitionsVersion();
            return null;
        }
    }

    private class StopCommand
    implements Callable<Void> {
        private StopCommand() {
        }

        @Override
        public Void call() {
            VirusScannerImpl.this.uninitialize();
            return null;
        }
    }

    private class ScanCommand
    implements Callable<Boolean> {
        private final File file;

        ScanCommand(File file) {
            this.file = file;
        }

        @Override
        public Boolean call() throws VirusScanException {
            if (!this.file.exists()) {
                return false;
            }
            VirusScannerImpl.this.initializeLazily();
            try {
                Variant infected;
                Variant resultVar = new Variant();
                Dispatch params = new ActiveXComponent("AvgSdkCom.AvgScanParameters", 4).getObject();
                String path = this.file.getAbsolutePath();
                if (this.file.isDirectory()) {
                    LOG.debugf("Scanning directory: {0}", (Object)path);
                    infected = Dispatch.call((Dispatch)VirusScannerImpl.this.avg, (String)"ScanDirectory", (Object)path, (Object)resultVar, (Object)params);
                } else {
                    LOG.debugf("Scanning file: {0}", (Object)path);
                    infected = Dispatch.call((Dispatch)VirusScannerImpl.this.avg, (String)"ScanFile", (Object)path, (Object)path, (Object)resultVar, (Object)params);
                }
                params.safeRelease();
                boolean isInfected = infected.getBoolean();
                LOG.debugf("Infected: {0}", (Object)infected);
                VirusScannerImpl.this.updateStats(this.file, isInfected);
                return isInfected;
            }
            catch (ComFailException e) {
                int hr = e.getHResult();
                LOG.debugf(e, "Failed to scan {0}: {1}", this.file, hr);
                throw new VirusScanException("hr: " + hr, e);
            }
        }
    }
}

