/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVM;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVMFactory;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVMImpl;
import com.limegroup.gnutella.simpp.SimppManager;
import com.limegroup.gnutella.version.UpdateHandler;
import java.util.Map;
import java.util.TreeMap;
import org.limewire.collection.Comparators;

@Singleton
public class CapabilitiesVMFactoryImpl
implements CapabilitiesVMFactory {
    private final Provider<DHTManager> dhtManager;
    private final Provider<SimppManager> simppManager;
    private final Provider<UpdateHandler> updateHandler;
    private final Provider<NetworkManager> networkManager;
    private volatile CapabilitiesVM currentCapabilities;

    @Inject
    public CapabilitiesVMFactoryImpl(Provider<DHTManager> dhtManager, Provider<SimppManager> simppManager, Provider<UpdateHandler> updateHandler, Provider<NetworkManager> networkManager) {
        this.dhtManager = dhtManager;
        this.simppManager = simppManager;
        this.updateHandler = updateHandler;
        this.networkManager = networkManager;
    }

    @Override
    public CapabilitiesVM getCapabilitiesVM() {
        if (this.currentCapabilities == null) {
            this.currentCapabilities = new CapabilitiesVMImpl(this.getSupportedMessages());
        }
        return this.currentCapabilities;
    }

    @Override
    public void updateCapabilities() {
        this.currentCapabilities = new CapabilitiesVMImpl(this.getSupportedMessages());
    }

    protected Map<byte[], Integer> getSupportedMessages() {
        TreeMap<byte[], Integer> supported = new TreeMap<byte[], Integer>(new Comparators.ByteArrayComparator());
        supported.put(new byte[]{73, 77, 80, 80}, Integer.MAX_VALUE);
        supported.put(new byte[]{76, 77, 85, 80}, Integer.MAX_VALUE);
        supported.put(CapabilitiesVM.FEATURE_SEARCH_BYTES, 1);
        supported.put(CapabilitiesVM.SIMPP_BYTES, this.simppManager.get().getVersion());
        supported.put(CapabilitiesVM.SIMPP_NEW_VERSION_BYTES, this.simppManager.get().getNewVersion());
        supported.put(CapabilitiesVM.SIMPP_KEY_VERSION_BYTES, this.simppManager.get().getKeyVersion());
        supported.put(CapabilitiesVM.UPDATE_BYTES, this.updateHandler.get().getLatestId());
        supported.put(CapabilitiesVM.UPDATE_NEW_VERSION_BYTES, this.updateHandler.get().getNewVersion());
        supported.put(CapabilitiesVM.UPDATE_KEY_VERSION_BYTES, this.updateHandler.get().getKeyVersion());
        supported.put(CapabilitiesVM.INCOMING_TCP_BYTES, this.networkManager.get().acceptedIncomingConnection() ? 1 : 0);
        supported.put(CapabilitiesVM.FWT_SUPPORT_BYTES, this.networkManager.get().supportsFWTVersion());
        if (this.dhtManager.get().isMemberOfDHT()) {
            DHTManager.DHTMode mode = this.dhtManager.get().getDHTMode();
            assert (mode != null);
            supported.put(mode.getCapabilityName(), this.dhtManager.get().getVersion().shortValue());
        }
        if (this.networkManager.get().isIncomingTLSEnabled()) {
            supported.put(CapabilitiesVM.TLS_SUPPORT_BYTES, 1);
        }
        return supported;
    }
}

