/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.google.inject.Singleton;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.AbstractVendorMessage;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteUtils;

@Singleton
public final class MessagesSupportedVendorMessage
extends AbstractVendorMessage
implements VendorMessage.ControlMessage {
    public static final int VERSION = 0;
    private final Set<SupportedMessageBlock> _messagesSupported = new HashSet<SupportedMessageBlock>();

    MessagesSupportedVendorMessage(byte[] guid, byte ttl, byte hops, int version, byte[] payload, Message.Network network) throws BadPacketException {
        super(guid, ttl, hops, F_NULL_VENDOR_ID, 0, version, payload, network);
        if (this.getVersion() > 0) {
            throw new BadPacketException("UNSUPPORTED VERSION");
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.getPayload());
            int vectorSize = ByteUtils.ushort2int(ByteUtils.leb2short(bais));
            for (int i = 0; i < vectorSize; ++i) {
                this._messagesSupported.add(new SupportedMessageBlock(bais));
            }
        }
        catch (IOException ioe) {
            ErrorService.error(ioe);
        }
    }

    public MessagesSupportedVendorMessage() {
        super(F_NULL_VENDOR_ID, 0, 0, MessagesSupportedVendorMessage.derivePayload(MessagesSupportedVendorMessage.addSupportedMessages(new HashSet<SupportedMessageBlock>())));
        MessagesSupportedVendorMessage.addSupportedMessages(this._messagesSupported);
    }

    MessagesSupportedVendorMessage(Set<SupportedMessageBlock> supportedMessageBlocks) {
        super(F_NULL_VENDOR_ID, 0, 0, MessagesSupportedVendorMessage.derivePayload(supportedMessageBlocks));
    }

    private static byte[] derivePayload(Set<SupportedMessageBlock> hashSet) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ByteUtils.short2leb((short)hashSet.size(), baos);
            for (SupportedMessageBlock currSMP : hashSet) {
                currSMP.encode(baos);
            }
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            ErrorService.error(ioe);
            return null;
        }
    }

    static Set<SupportedMessageBlock> addSupportedMessages(Set<SupportedMessageBlock> hashSet) {
        SupportedMessageBlock smp = null;
        smp = new SupportedMessageBlock(F_BEAR_VENDOR_ID, 7, 1);
        hashSet.add(smp);
        smp = new SupportedMessageBlock(F_GTKG_VENDOR_ID, 7, 2);
        hashSet.add(smp);
        smp = new SupportedMessageBlock(F_BEAR_VENDOR_ID, 4, 1);
        hashSet.add(smp);
        smp = new SupportedMessageBlock(F_LIME_VENDOR_ID, 21, 1);
        hashSet.add(smp);
        smp = new SupportedMessageBlock(F_BEAR_VENDOR_ID, 11, 1);
        hashSet.add(smp);
        smp = new SupportedMessageBlock(F_LIME_VENDOR_ID, 7, 1);
        hashSet.add(smp);
        smp = new SupportedMessageBlock(F_LIME_VENDOR_ID, 8, 1);
        hashSet.add(smp);
        smp = new SupportedMessageBlock(F_LIME_VENDOR_ID, 6, 1);
        hashSet.add(smp);
        smp = new SupportedMessageBlock(F_LIME_VENDOR_ID, 16, 2);
        hashSet.add(smp);
        smp = new SupportedMessageBlock(F_LIME_VENDOR_ID, 17, 2);
        hashSet.add(smp);
        smp = new SupportedMessageBlock(F_LIME_VENDOR_ID, 25, 1);
        hashSet.add(smp);
        smp = new SupportedMessageBlock(F_LIME_VENDOR_ID, 13, 1);
        hashSet.add(smp);
        smp = new SupportedMessageBlock(F_LIME_VENDOR_ID, 30, 1);
        hashSet.add(smp);
        smp = new SupportedMessageBlock(F_LIME_VENDOR_ID, 33, 1);
        hashSet.add(smp);
        return hashSet;
    }

    public int supportsMessage(byte[] vendorID, int selector) {
        for (SupportedMessageBlock currSMP : this._messagesSupported) {
            int version = currSMP.matches(vendorID, selector);
            if (version <= -1) continue;
            return version;
        }
        return -1;
    }

    public int supportsTCPConnectBack() {
        return this.supportsMessage(F_BEAR_VENDOR_ID, 7);
    }

    public int supportsUDPConnectBack() {
        return this.supportsMessage(F_GTKG_VENDOR_ID, 7);
    }

    public int supportsTCPConnectBackRedirect() {
        return this.supportsMessage(F_LIME_VENDOR_ID, 7);
    }

    public int supportsUDPConnectBackRedirect() {
        return this.supportsMessage(F_LIME_VENDOR_ID, 8);
    }

    public int supportsHopsFlow() {
        return this.supportsMessage(F_BEAR_VENDOR_ID, 4);
    }

    public int supportsPushProxy() {
        return this.supportsMessage(F_LIME_VENDOR_ID, 21);
    }

    public int supportsLeafGuidance() {
        return this.supportsMessage(F_BEAR_VENDOR_ID, 11);
    }

    public int supportsUDPCrawling() {
        return this.supportsMessage(F_LIME_VENDOR_ID, 6);
    }

    public int supportsHeaderUpdate() {
        return this.supportsMessage(F_LIME_VENDOR_ID, 25);
    }

    public int supportsOOBProxyingControl() {
        return this.supportsMessage(F_LIME_VENDOR_ID, 13);
    }

    public int supportsInspectionRequests() {
        return this.supportsMessage(F_LIME_VENDOR_ID, 30);
    }

    public int supportsDHTContacts() {
        return this.supportsMessage(F_LIME_VENDOR_ID, 33);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof MessagesSupportedVendorMessage) {
            MessagesSupportedVendorMessage vmp = (MessagesSupportedVendorMessage)other;
            return ((Object)this._messagesSupported).equals(vmp._messagesSupported);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 17 * ((Object)this._messagesSupported).hashCode();
    }

    @Override
    protected void writePayload(OutputStream out) throws IOException {
        super.writePayload(out);
    }

    static class SupportedMessageBlock {
        final byte[] _vendorID;
        final int _selector;
        final int _version;
        final int _hashCode;

        public SupportedMessageBlock(byte[] vendorID, int selector, int version) {
            this._vendorID = vendorID;
            this._selector = selector;
            this._version = version;
            this._hashCode = SupportedMessageBlock.computeHashCode(this._vendorID, this._selector, this._version);
        }

        public SupportedMessageBlock(InputStream encodedBlock) throws BadPacketException, IOException {
            if (encodedBlock.available() < 8) {
                throw new BadPacketException("invalid data.");
            }
            this._vendorID = new byte[4];
            encodedBlock.read(this._vendorID, 0, this._vendorID.length);
            this._selector = ByteUtils.ushort2int(ByteUtils.leb2short(encodedBlock));
            this._version = ByteUtils.ushort2int(ByteUtils.leb2short(encodedBlock));
            this._hashCode = SupportedMessageBlock.computeHashCode(this._vendorID, this._selector, this._version);
        }

        public void encode(OutputStream out) throws IOException {
            out.write(this._vendorID);
            ByteUtils.short2leb((short)this._selector, out);
            ByteUtils.short2leb((short)this._version, out);
        }

        public int matches(byte[] vendorID, int selector) {
            if (Arrays.equals(this._vendorID, vendorID) && this._selector == selector) {
                return this._version;
            }
            return -1;
        }

        public boolean equals(Object other) {
            if (other instanceof SupportedMessageBlock) {
                SupportedMessageBlock vmp = (SupportedMessageBlock)other;
                return this._selector == vmp._selector && this._version == vmp._version && Arrays.equals(this._vendorID, vmp._vendorID);
            }
            return false;
        }

        public int hashCode() {
            return this._hashCode;
        }

        private static int computeHashCode(byte[] vendorID, int selector, int version) {
            int hashCode = 0;
            hashCode += 37 * version;
            hashCode += 37 * selector;
            for (int i = 0; i < vendorID.length; ++i) {
                hashCode += 37 * vendorID[i];
            }
            return hashCode;
        }
    }
}

