/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.routing;

import com.limegroup.gnutella.routing.QRTTableStorage;
import java.util.Iterator;
import org.limewire.collection.BitSet;
import org.limewire.collection.UnmodifiableIterator;

class BitSetQRTTableStorage
implements QRTTableStorage {
    private final BitSet bitSet;
    private final int bitTableLength;
    private BitSet cachedResizedSet;
    private int cachedResizedSetLength;

    BitSetQRTTableStorage(int bitTableLength) {
        this.bitTableLength = bitTableLength;
        this.bitSet = new BitSet();
    }

    private BitSetQRTTableStorage(BitSet bitSet, int bitTableLength) {
        this.bitSet = bitSet;
        this.bitTableLength = bitTableLength;
    }

    @Override
    public double getPercentFull() {
        return (double)this.bitSet.cardinality() * 100.0 / (double)this.bitTableLength;
    }

    @Override
    public QRTTableStorage clone() throws CloneNotSupportedException {
        return new BitSetQRTTableStorage((BitSet)this.bitSet.clone(), this.bitTableLength);
    }

    @Override
    public void clear(int hash) {
        this.cachedResizedSet = null;
        this.bitSet.clear(hash);
    }

    @Override
    public void compact() {
        this.bitSet.compact();
    }

    @Override
    public int getUnitsInUse() {
        return this.bitSet.getUnitsInUse();
    }

    @Override
    public int getUnusedUnits() {
        return this.bitSet.unusedUnits();
    }

    @Override
    public int numUnitsWithLoad(int load) {
        return this.bitSet.numUnitsWithLoad(load);
    }

    @Override
    public void or(QRTTableStorage other) {
        if (other instanceof BitSetQRTTableStorage) {
            BitSetQRTTableStorage optimized = (BitSetQRTTableStorage)other;
            this.bitSet.or(optimized.bitSet);
        } else {
            Iterator i$ = other.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                this.bitSet.set(i);
            }
        }
    }

    @Override
    public QRTTableStorage resize(int newSize) {
        if (this.bitTableLength == newSize) {
            return this;
        }
        if (this.cachedResizedSet != null && this.cachedResizedSetLength == newSize) {
            return new BitSetQRTTableStorage(this.cachedResizedSet, this.cachedResizedSetLength);
        }
        this.cachedResizedSet = new BitSet();
        this.cachedResizedSetLength = newSize;
        int m = this.bitTableLength;
        int m2 = this.cachedResizedSetLength;
        int i = this.bitSet.nextSetBit(0);
        while (i >= 0) {
            int firstSet = (int)((long)i * (long)m2 / (long)m);
            i = this.bitSet.nextClearBit(i + 1);
            int lastNotSet = (int)(((long)i * (long)m2 - 1L) / (long)m + 1L);
            this.cachedResizedSet.set(firstSet, lastNotSet);
            i = this.bitSet.nextSetBit(i + 1);
        }
        return new BitSetQRTTableStorage(this.cachedResizedSet, this.cachedResizedSetLength);
    }

    @Override
    public void set(int hash) {
        this.cachedResizedSet = null;
        this.bitSet.set(hash);
    }

    @Override
    public void xor(QRTTableStorage other) {
        if (other instanceof BitSetQRTTableStorage) {
            BitSetQRTTableStorage optimized = (BitSetQRTTableStorage)other;
            this.bitSet.xor(optimized.bitSet);
        } else {
            for (int i = 0; i < this.bitTableLength; ++i) {
                this.bitSet.set(i, this.bitSet.get(i) != other.get(i));
            }
        }
    }

    @Override
    public Iterator<Integer> iterator() {
        return new BitSetIterator();
    }

    @Override
    public int cardinality() {
        return this.bitSet.cardinality();
    }

    @Override
    public boolean get(int i) {
        return this.bitSet.get(i);
    }

    @Override
    public int maxSize() {
        return this.bitTableLength;
    }

    @Override
    public int nextClearBit(int i) {
        return this.bitSet.nextClearBit(i);
    }

    @Override
    public int nextSetBit(int i) {
        return this.bitSet.nextSetBit(i);
    }

    public boolean equals(Object o) {
        if (!(o instanceof QRTTableStorage)) {
            return false;
        }
        if (o instanceof BitSetQRTTableStorage) {
            BitSetQRTTableStorage other = (BitSetQRTTableStorage)o;
            return this.bitSet.equals(other.bitSet);
        }
        QRTTableStorage other = (QRTTableStorage)o;
        if (this.cardinality() != other.cardinality()) {
            return false;
        }
        Iterator i$ = other.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            if (this.get(i)) continue;
            return false;
        }
        return true;
    }

    private class BitSetIterator
    extends UnmodifiableIterator<Integer> {
        private int current;

        private BitSetIterator() {
            this.current = BitSetQRTTableStorage.this.bitSet.nextSetBit(0);
        }

        @Override
        public boolean hasNext() {
            return this.current >= 0;
        }

        @Override
        public Integer next() {
            int ret = this.current;
            this.current = BitSetQRTTableStorage.this.bitSet.nextSetBit(ret + 1);
            return ret;
        }
    }
}

