/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.security;

import com.limegroup.gnutella.security.Certificate;
import com.limegroup.gnutella.security.CertificateProvider;
import com.limegroup.gnutella.security.CertificateVerifier;
import com.limegroup.gnutella.security.FileCertificateReader;
import com.limegroup.gnutella.security.HttpCertificateReader;
import com.limegroup.gnutella.security.NullCertificate;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.security.SignatureException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.limewire.io.IpPort;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;

public class CertificateProviderImpl
implements CertificateProvider {
    private static final Log LOG = LogFactory.getLog(CertificateProviderImpl.class);
    private final FileCertificateReader fileCertificateReader;
    private final HttpCertificateReader httpCertificateReader;
    private final CertificateVerifier certificateVerifier;
    private AtomicReference<Certificate> validCertificate = new AtomicReference<Object>(null);
    private final File file;
    private final URI uri;
    private final AtomicBoolean httpDone = new AtomicBoolean(false);

    public CertificateProviderImpl(FileCertificateReader fileCertificateReader, HttpCertificateReader httpCertificateReader, CertificateVerifier certificateVerifier, File file, URI uri) {
        this.fileCertificateReader = fileCertificateReader;
        this.httpCertificateReader = httpCertificateReader;
        this.certificateVerifier = certificateVerifier;
        this.file = file;
        this.uri = uri;
    }

    private Certificate getFromFile() {
        try {
            return this.certificateVerifier.verify(this.fileCertificateReader.read(this.file));
        }
        catch (IOException e) {
            LOG.debugf(e, "certificate from invalid file: {0}", this.file);
        }
        catch (SignatureException e) {
            LOG.debugf(e, "certificate from file {0} invalid", this.file);
        }
        return null;
    }

    @Override
    public void set(Certificate certificate) {
        LOG.debugf("setting certificate: {0}", (Object)certificate);
        try {
            Certificate localCopy = this.validCertificate.get();
            if (localCopy == null || certificate.getKeyVersion() > localCopy.getKeyVersion()) {
                this.validCertificate.set(this.certificateVerifier.verify(certificate));
                this.fileCertificateReader.write(certificate, this.file);
            } else {
                LOG.debugf("certificate version not greater than local one: {0}", (Object)certificate);
            }
        }
        catch (SignatureException se) {
            LOG.debugf(se, "certificate invalid {0} ", certificate);
        }
    }

    @Override
    public Certificate get() {
        Certificate copy = this.validCertificate.get();
        if (copy != null) {
            return copy;
        }
        this.validCertificate.compareAndSet(null, this.getFromFile());
        copy = this.validCertificate.get();
        if (copy != null) {
            return copy;
        }
        return new NullCertificate();
    }

    @Override
    public Certificate get(int keyVersion, IpPort messageSource) {
        Certificate copy = this.validCertificate.get();
        if (copy == null) {
            this.validCertificate.compareAndSet(null, this.getFromFile());
        }
        if ((copy = this.validCertificate.get()) != null && copy.getKeyVersion() >= keyVersion) {
            return copy;
        }
        return this.getFromHttp(messageSource);
    }

    Certificate getFromHttp(IpPort messageSource) {
        if (this.httpDone.compareAndSet(false, true)) {
            try {
                LOG.debug("getting certifcate from http");
                return this.certificateVerifier.verify(this.httpCertificateReader.read(this.uri, messageSource));
            }
            catch (IOException ie) {
                LOG.debugf(ie, "certificate from invalid url: {0}", this.uri);
            }
            catch (SignatureException e) {
                LOG.debugf(e, "certificate from http invalid: {0}", this.uri);
            }
            return new NullCertificate();
        }
        Certificate copy = this.validCertificate.get();
        if (copy != null) {
            return copy;
        }
        return new NullCertificate();
    }
}

