/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.spam;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.ResponseVerifier;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.spam.AddressToken;
import com.limegroup.gnutella.spam.ApproximateSizeToken;
import com.limegroup.gnutella.spam.ClientGUIDToken;
import com.limegroup.gnutella.spam.FileExtensionToken;
import com.limegroup.gnutella.spam.KeywordToken;
import com.limegroup.gnutella.spam.SizeToken;
import com.limegroup.gnutella.spam.TemplateHashToken;
import com.limegroup.gnutella.spam.TemplateHashTokenFactory;
import com.limegroup.gnutella.spam.Token;
import com.limegroup.gnutella.spam.UrnToken;
import com.limegroup.gnutella.spam.XMLKeywordToken;
import com.limegroup.gnutella.util.QueryUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.Address;
import org.limewire.io.Connectable;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.util.Base32;
import org.limewire.util.FileUtils;

@Singleton
public class Tokenizer {
    private static final Log LOG = LogFactory.getLog(Tokenizer.class);
    private int MAX_KEYWORD_LENGTH = 8;
    private final NetworkInstanceUtils networkInstanceUtils;
    private final ResponseVerifier responseVerifier;
    private final TemplateHashTokenFactory templateHashTokenFactory;

    @Inject
    Tokenizer(NetworkInstanceUtils networkInstanceUtils, ResponseVerifier responseVerifier, TemplateHashTokenFactory templateHashTokenFactory) {
        this.networkInstanceUtils = networkInstanceUtils;
        this.responseVerifier = responseVerifier;
        this.templateHashTokenFactory = templateHashTokenFactory;
    }

    public Set<Token> getTokens(RemoteFileDesc desc) {
        HashSet<Token> set = new HashSet<Token>();
        this.tokenize(desc, set);
        return set;
    }

    public Set<Token> getTokens(RemoteFileDesc[] descs) {
        HashSet<Token> set = new HashSet<Token>();
        for (RemoteFileDesc desc : descs) {
            this.tokenize(desc, set);
        }
        return set;
    }

    private void tokenize(RemoteFileDesc desc, Set<Token> set) {
        Connectable connectable;
        URN urn;
        LimeXMLDocument xml;
        TemplateHashToken t;
        String query;
        if (LOG.isDebugEnabled()) {
            String addr = desc.getAddress().getAddressDescription();
            LOG.debug("Tokenizing result from " + addr);
        }
        String name = desc.getFileName();
        byte[] queryGUID = desc.getQueryGUID();
        if (queryGUID != null && (query = this.responseVerifier.getQueryString(queryGUID)) != null && (t = this.templateHashTokenFactory.create(query, name)) != null) {
            set.add(t);
        }
        this.getKeywordTokens(FileUtils.getFilenameNoExtension(name), set);
        String ext = FileUtils.getFileExtension(name);
        if (!ext.equals("")) {
            set.add(new FileExtensionToken(ext));
        }
        if ((xml = desc.getXMLDocument()) != null) {
            this.getKeywordTokens(xml, set);
        }
        if ((urn = desc.getSHA1Urn()) != null) {
            set.add(new UrnToken(urn.toString()));
        }
        set.add(new SizeToken(desc.getSize()));
        set.add(new ApproximateSizeToken(desc.getSize()));
        Address address = desc.getAddress();
        if (address instanceof Connectable && !this.networkInstanceUtils.isPrivateAddress((connectable = (Connectable)address).getInetAddress())) {
            set.add(new AddressToken(connectable.getAddress()));
        }
        set.add(new ClientGUIDToken(Base32.encode(desc.getClientGUID())));
    }

    public Set<Token> getNonKeywordTokens(QueryReply qr) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Tokenizing query reply from " + qr.getIP());
        }
        HashSet<Token> set = new HashSet<Token>();
        String query = this.responseVerifier.getQueryString(qr.getGUID());
        set.add(new ClientGUIDToken(Base32.encode(qr.getClientGUID())));
        String ip = qr.getIP();
        if (!this.networkInstanceUtils.isPrivateAddress(ip)) {
            set.add(new AddressToken(ip));
        }
        try {
            for (Response r : qr.getResultsArray()) {
                TemplateHashToken t;
                if (query != null && (t = this.templateHashTokenFactory.create(query, r.getName())) != null) {
                    set.add(t);
                }
                for (URN urn : r.getUrns()) {
                    set.add(new UrnToken(urn.toString()));
                }
                long size = r.getSize();
                set.add(new SizeToken(size));
                set.add(new ApproximateSizeToken(size));
            }
        }
        catch (BadPacketException ignored) {
            // empty catch block
        }
        return set;
    }

    public Set<Token> getTokens(QueryRequest qr) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Tokenizing " + qr);
        }
        HashSet<Token> set = new HashSet<Token>();
        this.getKeywordTokens(qr.getQuery(), set);
        LimeXMLDocument xml = qr.getRichQuery();
        if (xml != null) {
            this.getKeywordTokens(xml, set);
        }
        Set<URN> urns = qr.getQueryUrns();
        for (URN urn : urns) {
            set.add(new UrnToken(urn.toString()));
        }
        return set;
    }

    private void getKeywordTokens(LimeXMLDocument doc, Set<Token> set) {
        for (Map.Entry<String, String> entry : doc.getNameValueSet()) {
            String name = entry.getKey().toString();
            String value = entry.getValue().toString();
            this.getXMLKeywords(name, value, set);
        }
    }

    private void getXMLKeywords(String name, String value, Set<Token> set) {
        name = this.extractSimpleFieldName(name);
        name.toLowerCase(Locale.US);
        value.toLowerCase(Locale.US);
        for (String keyword : QueryUtils.extractKeywords(value, false)) {
            if (keyword.length() > this.MAX_KEYWORD_LENGTH) {
                keyword = keyword.substring(0, this.MAX_KEYWORD_LENGTH);
            }
            set.add(new XMLKeywordToken(name, keyword));
        }
    }

    private String extractSimpleFieldName(String name) {
        int idx1 = name.lastIndexOf("__");
        int idx2 = name.lastIndexOf("__", idx1 - 1);
        return name.substring(idx2 + "__".length(), idx1);
    }

    private void getKeywordTokens(String str, Set<Token> set) {
        str.toLowerCase(Locale.US);
        for (String keyword : QueryUtils.extractKeywords(str, false)) {
            if (keyword.length() > this.MAX_KEYWORD_LENGTH) {
                keyword = keyword.substring(0, this.MAX_KEYWORD_LENGTH);
            }
            set.add(new KeywordToken(keyword));
        }
    }
}

