/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.tigertree;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.security.Tiger;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.HashTreeFactory;
import com.limegroup.gnutella.tigertree.HashTreeImpl;
import com.limegroup.gnutella.tigertree.HashTreeNodeManager;
import com.limegroup.gnutella.tigertree.HashTreeUtils;
import com.limegroup.gnutella.tigertree.dime.TigerDimeReadUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IOUtils;

@Singleton
public class HashTreeFactoryImpl
implements HashTreeFactory {
    private static final Log LOG = LogFactory.getLog(HashTreeFactoryImpl.class);
    private final HashTreeNodeManager hashTreeNodeManager;

    @Inject
    public HashTreeFactoryImpl(HashTreeNodeManager hashTreeNodeManager) {
        this.hashTreeNodeManager = hashTreeNodeManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashTree createHashTree(FileDesc fd) throws IOException {
        HashTree hashTree;
        if (LOG.isDebugEnabled()) {
            LOG.debug("creating hashtree for file " + fd);
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(fd.getFile());
            hashTree = this.createHashTree(fd.getFileSize(), in, fd.getSHA1Urn());
        }
        catch (Throwable throwable) {
            IOUtils.close(in);
            throw throwable;
        }
        IOUtils.close(in);
        return hashTree;
    }

    HashTree createHashTree(InputStream is, String sha1, String root32, long fileSize) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("reading " + sha1 + "." + root32 + " dime data.");
        }
        return this.createHashTree(TigerDimeReadUtils.read(is, fileSize, root32), sha1, fileSize);
    }

    @Override
    public HashTree createHashTree(List<List<byte[]>> allNodes, String sha1, long fileSize) {
        return this.createHashTree(allNodes, sha1, fileSize, HashTreeUtils.calculateNodeSize(fileSize, allNodes.size() - 1));
    }

    public HashTree createHashTree(long fileSize, InputStream is, URN sha1) throws IOException {
        int nodeSize = HashTreeUtils.calculateNodeSize(fileSize, HashTreeUtils.calculateDepth(fileSize));
        List<byte[]> nodes = HashTreeUtils.createTreeNodes(nodeSize, fileSize, is, new Tiger());
        List<List<byte[]>> allNodes = HashTreeUtils.createAllParentNodes(nodes, new Tiger());
        return this.createHashTree(allNodes, sha1.toString(), fileSize, nodeSize);
    }

    private HashTree createHashTree(List<List<byte[]>> allNodes, String sha1, long fileSize, int nodeSize) {
        HashTreeImpl tree = new HashTreeImpl(allNodes, sha1.toString(), fileSize, nodeSize);
        this.hashTreeNodeManager.register(tree, allNodes);
        return tree;
    }
}

