/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.PushEndpointFactory;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.altlocs.AlternateLocationFactory;
import com.limegroup.gnutella.library.CreationTimeCache;
import com.limegroup.gnutella.library.Library;
import com.limegroup.gnutella.tigertree.HashTreeCache;
import com.limegroup.gnutella.tigertree.HashTreeWriteHandlerFactory;
import com.limegroup.gnutella.uploader.FileRequestHandler;
import com.limegroup.gnutella.uploader.FileRequestHandlerFactory;
import com.limegroup.gnutella.uploader.FileResponseEntityFactory;
import com.limegroup.gnutella.uploader.HTTPHeaderUtils;
import com.limegroup.gnutella.uploader.HTTPUploadSessionManager;
import com.limegroup.gnutella.uploader.HttpRequestHandlerFactory;
import com.limegroup.gnutella.uploader.authentication.HttpRequestFileViewProvider;
import org.limewire.http.auth.RequiresAuthentication;

@Singleton
class FileRequestHandlerFactoryImpl
implements FileRequestHandlerFactory {
    private final HTTPUploadSessionManager sessionManager;
    private final Library library;
    private final HTTPHeaderUtils httpHeaderUtils;
    private final HttpRequestHandlerFactory httpRequestHandlerFactory;
    private final Provider<CreationTimeCache> creationTimeCache;
    private final FileResponseEntityFactory fileResponseEntityFactory;
    private final AltLocManager altLocManager;
    private final AlternateLocationFactory alternateLocationFactory;
    private final Provider<DownloadManager> downloadManager;
    private final Provider<HashTreeCache> tigerTreeCache;
    private final PushEndpointFactory pushEndpointFactory;
    private final HashTreeWriteHandlerFactory tigerWriteHandlerFactory;

    @Inject
    public FileRequestHandlerFactoryImpl(HTTPUploadSessionManager sessionManager, Library library, HTTPHeaderUtils httpHeaderUtils, HttpRequestHandlerFactory httpRequestHandlerFactory, Provider<CreationTimeCache> creationTimeCache, FileResponseEntityFactory fileResponseEntityFactory, AltLocManager altLocManager, AlternateLocationFactory alternateLocationFactory, Provider<DownloadManager> downloadManager, Provider<HashTreeCache> tigerTreeCache, PushEndpointFactory pushEndpointFactory, HashTreeWriteHandlerFactory tigerWriteHandlerFactory) {
        this.sessionManager = sessionManager;
        this.library = library;
        this.httpHeaderUtils = httpHeaderUtils;
        this.httpRequestHandlerFactory = httpRequestHandlerFactory;
        this.creationTimeCache = creationTimeCache;
        this.fileResponseEntityFactory = fileResponseEntityFactory;
        this.altLocManager = altLocManager;
        this.alternateLocationFactory = alternateLocationFactory;
        this.downloadManager = downloadManager;
        this.tigerTreeCache = tigerTreeCache;
        this.pushEndpointFactory = pushEndpointFactory;
        this.tigerWriteHandlerFactory = tigerWriteHandlerFactory;
    }

    @Override
    public FileRequestHandler createFileRequestHandler(HttpRequestFileViewProvider fileListProvider, boolean requiresAuthentication) {
        if (!requiresAuthentication) {
            return new FileRequestHandler(this.sessionManager, this.library, this.httpHeaderUtils, this.httpRequestHandlerFactory, this.creationTimeCache, this.fileResponseEntityFactory, this.altLocManager, this.alternateLocationFactory, this.downloadManager, this.tigerTreeCache, this.pushEndpointFactory, this.tigerWriteHandlerFactory, fileListProvider);
        }
        return new ProtectedFileRequestHandler(this.sessionManager, this.library, this.httpHeaderUtils, this.httpRequestHandlerFactory, this.creationTimeCache, this.fileResponseEntityFactory, this.altLocManager, this.alternateLocationFactory, this.downloadManager, this.tigerTreeCache, this.pushEndpointFactory, this.tigerWriteHandlerFactory, fileListProvider);
    }

    @RequiresAuthentication
    static class ProtectedFileRequestHandler
    extends FileRequestHandler {
        ProtectedFileRequestHandler(HTTPUploadSessionManager sessionManager, Library library, HTTPHeaderUtils httpHeaderUtils, HttpRequestHandlerFactory httpRequestHandlerFactory, Provider<CreationTimeCache> creationTimeCache, FileResponseEntityFactory fileResponseEntityFactory, AltLocManager altLocManager, AlternateLocationFactory alternateLocationFactory, Provider<DownloadManager> downloadManager, Provider<HashTreeCache> tigerTreeCache, PushEndpointFactory pushEndpointFactory, HashTreeWriteHandlerFactory tigerWriteHandlerFactory, HttpRequestFileViewProvider fileListProvider) {
            super(sessionManager, library, httpHeaderUtils, httpRequestHandlerFactory, creationTimeCache, fileResponseEntityFactory, altLocManager, alternateLocationFactory, downloadManager, tigerTreeCache, pushEndpointFactory, tigerWriteHandlerFactory, fileListProvider);
        }
    }
}

