/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.google.inject.Provider;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.library.Library;
import com.limegroup.gnutella.licenses.LicenseType;
import com.limegroup.gnutella.metadata.MetaData;
import com.limegroup.gnutella.metadata.MetaDataFactory;
import com.limegroup.gnutella.metadata.MetaDataReader;
import com.limegroup.gnutella.metadata.MetaDataWriter;
import com.limegroup.gnutella.metadata.audio.AudioMetaData;
import com.limegroup.gnutella.util.QueryUtils;
import com.limegroup.gnutella.xml.GenericXmlDocument;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentFactory;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.limegroup.gnutella.xml.SerialXml;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.IdentityHashSet;
import org.limewire.collection.StringTrie;
import org.limewire.io.IOUtils;
import org.limewire.util.ConverterObjectInputStream;
import org.limewire.util.FileUtils;
import org.limewire.util.GenericsUtils;
import org.limewire.util.I18NConvert;
import org.limewire.util.NameValue;
import org.limewire.util.Objects;
import org.limewire.util.StringUtils;
import org.xml.sax.SAXException;

public class LimeXMLReplyCollection {
    private static final Log LOG = LogFactory.getLog(LimeXMLReplyCollection.class);
    private final String schemaURI;
    private final Map<FileAndUrn, LimeXMLDocument> mainMap;
    private final Map<?, LimeXMLDocument> oldMap;
    private final Map<String, StringTrie<List<LimeXMLDocument>>> trieMap;
    private boolean dirty = false;
    private final Object LOCK = new Object();
    private final Provider<Library> library;
    private final Provider<LimeXMLDocumentFactory> limeXMLDocumentFactory;
    private final Provider<MetaDataFactory> metaDataFactory;
    private final Provider<MetaDataReader> metaDataReader;
    private final File savedDocsDir;

    LimeXMLReplyCollection(String URI2, File path, Provider<Library> library, Provider<LimeXMLDocumentFactory> limeXMLDocumentFactory, Provider<MetaDataReader> metaDataReader, Provider<MetaDataFactory> metaDataFactory) {
        this.schemaURI = URI2;
        this.library = library;
        this.limeXMLDocumentFactory = limeXMLDocumentFactory;
        this.metaDataReader = metaDataReader;
        this.metaDataFactory = metaDataFactory;
        this.trieMap = new HashMap<String, StringTrie<List<LimeXMLDocument>>>();
        this.mainMap = new HashMap<FileAndUrn, LimeXMLDocument>();
        this.savedDocsDir = path;
        this.oldMap = this.readMapFromDisk();
    }

    LimeXMLDocument initialize(FileDesc fd, Collection<? extends LimeXMLDocument> potential) {
        LimeXMLDocument doc = null;
        for (LimeXMLDocument limeXMLDocument : potential) {
            if (!limeXMLDocument.getSchemaURI().equals(this.schemaURI)) continue;
            doc = limeXMLDocument;
            break;
        }
        if (doc == null && (doc = this.oldMap.get(new FileAndUrn(fd))) == null) {
            doc = this.oldMap.get(fd.getSHA1Urn());
        }
        if (doc != null && (doc = this.validate(doc, fd)) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding old document for file: " + fd.getFile() + ", doc: " + doc);
            }
            this.addReply(fd, doc);
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LimeXMLDocument createIfNecessary(FileDesc fd) {
        LimeXMLDocument doc = null;
        boolean needsXml = false;
        File file = fd.getFile();
        FileAndUrn fileAndUrn = new FileAndUrn(fd);
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.mainMap.containsKey(fileAndUrn) && fd.getLimeXMLDocuments().size() == 0) {
                needsXml = true;
            }
        }
        if (needsXml && (doc = this.constructDocument(file)) != null) {
            object = this.LOCK;
            synchronized (object) {
                if (!this.mainMap.containsKey(fileAndUrn) && fd.getLimeXMLDocuments().size() == 0) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Adding newly constructed document for file: " + file + ", document: " + doc);
                    }
                    this.addReply(fd, doc);
                }
            }
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadFinished() {
        Object object = this.LOCK;
        synchronized (object) {
            if (((Object)this.oldMap).equals(this.mainMap)) {
                this.dirty = false;
            }
            this.oldMap.clear();
        }
    }

    private LimeXMLDocument validate(LimeXMLDocument doc, FileDesc fd) {
        if (!((GenericXmlDocument)doc).isCurrent()) {
            LimeXMLDocument tempDoc;
            if (LOG.isDebugEnabled()) {
                LOG.debug("reconstructing old document: " + fd.getFile());
            }
            if ((tempDoc = this.constructDocument(fd.getFile())) != null) {
                doc = this.update(doc, tempDoc);
            } else {
                ((GenericXmlDocument)doc).setCurrent();
            }
        }
        if (AudioMetaData.isCorrupted(doc)) {
            doc = AudioMetaData.fixCorruption(doc, this.limeXMLDocumentFactory.get());
            this.mediaFileToDisk(fd, doc);
        }
        return doc;
    }

    private LimeXMLDocument update(LimeXMLDocument older, LimeXMLDocument newer) {
        HashMap<String, String> fields = new HashMap<String, String>();
        for (Map.Entry<String, String> next : newer.getNameValueSet()) {
            fields.put(next.getKey(), next.getValue());
        }
        for (Map.Entry<String, String> next : older.getNameValueSet()) {
            if (fields.containsKey(next.getKey())) continue;
            fields.put(next.getKey(), next.getValue());
        }
        ArrayList nameValues = new ArrayList(fields.size());
        for (Map.Entry next : fields.entrySet()) {
            nameValues.add(new NameValue((String)next.getKey(), next.getValue()));
        }
        return this.limeXMLDocumentFactory.get().createLimeXMLDocument(nameValues, newer.getSchemaURI());
    }

    boolean canCreateDocument(File file) {
        MetaDataFactory factory = this.metaDataFactory.get();
        return "http://www.limewire.com/schemas/audio.xsd".equals(this.schemaURI) && factory.containsAudioReader(file) || "http://www.limewire.com/schemas/video.xsd".equals(this.schemaURI) && factory.containsVideoReader(file) || "http://www.limewire.com/schemas/torrent.xsd".equals(this.schemaURI) && factory.containsReader(file);
    }

    private LimeXMLDocument constructDocument(File file) {
        if (this.canCreateDocument(file)) {
            try {
                LimeXMLDocument document = this.metaDataReader.get().readDocument(file);
                if (document.getSchemaURI().equals(this.schemaURI)) {
                    return document;
                }
            }
            catch (IOException ignored) {
                LOG.warn("Error creating document", ignored);
            }
        }
        return null;
    }

    public String getSchemaURI() {
        return this.schemaURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addKeywords(LimeXMLDocument doc) {
        Object object = this.LOCK;
        synchronized (object) {
            for (Map.Entry<String, String> entry : doc.getNameValueSet()) {
                String name = entry.getKey();
                String value = I18NConvert.instance().getNorm(entry.getValue());
                StringTrie<List<LimeXMLDocument>> trie = this.trieMap.get(name);
                if (trie == null) {
                    trie = new StringTrie(true);
                    this.trieMap.put(name, trie);
                }
                Set<String> valuesKeywords = QueryUtils.extractKeywords(value, true);
                for (String keyword : valuesKeywords) {
                    List<LimeXMLDocument> allDocs = trie.get(keyword);
                    if (allDocs == null) {
                        allDocs = new LinkedList<LimeXMLDocument>();
                        trie.add(keyword, allDocs);
                    }
                    allDocs.add(doc);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeKeywords(LimeXMLDocument doc) {
        Object object = this.LOCK;
        synchronized (object) {
            for (Map.Entry<String, String> entry : doc.getNameValueSet()) {
                String name = entry.getKey();
                StringTrie<List<LimeXMLDocument>> trie = this.trieMap.get(name);
                if (trie == null) continue;
                String value = I18NConvert.instance().getNorm(entry.getValue());
                Set<String> keywords = QueryUtils.extractKeywords(value, true);
                for (String keyword : keywords) {
                    List<LimeXMLDocument> allDocs = trie.get(keyword);
                    if (allDocs == null) continue;
                    allDocs.remove(doc);
                    if (allDocs.size() != 0) continue;
                    trie.remove(keyword);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReply(FileDesc fd, LimeXMLDocument replyDoc) {
        assert (this.getSchemaURI().equals(replyDoc.getSchemaURI()));
        Object object = this.LOCK;
        synchronized (object) {
            this.dirty = true;
            this.mainMap.put(new FileAndUrn(fd), replyDoc);
            if (!this.isLWSDoc(replyDoc)) {
                this.addKeywords(replyDoc);
            }
        }
        fd.addLimeXMLDocument(replyDoc);
    }

    public boolean isLWSDoc(LimeXMLDocument doc) {
        return doc != null && doc.getLicenseString() != null && doc.getLicenseString().equals(LicenseType.LIMEWIRE_STORE_PURCHASE.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.mainMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<LimeXMLDocument> getMatchingDocuments(LimeXMLDocument query) {
        IdentityHashSet<LimeXMLDocument> matching = null;
        Object object = this.LOCK;
        synchronized (object) {
            for (Map.Entry<String, String> entry : query.getNameValueSet()) {
                String value;
                Set<String> metadata = Collections.singleton(entry.getKey());
                Set<LimeXMLDocument> repliesForMetadata = this.getMatchingDocumentsIntersectKeywords(metadata, value = entry.getValue());
                if (repliesForMetadata.isEmpty()) continue;
                if (matching == null) {
                    matching = new IdentityHashSet<LimeXMLDocument>();
                }
                matching.addAll(repliesForMetadata);
            }
        }
        if (matching == null || matching.size() == 0) {
            return Collections.emptySet();
        }
        IdentityHashSet<LimeXMLDocument> actualMatches = null;
        for (LimeXMLDocument currReplyDoc : matching) {
            if (!LimeXMLUtils.match(currReplyDoc, query, false)) continue;
            if (actualMatches == null) {
                actualMatches = new IdentityHashSet<LimeXMLDocument>();
            }
            actualMatches.add(currReplyDoc);
        }
        if (actualMatches == null || actualMatches.size() == 0) {
            return Collections.emptySet();
        }
        return actualMatches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<LimeXMLDocument> getMatchingDocuments(String query) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.getMatchingDocumentsIntersectKeywords(this.trieMap.keySet(), query);
        }
    }

    private Set<LimeXMLDocument> getMatchingDocumentsIntersectKeywords(Set<String> metadataFields, String query) {
        IdentityHashSet<LimeXMLDocument> matches = new IdentityHashSet<LimeXMLDocument>();
        Set<String> keywords = QueryUtils.extractKeywords(query, true);
        for (String keyword : keywords) {
            Set<LimeXMLDocument> allMatchedDocsForKeyword = this.getMatchingDocumentsForMetadata(metadataFields, keyword);
            if (matches.size() == 0) {
                matches.addAll(allMatchedDocsForKeyword);
            } else {
                matches.retainAll(allMatchedDocsForKeyword);
            }
            if (matches.size() != 0) continue;
            return Collections.emptySet();
        }
        return matches;
    }

    private Set<LimeXMLDocument> getMatchingDocumentsForMetadata(Set<String> metadataFields, String searchTerm) {
        IdentityHashSet<LimeXMLDocument> matches = new IdentityHashSet<LimeXMLDocument>();
        for (String metadataFieldName : metadataFields) {
            StringTrie<List<LimeXMLDocument>> trie = this.trieMap.get(metadataFieldName);
            if (trie == null) continue;
            Iterator<List<LimeXMLDocument>> iter = trie.getPrefixedBy(searchTerm);
            while (iter.hasNext()) {
                matches.addAll((Collection<LimeXMLDocument>)iter.next());
            }
        }
        return matches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LimeXMLDocument replaceDoc(FileDesc fd, LimeXMLDocument newDoc) {
        assert (this.getSchemaURI().equals(newDoc.getSchemaURI()));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Replacing doc in FD (" + fd + ") with new doc (" + newDoc + ")");
        }
        LimeXMLDocument oldDoc = null;
        Object object = this.LOCK;
        synchronized (object) {
            this.dirty = true;
            oldDoc = this.mainMap.put(new FileAndUrn(fd), newDoc);
            assert (oldDoc != null) : "attempted to replace doc that did not exist!!";
            this.removeKeywords(oldDoc);
            if (!this.isLWSDoc(newDoc)) {
                this.addKeywords(newDoc);
            }
        }
        boolean replaced = fd.replaceLimeXMLDocument(oldDoc, newDoc);
        assert (replaced);
        return oldDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDoc(FileDesc fd) {
        LimeXMLDocument val;
        Object object = this.LOCK;
        synchronized (object) {
            val = this.mainMap.remove(new FileAndUrn(fd));
            if (val != null) {
                this.dirty = true;
            }
        }
        if (val != null) {
            fd.removeLimeXMLDocument(val);
            this.removeKeywords(val);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("removed: " + val);
        }
        return val != null;
    }

    public MetaDataState mediaFileToDisk(FileDesc fd, LimeXMLDocument doc) {
        MetaDataWriter writer;
        MetaDataState writeState = MetaDataState.UNCHANGED;
        if (LOG.isDebugEnabled()) {
            LOG.debug("writing: " + fd.getFile() + " to disk.");
        }
        if ((writer = this.getEditorIfNeeded(fd.getFile(), doc)) != null) {
            writeState = this.commitMetaData(fd, writer);
        }
        assert (writeState != MetaDataState.INCORRECT_FILETYPE) : "trying to write data to unwritable file of type " + FileUtils.getFileExtension(fd.getFile());
        return writeState;
    }

    private MetaDataWriter getEditorIfNeeded(File file, LimeXMLDocument doc) {
        if (!this.metaDataFactory.get().containsEditor(file.getName())) {
            return null;
        }
        MetaDataWriter newValues = new MetaDataWriter(file.getPath(), this.metaDataFactory.get());
        newValues.populate(doc);
        MetaData existing = null;
        try {
            existing = this.metaDataFactory.get().parse(file);
        }
        catch (IOException e) {
            return null;
        }
        if (!newValues.needsToUpdate(existing)) {
            LOG.debug("tag read from disk is same as XML doc.");
            return null;
        }
        return newValues;
    }

    private MetaDataState commitMetaData(FileDesc fd, MetaDataWriter editor) {
        MetaDataState retVal = editor.commitMetaData();
        if (LOG.isDebugEnabled()) {
            LOG.debug("wrote data: " + (Object)((Object)retVal));
        }
        if (retVal == MetaDataState.FILE_DEFECTIVE || retVal == MetaDataState.RW_ERROR || retVal == MetaDataState.BAD_ID3 || retVal == MetaDataState.INCORRECT_FILETYPE) {
            return retVal;
        }
        List<LimeXMLDocument> currentXmlDocs = fd.getLimeXMLDocuments();
        if (this.metaDataFactory.get().containsEditor(fd.getFile().getName())) {
            try {
                LimeXMLDocument newAudioXmlDoc = this.metaDataReader.get().readDocument(fd.getFile());
                LimeXMLDocument oldAudioXmlDoc = this.getAudioDoc(currentXmlDocs);
                if (oldAudioXmlDoc == null || !oldAudioXmlDoc.equals(newAudioXmlDoc)) {
                    currentXmlDocs = this.mergeAudioDocs(currentXmlDocs, oldAudioXmlDoc, newAudioXmlDoc);
                }
            }
            catch (IOException e) {
                currentXmlDocs = Collections.emptyList();
            }
        }
        this.library.get().fileChanged(fd.getFile(), currentXmlDocs);
        return retVal;
    }

    private LimeXMLDocument getAudioDoc(List<LimeXMLDocument> allDocs) {
        LimeXMLDocument audioDoc = null;
        for (LimeXMLDocument doc : allDocs) {
            if (!doc.getSchema().getSchemaURI().equals("http://www.limewire.com/schemas/audio.xsd")) continue;
            audioDoc = doc;
            break;
        }
        return audioDoc;
    }

    private List<LimeXMLDocument> mergeAudioDocs(List<LimeXMLDocument> allDocs, LimeXMLDocument oldAudioDoc, LimeXMLDocument newAudioDoc) {
        ArrayList<LimeXMLDocument> retList = new ArrayList<LimeXMLDocument>();
        retList.addAll(allDocs);
        if (oldAudioDoc == null) {
            retList.add(newAudioDoc);
        } else {
            retList.remove(oldAudioDoc);
            List<NameValue<String>> oldAudioList = oldAudioDoc.getOrderedNameValueList();
            List<NameValue<String>> newAudioList = newAudioDoc.getOrderedNameValueList();
            for (int i = 0; i < oldAudioList.size(); ++i) {
                NameValue<String> nameVal = oldAudioList.get(i);
                if (!AudioMetaData.isNonLimeAudioField(nameVal.getName())) continue;
                newAudioList.add(nameVal);
            }
            oldAudioDoc = this.limeXMLDocumentFactory.get().createLimeXMLDocument(newAudioList, "http://www.limewire.com/schemas/audio.xsd");
            retList.add(oldAudioDoc);
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeMapToDisk() {
        HashMap<FileAndUrn, String> xmlMap;
        boolean wrote = false;
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.dirty) {
                LOG.debug("Not writing because not dirty.");
                return true;
            }
            xmlMap = new HashMap<FileAndUrn, String>(this.mainMap.size());
            for (Map.Entry<FileAndUrn, LimeXMLDocument> entry : this.mainMap.entrySet()) {
                xmlMap.put(entry.getKey(), ((GenericXmlDocument)entry.getValue()).getXmlWithVersion());
            }
            this.dirty = false;
        }
        File dataFile = new File(this.savedDocsDir, LimeXMLSchema.getDisplayString(this.schemaURI) + ".sxml3");
        File parent = dataFile.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(dataFile)));
            out.writeObject(xmlMap);
            out.flush();
            wrote = true;
            IOUtils.close(out);
        }
        catch (IOException ignored) {
            LOG.trace("Unable to write", ignored);
        }
        finally {
            IOUtils.close(out);
        }
        return wrote;
    }

    private Map<?, LimeXMLDocument> readMapFromDisk() {
        File v3File = new File(this.savedDocsDir, LimeXMLSchema.getDisplayString(this.schemaURI) + ".sxml3");
        Map<Serializable, LimeXMLDocument> map = null;
        if (v3File.exists()) {
            map = this.readVersion3File(v3File);
        } else {
            File v2File = new File(this.savedDocsDir, LimeXMLSchema.getDisplayString(this.schemaURI) + ".sxml2");
            if (v2File.exists()) {
                map = this.readVersion2File(v2File);
            } else {
                File v1File = new File(this.savedDocsDir, LimeXMLSchema.getDisplayString(this.schemaURI) + ".sxml");
                if (v1File.exists()) {
                    map = this.readVersion1File(v1File);
                    v1File.delete();
                }
            }
        }
        if (map == null) {
            return Collections.emptyMap();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<FileAndUrn, LimeXMLDocument> readVersion3File(File input) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading new format from file: " + input);
        }
        ObjectInputStream in = null;
        Map<Object, Object> read = null;
        try {
            in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(input)));
            read = GenericsUtils.scanForMap(in.readObject(), FileAndUrn.class, String.class, GenericsUtils.ScanMode.REMOVE);
        }
        catch (Throwable t) {
            try {
                LOG.error("Unable to read LimeXMLCollection", t);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.close(in);
            }
        }
        IOUtils.close(in);
        if (read == null) {
            read = Collections.emptyMap();
        }
        HashMap<FileAndUrn, LimeXMLDocument> docMap = new HashMap<FileAndUrn, LimeXMLDocument>(read.size());
        for (Map.Entry<Object, Object> entry : read.entrySet()) {
            try {
                docMap.put((FileAndUrn)entry.getKey(), this.limeXMLDocumentFactory.get().createLimeXMLDocument((String)entry.getValue()));
            }
            catch (IOException ignored) {
                LOG.warn("Error creating document for: " + (String)entry.getValue(), ignored);
            }
            catch (SchemaNotFoundException ignored) {
                LOG.warn("Error creating document: " + (String)entry.getValue(), ignored);
            }
            catch (SAXException ignored) {
                LOG.warn("Error creating document: " + (String)entry.getValue(), ignored);
            }
        }
        return docMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<URN, LimeXMLDocument> readVersion2File(File input) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading new format from file: " + input);
        }
        ObjectInputStream in = null;
        Map<Object, Object> read = null;
        try {
            in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(input)));
            read = GenericsUtils.scanForMap(in.readObject(), URN.class, String.class, GenericsUtils.ScanMode.REMOVE);
        }
        catch (Throwable t) {
            try {
                LOG.error("Unable to read LimeXMLCollection", t);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.close(in);
            }
        }
        IOUtils.close(in);
        if (read == null) {
            read = Collections.emptyMap();
        }
        HashMap<URN, LimeXMLDocument> docMap = new HashMap<URN, LimeXMLDocument>(read.size());
        for (Map.Entry<Object, Object> entry : read.entrySet()) {
            try {
                docMap.put((URN)entry.getKey(), this.limeXMLDocumentFactory.get().createLimeXMLDocument((String)entry.getValue()));
            }
            catch (IOException ignored) {
                LOG.warn("Error creating document for: " + (String)entry.getValue(), ignored);
            }
            catch (SchemaNotFoundException ignored) {
                LOG.warn("Error creating document: " + (String)entry.getValue(), ignored);
            }
            catch (SAXException ignored) {
                LOG.warn("Error creating document: " + (String)entry.getValue(), ignored);
            }
        }
        return docMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<URN, LimeXMLDocument> readVersion1File(File input) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading old format from file: " + input);
        }
        ConverterObjectInputStream in = null;
        Map<Object, Object> read = null;
        try {
            in = new ConverterObjectInputStream(new BufferedInputStream(new FileInputStream(input)));
            in.addLookup("com.limegroup.gnutella.xml.LimeXMLDocument", SerialXml.class.getName());
            read = GenericsUtils.scanForMap(in.readObject(), URN.class, SerialXml.class, GenericsUtils.ScanMode.REMOVE);
        }
        catch (Throwable t) {
            try {
                LOG.error("Unable to read LimeXMLCollection", t);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.close(in);
            }
        }
        IOUtils.close(in);
        if (read == null) {
            read = Collections.emptyMap();
        }
        HashMap<URN, LimeXMLDocument> docMap = new HashMap<URN, LimeXMLDocument>(read.size());
        for (Map.Entry entry : read.entrySet()) {
            try {
                docMap.put((URN)entry.getKey(), this.limeXMLDocumentFactory.get().createLimeXMLDocument(((SerialXml)entry.getValue()).getXml(true)));
            }
            catch (IOException ignored) {
                LOG.warn("Error creating document for: " + entry.getValue(), ignored);
            }
            catch (SchemaNotFoundException ignored) {
                LOG.warn("Error creating document: " + entry.getValue(), ignored);
            }
            catch (SAXException ignored) {
                LOG.warn("Error creating document: " + entry.getValue(), ignored);
            }
        }
        return docMap;
    }

    public String toString() {
        return StringUtils.toString(this, new Object[0]);
    }

    private static class FileAndUrn
    implements Serializable {
        private static final long serialVersionUID = 6914168193085067395L;
        private final File file;
        private final URN urn;

        public FileAndUrn(FileDesc fd) {
            this.file = fd.getFile();
            this.urn = fd.getSHA1Urn();
        }

        public int hashCode() {
            return this.file.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof FileAndUrn) {
                FileAndUrn o2 = (FileAndUrn)obj;
                return Objects.equalOrNull(this.urn, o2.urn) && o2.file.equals(this.file);
            }
            return false;
        }
    }

    public static enum MetaDataState {
        UNCHANGED,
        NORMAL,
        FILE_DEFECTIVE,
        RW_ERROR,
        BAD_ID3,
        FAILED_TITLE,
        FAILED_ARTIST,
        FAILED_ALBUM,
        FAILED_YEAR,
        FAILED_COMMENT,
        FAILED_TRACK,
        FAILED_GENRE,
        HASH_FAILED,
        INCORRECT_FILETYPE;

    }
}

