/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil;

import eu.medsea.mimeutil.MimeType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

class MimeTypeHashSet
implements Set,
Collection {
    private Set hashSet = new LinkedHashSet();

    MimeTypeHashSet() {
    }

    MimeTypeHashSet(Collection collection) {
        this.addAll(collection);
    }

    MimeTypeHashSet(int n) {
        this.hashSet = new HashSet(n);
    }

    MimeTypeHashSet(int n, float f) {
        this.hashSet = new HashSet(n, f);
    }

    MimeTypeHashSet(String string) {
        this.add(string);
    }

    MimeTypeHashSet(String[] stringArray) {
        this.add(stringArray);
    }

    MimeTypeHashSet(MimeType mimeType) {
        this.add(mimeType);
    }

    public boolean add(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof MimeType) {
            this.updateSpecificity(object);
            return this.hashSet.add(object);
        }
        if (object instanceof Collection) {
            return this.addAll((Collection)object);
        }
        if (object instanceof String) {
            String[] stringArray = ((String)object).split(",");
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    if (!this.add(new MimeType(stringArray[i]))) continue;
                    bl = true;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return bl;
        }
        if (object instanceof String[]) {
            boolean bl = false;
            String[] stringArray = (String[])object;
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split(",");
                for (int j = 0; j < stringArray2.length; ++j) {
                    try {
                        if (!this.add(new MimeType(stringArray2[j]))) continue;
                        bl = true;
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return bl;
        }
        return false;
    }

    public boolean addAll(Collection collection) throws NullPointerException {
        if (collection == null) {
            throw new NullPointerException();
        }
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            try {
                if (!this.add(iterator.next())) continue;
                bl = true;
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    @Override
    public void clear() {
        this.hashSet.clear();
    }

    @Override
    public boolean contains(Object object) {
        if (object instanceof MimeType) {
            return this.hashSet.contains(object);
        }
        if (object instanceof Collection) {
            return this.containsAll((Collection)object);
        }
        if (object instanceof String) {
            String[] stringArray = ((String)object).split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                if (this.contains(new MimeType(stringArray[i]))) continue;
                return false;
            }
            return true;
        }
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split(",");
                for (int j = 0; j < stringArray2.length; ++j) {
                    if (this.contains(new MimeType(stringArray2[j]))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.hashSet.isEmpty();
    }

    @Override
    public Iterator iterator() {
        return this.hashSet.iterator();
    }

    @Override
    public boolean remove(Object object) {
        boolean bl = false;
        if (object == null) {
            return bl;
        }
        if (object instanceof MimeType) {
            return this.hashSet.remove(object);
        }
        if (object instanceof String) {
            String[] stringArray = ((String)object).split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                if (!this.remove(new MimeType(stringArray[i]))) continue;
                bl = true;
            }
        } else if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split(",");
                for (int j = 0; j < stringArray2.length; ++j) {
                    if (!this.remove(new MimeType(stringArray2[j]))) continue;
                    bl = true;
                }
            }
        } else if (object instanceof Collection) {
            return this.removeAll((Collection)object);
        }
        return bl;
    }

    public boolean removeAll(Collection collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!this.remove(iterator.next())) continue;
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        MimeTypeHashSet mimeTypeHashSet = new MimeTypeHashSet(collection);
        return this.hashSet.retainAll(mimeTypeHashSet);
    }

    @Override
    public int size() {
        return this.hashSet.size();
    }

    @Override
    public Object[] toArray() {
        return this.hashSet.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.hashSet.toArray(objectArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((MimeType)iterator.next()).toString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        MimeTypeHashSet mimeTypeHashSet = new MimeTypeHashSet();
        mimeTypeHashSet.add(object);
        return this.match(mimeTypeHashSet);
    }

    private boolean match(Collection collection) {
        if (this.size() != collection.size()) {
            return false;
        }
        MimeType[] mimeTypeArray = collection.toArray(new MimeType[collection.size()]);
        for (int i = 0; i < mimeTypeArray.length; ++i) {
            if (this.contains(mimeTypeArray[i])) continue;
            return false;
        }
        return true;
    }

    private void updateSpecificity(Object object) {
        if (object instanceof MimeType) {
            this.updateMimeType((MimeType)object);
        } else {
            Collection collection = (Collection)object;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.updateMimeType((MimeType)iterator.next());
            }
        }
    }

    private void updateMimeType(MimeType mimeType) {
        if (!this.hashSet.contains(mimeType)) {
            return;
        }
        for (MimeType mimeType2 : this.hashSet) {
            if (!mimeType2.equals(mimeType)) continue;
            mimeType2.setSpecificity(mimeType2.getSpecificity() + mimeType.getSpecificity());
            return;
        }
    }

    public Collection matches(String string) {
        MimeTypeHashSet mimeTypeHashSet = new MimeTypeHashSet();
        for (MimeType mimeType : this) {
            if (!mimeType.toString().matches(string)) continue;
            mimeTypeHashSet.add(mimeType);
        }
        return mimeTypeHashSet;
    }
}

