/*
 * Decompiled with CFR 0.152.
 */
package javax.media.format;

import java.awt.Dimension;
import javax.media.Format;
import javax.media.format.VideoFormat;
import net.sf.fmj.codegen.FormatTraceUtils;
import net.sf.fmj.utility.FormatUtils;

public class RGBFormat
extends VideoFormat {
    protected int redMask = -1;
    protected int greenMask = -1;
    protected int blueMask = -1;
    protected int bitsPerPixel = -1;
    protected int pixelStride = -1;
    protected int lineStride = -1;
    protected int flipped = -1;
    protected int endian = -1;
    public static final int BIG_ENDIAN = 0;
    public static final int LITTLE_ENDIAN = 1;
    private static String ENCODING = "rgb";

    public RGBFormat() {
        super(ENCODING);
        this.dataType = null;
    }

    public RGBFormat(Dimension size, int maxDataLength, Class dataType, float frameRate, int bitsPerPixel, int red, int green, int blue) {
        super(ENCODING, size, maxDataLength, dataType, frameRate);
        this.bitsPerPixel = bitsPerPixel;
        this.redMask = red;
        this.greenMask = green;
        this.blueMask = blue;
        this.flipped = 0;
        this.pixelStride = dataType == null || bitsPerPixel == -1 ? -1 : (dataType == byteArray ? bitsPerPixel / 8 : 1);
        this.endian = dataType == byteArray && bitsPerPixel == 16 ? 1 : -1;
        this.lineStride = dataType == null || size == null || bitsPerPixel == -1 ? -1 : (dataType == byteArray ? size.width * (bitsPerPixel / 8) : size.width);
    }

    public RGBFormat(Dimension size, int maxDataLength, Class dataType, float frameRate, int bitsPerPixel, int red, int green, int blue, int pixelStride, int lineStride, int flipped, int endian) {
        super(ENCODING, size, maxDataLength, dataType, frameRate);
        this.bitsPerPixel = bitsPerPixel;
        this.redMask = red;
        this.greenMask = green;
        this.blueMask = blue;
        this.pixelStride = pixelStride;
        this.lineStride = lineStride;
        this.flipped = flipped;
        this.endian = endian;
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public int getRedMask() {
        return this.redMask;
    }

    public int getGreenMask() {
        return this.greenMask;
    }

    public int getBlueMask() {
        return this.blueMask;
    }

    public int getPixelStride() {
        return this.pixelStride;
    }

    public int getLineStride() {
        return this.lineStride;
    }

    public int getFlipped() {
        return this.flipped;
    }

    public int getEndian() {
        return this.endian;
    }

    public Object clone() {
        RGBFormat result = new RGBFormat(FormatUtils.clone(this.size), this.maxDataLength, this.dataType, this.frameRate, this.bitsPerPixel, this.redMask, this.greenMask, this.blueMask, this.pixelStride, this.lineStride, this.flipped, this.endian);
        FormatTraceUtils.traceClone(this, result);
        return result;
    }

    protected void copy(Format f) {
        super.copy(f);
        RGBFormat oCast = (RGBFormat)f;
        this.bitsPerPixel = oCast.bitsPerPixel;
        this.redMask = oCast.redMask;
        this.greenMask = oCast.greenMask;
        this.blueMask = oCast.blueMask;
        this.pixelStride = oCast.pixelStride;
        this.lineStride = oCast.lineStride;
        this.flipped = oCast.flipped;
        this.endian = oCast.endian;
    }

    public boolean equals(Object format) {
        if (!super.equals(format)) {
            FormatTraceUtils.traceEquals(this, (Format)format, false);
            return false;
        }
        if (!(format instanceof RGBFormat)) {
            FormatTraceUtils.traceEquals(this, (Format)format, false);
            return false;
        }
        RGBFormat oCast = (RGBFormat)format;
        boolean result = this.bitsPerPixel == oCast.bitsPerPixel && this.redMask == oCast.redMask && this.greenMask == oCast.greenMask && this.blueMask == oCast.blueMask && this.pixelStride == oCast.pixelStride && this.lineStride == oCast.lineStride && this.flipped == oCast.flipped && this.endian == oCast.endian;
        FormatTraceUtils.traceEquals(this, (Format)format, result);
        return result;
    }

    public boolean matches(Format format) {
        if (!super.matches(format)) {
            FormatTraceUtils.traceMatches(this, format, false);
            return false;
        }
        if (!(format instanceof RGBFormat)) {
            boolean result = true;
            FormatTraceUtils.traceMatches(this, format, true);
            return true;
        }
        RGBFormat oCast = (RGBFormat)format;
        boolean result = FormatUtils.matches(this.bitsPerPixel, oCast.bitsPerPixel) && FormatUtils.matches(this.redMask, oCast.redMask) && FormatUtils.matches(this.greenMask, oCast.greenMask) && FormatUtils.matches(this.blueMask, oCast.blueMask) && FormatUtils.matches(this.pixelStride, oCast.pixelStride) && FormatUtils.matches(this.flipped, oCast.flipped) && FormatUtils.matches(this.endian, oCast.endian);
        FormatTraceUtils.traceMatches(this, format, result);
        return result;
    }

    public Format intersects(Format other) {
        Format result = super.intersects(other);
        if (other instanceof RGBFormat) {
            RGBFormat resultCast = (RGBFormat)result;
            RGBFormat oCast = (RGBFormat)other;
            if (this.getClass().isAssignableFrom(other.getClass())) {
                if (FormatUtils.specified(this.bitsPerPixel)) {
                    resultCast.bitsPerPixel = this.bitsPerPixel;
                }
                if (FormatUtils.specified(this.redMask)) {
                    resultCast.redMask = this.redMask;
                }
                if (FormatUtils.specified(this.greenMask)) {
                    resultCast.greenMask = this.greenMask;
                }
                if (FormatUtils.specified(this.blueMask)) {
                    resultCast.blueMask = this.blueMask;
                }
                if (FormatUtils.specified(this.pixelStride)) {
                    resultCast.pixelStride = this.pixelStride;
                }
                if (FormatUtils.specified(this.lineStride)) {
                    resultCast.lineStride = this.lineStride;
                }
                if (FormatUtils.specified(this.flipped)) {
                    resultCast.flipped = this.flipped;
                }
                if (FormatUtils.specified(this.endian)) {
                    resultCast.endian = this.endian;
                }
            } else {
                if (!FormatUtils.specified(resultCast.bitsPerPixel)) {
                    resultCast.bitsPerPixel = oCast.bitsPerPixel;
                }
                if (!FormatUtils.specified(resultCast.redMask)) {
                    resultCast.redMask = oCast.redMask;
                }
                if (!FormatUtils.specified(resultCast.greenMask)) {
                    resultCast.greenMask = oCast.greenMask;
                }
                if (!FormatUtils.specified(resultCast.blueMask)) {
                    resultCast.blueMask = oCast.blueMask;
                }
                if (!FormatUtils.specified(resultCast.pixelStride)) {
                    resultCast.pixelStride = oCast.pixelStride;
                }
                if (!FormatUtils.specified(resultCast.lineStride)) {
                    resultCast.lineStride = oCast.lineStride;
                }
                if (!FormatUtils.specified(resultCast.flipped)) {
                    resultCast.flipped = oCast.flipped;
                }
                if (!FormatUtils.specified(resultCast.endian)) {
                    resultCast.endian = oCast.endian;
                }
            }
        }
        FormatTraceUtils.traceIntersects(this, other, result);
        return result;
    }

    public Format relax() {
        RGBFormat result = (RGBFormat)super.relax();
        result.lineStride = -1;
        result.pixelStride = -1;
        FormatTraceUtils.traceRelax(this, result);
        return result;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("RGB");
        if (this.size != null) {
            b.append(", " + (int)this.size.getWidth() + "x" + (int)this.size.getHeight());
        }
        if (this.frameRate != -1.0f) {
            b.append(", FrameRate=" + FormatUtils.frameRateToString(this.frameRate));
        }
        if (this.maxDataLength != -1) {
            b.append(", Length=" + this.maxDataLength);
        }
        b.append(", " + this.bitsPerPixel + "-bit" + ", Masks=" + this.redMask + ":" + this.greenMask + ":" + this.blueMask + ", PixelStride=" + this.pixelStride + ", LineStride=" + this.lineStride);
        if (this.flipped == 1) {
            b.append(", Flipped");
        }
        return b.toString();
    }
}

