/*
 * Decompiled with CFR 0.152.
 */
package javax.media.rtp;

import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Controls;
import javax.media.Format;
import javax.media.PackageManager;
import javax.media.format.UnsupportedFormatException;
import javax.media.protocol.DataSource;
import javax.media.rtp.EncryptionInfo;
import javax.media.rtp.GlobalReceptionStats;
import javax.media.rtp.GlobalTransmissionStats;
import javax.media.rtp.InvalidSessionAddressException;
import javax.media.rtp.LocalParticipant;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.RemoteListener;
import javax.media.rtp.SendStream;
import javax.media.rtp.SendStreamListener;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.SessionListener;
import javax.media.rtp.rtcp.SourceDescription;
import net.sf.fmj.utility.LoggerSingleton;

public abstract class RTPManager
implements Controls {
    private static final Logger logger = LoggerSingleton.logger;

    public abstract void addFormat(Format var1, int var2);

    public abstract void addReceiveStreamListener(ReceiveStreamListener var1);

    public abstract void addRemoteListener(RemoteListener var1);

    public abstract void addSendStreamListener(SendStreamListener var1);

    public abstract void addSessionListener(SessionListener var1);

    public abstract void removeTarget(SessionAddress var1, String var2) throws InvalidSessionAddressException;

    public abstract void removeTargets(String var1);

    public abstract SendStream createSendStream(DataSource var1, int var2) throws UnsupportedFormatException, IOException;

    public abstract void dispose();

    public abstract Vector getActiveParticipants();

    public abstract Vector getAllParticipants();

    public abstract GlobalReceptionStats getGlobalReceptionStats();

    public abstract GlobalTransmissionStats getGlobalTransmissionStats();

    public abstract LocalParticipant getLocalParticipant();

    public abstract Vector getPassiveParticipants();

    public abstract Vector getReceiveStreams();

    public abstract Vector getRemoteParticipants();

    public abstract Vector getSendStreams();

    public abstract void initialize(SessionAddress var1) throws InvalidSessionAddressException, IOException;

    public abstract void initialize(SessionAddress[] var1, SourceDescription[] var2, double var3, double var5, EncryptionInfo var7) throws InvalidSessionAddressException, IOException;

    public abstract void initialize(RTPConnector var1);

    public abstract void addTarget(SessionAddress var1) throws InvalidSessionAddressException, IOException;

    public abstract void removeReceiveStreamListener(ReceiveStreamListener var1);

    public abstract void removeRemoteListener(RemoteListener var1);

    public abstract void removeSendStreamListener(SendStreamListener var1);

    public abstract void removeSessionListener(SessionListener var1);

    public static RTPManager newInstance() {
        Vector v = RTPManager.getRTPManagerList();
        for (int i = 0; i < v.size(); ++i) {
            String className = (String)v.get(i);
            try {
                logger.finer("Trying RTPManager class: " + className);
                Class<?> clazz = Class.forName(className);
                return (RTPManager)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                logger.finer("RTPManager.newInstance: ClassNotFoundException: " + className);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "" + e, e);
            }
        }
        return null;
    }

    public static Vector getRTPManagerList() {
        Vector<String> result = new Vector<String>();
        Vector prefixList = PackageManager.getProtocolPrefixList();
        for (int i = 0; i < prefixList.size(); ++i) {
            String prefix = (String)prefixList.get(i);
            result.add(prefix + ".media.rtp.RTPSessionMgr");
        }
        return result;
    }
}

