/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.gst.media.content.unknown;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.ClockStoppedException;
import javax.media.IncompatibleSourceException;
import javax.media.MediaLocator;
import javax.media.Time;
import javax.media.protocol.DataSource;
import net.sf.fmj.ejmf.toolkit.media.AbstractPlayer;
import net.sf.fmj.gui.controlpanelfactory.ControlPanelFactorySingleton;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.URLUtils;
import org.gstreamer.Bus;
import org.gstreamer.Gst;
import org.gstreamer.GstObject;
import org.gstreamer.MainLoop;
import org.gstreamer.elements.PlayBin;
import org.gstreamer.swing.GstVideoComponent;

public class Handler
extends AbstractPlayer {
    private static final Logger logger = LoggerSingleton.logger;
    private boolean prefetchNeeded = true;
    private static final boolean TRACE = true;
    private PlayBin playbin;
    private GstVideoComponent videoComponent;
    private static boolean gstInitialized;

    private static void initGstreamer() {
        if (gstInitialized) {
            return;
        }
        logger.info("Initializing gstreamer");
        try {
            Gst.init((String)"FMJ GStreamer Handler", (String[])new String[0]);
            Thread t = new Thread("GST MainLoop Thread"){

                public void run() {
                    new MainLoop().run();
                }
            };
            t.setDaemon(true);
            t.start();
            gstInitialized = true;
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Unable to initialize gstreamer: " + t, t);
        }
    }

    public void setSource(DataSource source) throws IncompatibleSourceException {
        logger.fine("DataSource: " + source);
        Handler.initGstreamer();
        if (!gstInitialized) {
            throw new IncompatibleSourceException("Unable to initialize gstreamer");
        }
        if (source.getLocator() == null) {
            throw new IncompatibleSourceException("null source locator");
        }
        super.setSource(source);
    }

    public void doPlayerClose() {
        logger.info("Handler.doPlayerClose");
    }

    public boolean doPlayerDeallocate() {
        logger.info("Handler.doPlayerDeallocate");
        return true;
    }

    public boolean doPlayerPrefetch() {
        if (!this.prefetchNeeded) {
            return true;
        }
        this.prefetchNeeded = false;
        return true;
    }

    public boolean doPlayerRealize() {
        String newUrl;
        MediaLocator locator = this.getSource().getLocator();
        if (locator.getProtocol().equals("file") && (newUrl = URLUtils.createAbsoluteFileUrl(locator.toExternalForm())) != null) {
            MediaLocator newSource = new MediaLocator(newUrl);
            if (!locator.toExternalForm().equals(newSource.toExternalForm())) {
                logger.warning("Changing file URL to absolute, from " + locator.toExternalForm() + " to " + newSource);
                locator = newSource;
            }
        }
        String path = locator.toExternalForm();
        URI uri = Handler.parseURI(path);
        this.playbin = new PlayBin(uri.toString());
        this.playbin.setURI(uri);
        this.videoComponent = new GstVideoComponent();
        this.playbin.getBus().connect(new Bus.EOS(){

            public void eosMessage(GstObject source) {
                logger.info("GST eosMessage");
                Thread thread = new Thread("GST EOS Thread"){

                    public void run() {
                        Handler.this.playbin.stop();
                        logger.info("GST eosMessage, posting EOM");
                        try {
                            Handler.this.endOfMedia();
                        }
                        catch (ClockStoppedException e) {
                            logger.log(Level.WARNING, "" + e, e);
                        }
                        logger.info("GST eosMessage, done");
                    }
                };
                Handler.this.getThreadQueue().addThread(thread);
            }
        });
        this.playbin.setVideoSink(this.videoComponent.getElement());
        this.videoComponent.setPreferredSize(new Dimension(640, 480));
        return true;
    }

    private static URI parseURI(String uri) {
        try {
            URI u = new URI(uri);
            if (u.getScheme() == null) {
                throw new URISyntaxException(uri, "Invalid URI scheme");
            }
            return u;
        }
        catch (URISyntaxException e) {
            File f = new File(uri);
            if (!f.exists()) {
                throw new IllegalArgumentException("Invalid URI/file " + uri, e);
            }
            return f.toURI();
        }
    }

    public void doPlayerSetMediaTime(Time t) {
        logger.info("Handler.doPlayerSetMediaTime " + t.getNanoseconds());
        this.playbin.setPosition(new org.gstreamer.Time(t.getNanoseconds()));
    }

    public float doPlayerSetRate(float rate) {
        logger.fine("Handler.doPlayerSetRate " + rate);
        return rate;
    }

    public boolean doPlayerStop() {
        logger.fine("Handler.doPlayerStop ");
        this.playbin.stop();
        return true;
    }

    public boolean doPlayerSyncStart(Time t) {
        logger.info("Handler.doPlayerSyncStart" + t);
        if (!this.playbin.isPlaying()) {
            this.playbin.play();
        }
        return true;
    }

    public Time getPlayerDuration() {
        if (this.getState() < 300) {
            return DURATION_UNKNOWN;
        }
        long durationNanos = this.playbin.getDuration().longValue();
        if (durationNanos <= 0L) {
            return DURATION_UNKNOWN;
        }
        return new Time(durationNanos);
    }

    public synchronized Time getMediaTime() {
        if (this.getState() < 300) {
            return super.getMediaTime();
        }
        return new Time(this.playbin.getPosition().longValue());
    }

    public Time getPlayerStartLatency() {
        return new Time(0L);
    }

    public Component getVisualComponent() {
        return this.videoComponent;
    }

    public Component getControlPanelComponent() {
        Component c = super.getControlPanelComponent();
        if (c == null) {
            c = ControlPanelFactorySingleton.getInstance().getControlPanelComponent(this);
            this.setControlPanelComponent(c);
        }
        return c;
    }
}

