/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import com.lti.utils.OSUtils;
import com.sun.media.format.WavAudioFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.media.Format;
import javax.media.PackageManager;
import javax.media.format.AudioFormat;
import javax.media.format.JPEGFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import javax.media.pim.PlugInManager;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.FileTypeDescriptor;
import net.sf.fmj.registry.Registry;
import net.sf.fmj.utility.PlugInInfo;
import net.sf.fmj.utility.PlugInUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryDefaults {
    public static final int JMF = 1;
    public static final int FMJ = 2;
    public static final int FMJ_NATIVE = 8;
    public static final int THIRD_PARTY = 4;
    public static final int NONE = 0;
    public static final int ALL = 15;
    private static final boolean ENABLE_GSTREAMER = false;
    public static boolean DISABLE_OGG = false;
    private static int defaultFlags = -1;

    public static final int getDefaultFlags() {
        if (defaultFlags == -1) {
            boolean jmfDefaults = false;
            try {
                jmfDefaults = System.getProperty("net.sf.fmj.utility.JmfRegistry.JMFDefaults", "false").equals("true");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            defaultFlags = jmfDefaults ? 1 : 15;
        }
        return defaultFlags;
    }

    public static final void setDefaultFlags(int flags) {
        defaultFlags = flags;
    }

    public static void registerAll(int flags) {
        RegistryDefaults.registerProtocolPrefixList(flags);
        RegistryDefaults.registerContentPrefixList(flags);
        RegistryDefaults.registerPlugins(flags);
    }

    public static void unRegisterAll(int flags) {
        RegistryDefaults.unRegisterProtocolPrefixList(flags);
        RegistryDefaults.unRegisterContentPrefixList(flags);
        RegistryDefaults.unRegisterPlugins(flags);
    }

    public static void registerProtocolPrefixList(int flags) {
        if (flags == 0) {
            return;
        }
        Vector v = PackageManager.getProtocolPrefixList();
        List<String> add = RegistryDefaults.protocolPrefixList(flags);
        for (String s : add) {
            if (v.contains(s)) continue;
            v.add(s);
        }
        PackageManager.setProtocolPrefixList(v);
    }

    public static void registerContentPrefixList(int flags) {
        if (flags == 0) {
            return;
        }
        Vector v = PackageManager.getContentPrefixList();
        List<String> add = RegistryDefaults.contentPrefixList(flags);
        for (String s : add) {
            if (v.contains(s)) continue;
            v.add(s);
        }
        PackageManager.setContentPrefixList(v);
    }

    public static void unRegisterProtocolPrefixList(int flags) {
        if (flags == 0) {
            return;
        }
        Vector v = PackageManager.getProtocolPrefixList();
        List<String> add = RegistryDefaults.protocolPrefixList(flags);
        for (String s : add) {
            if (!v.contains(s)) continue;
            v.remove(s);
        }
        PackageManager.setProtocolPrefixList(v);
    }

    public static void unRegisterContentPrefixList(int flags) {
        if (flags == 0) {
            return;
        }
        Vector v = PackageManager.getContentPrefixList();
        List<String> add = RegistryDefaults.contentPrefixList(flags);
        for (String s : add) {
            if (!v.contains(s)) continue;
            v.remove(s);
        }
        PackageManager.setContentPrefixList(v);
    }

    public static List<String> protocolPrefixList(int flags) {
        ArrayList<String> protocolPrefixList = new ArrayList<String>();
        if ((flags & 1) != 0) {
            protocolPrefixList.add("javax");
            protocolPrefixList.add("com.sun");
            protocolPrefixList.add("com.ibm");
        }
        if ((flags & 8) != 0) {
            if (OSUtils.isMacOSX() || OSUtils.isWindows()) {
                protocolPrefixList.add("net.sf.fmj.qt");
            }
            if (OSUtils.isWindows()) {
                protocolPrefixList.add("net.sf.fmj.ds");
            }
        }
        if ((flags & 2) != 0) {
            protocolPrefixList.add("net.sf.fmj");
        }
        if ((flags & 4) != 0) {
            protocolPrefixList.add("com.omnividea");
        }
        return protocolPrefixList;
    }

    public static List<String> contentPrefixList(int flags) {
        ArrayList<String> contentPrefixList = new ArrayList<String>();
        if ((flags & 1) != 0) {
            contentPrefixList.add("javax");
            contentPrefixList.add("com.sun");
            contentPrefixList.add("com.ibm");
        }
        if ((flags & 8) != 0) {
            if (OSUtils.isMacOSX() || OSUtils.isWindows()) {
                contentPrefixList.add("net.sf.fmj.qt");
            }
            if (OSUtils.isWindows()) {
                contentPrefixList.add("net.sf.fmj.ds");
            }
        }
        if ((flags & 2) != 0) {
            contentPrefixList.add("net.sf.fmj");
        }
        if ((flags & 4) != 0) {
            // empty if block
        }
        return contentPrefixList;
    }

    public static void registerPlugins(int flags) {
        if (flags == 0) {
            return;
        }
        List<Object> list = RegistryDefaults.plugInList(flags);
        for (Object o : list) {
            if (o instanceof PlugInInfo) {
                PlugInInfo i = (PlugInInfo)o;
                PlugInManager.addPlugIn(i.className, i.in, i.out, i.type);
                continue;
            }
            PlugInUtility.registerPlugIn((String)o);
        }
    }

    public static List<Object> plugInList(int flags) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (flags == 0) {
            return result;
        }
        if ((flags & 1) != 0) {
            result.add(new PlugInInfo("com.ibm.media.parser.video.MpegParser", new Format[]{new ContentDescriptor("audio.mpeg"), new ContentDescriptor("video.mpeg"), new ContentDescriptor("audio.mpeg")}, new Format[0], 1));
            result.add(new PlugInInfo("com.sun.media.parser.audio.WavParser", new Format[]{new ContentDescriptor("audio.x_wav")}, new Format[0], 1));
            result.add(new PlugInInfo("com.sun.media.parser.audio.AuParser", new Format[]{new ContentDescriptor("audio.basic")}, new Format[0], 1));
            result.add(new PlugInInfo("com.sun.media.parser.audio.AiffParser", new Format[]{new ContentDescriptor("audio.x_aiff")}, new Format[0], 1));
            result.add(new PlugInInfo("com.sun.media.parser.audio.GsmParser", new Format[]{new ContentDescriptor("audio.x_gsm")}, new Format[0], 1));
        }
        if ((flags & 2) != 0) {
            result.add(new PlugInInfo("net.sf.fmj.media.parser.RawPushBufferParser", new Format[]{new ContentDescriptor("raw")}, new Format[0], 1));
        }
        if ((flags & 1) != 0) {
            result.add(new PlugInInfo("com.sun.media.parser.RawStreamParser", new Format[]{new ContentDescriptor("raw")}, new Format[0], 1));
            result.add(new PlugInInfo("com.sun.media.parser.RawBufferParser", new Format[]{new ContentDescriptor("raw")}, new Format[0], 1));
            result.add(new PlugInInfo("com.sun.media.parser.RawPullStreamParser", new Format[]{new ContentDescriptor("raw")}, new Format[0], 1));
            result.add(new PlugInInfo("com.sun.media.parser.RawPullBufferParser", new Format[]{new ContentDescriptor("raw")}, new Format[0], 1));
            result.add(new PlugInInfo("com.sun.media.parser.video.QuicktimeParser", new Format[]{new ContentDescriptor("video.quicktime")}, new Format[0], 1));
            result.add(new PlugInInfo("com.sun.media.parser.video.AviParser", new Format[]{new ContentDescriptor("video.x_msvideo")}, new Format[0], 1));
            result.add(new PlugInInfo("com.sun.media.codec.audio.mpa.JavaDecoder", new Format[]{new AudioFormat("mpegaudio", 16000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 22050.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 24000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 32000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 44100.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 48000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            result.add(new PlugInInfo("com.sun.media.codec.video.cinepak.JavaDecoder", new Format[]{new VideoFormat("cvid", null, -1, Format.byteArray, -1.0f)}, new Format[]{new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 255, 65280, 0xFF0000, 1, -1, 0, -1)}, 2));
            result.add(new PlugInInfo("com.ibm.media.codec.video.h263.JavaDecoder", new Format[]{new VideoFormat("h263", null, -1, Format.byteArray, -1.0f), new VideoFormat("h263/rtp", null, -1, Format.byteArray, -1.0f)}, new Format[]{new RGBFormat(null, -1, null, -1.0f, -1, -1, -1, -1, -1, -1, -1, -1)}, 2));
            result.add(new PlugInInfo("com.sun.media.codec.video.colorspace.JavaRGBConverter", new Format[]{new RGBFormat(null, -1, null, -1.0f, -1, -1, -1, -1, -1, -1, -1, -1)}, new Format[]{new RGBFormat(null, -1, null, -1.0f, -1, -1, -1, -1, -1, -1, -1, -1)}, 2));
            result.add(new PlugInInfo("com.sun.media.codec.video.colorspace.JavaRGBToYUV", new Format[]{new RGBFormat(null, -1, Format.byteArray, -1.0f, 24, -1, -1, -1, -1, -1, -1, -1), new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 0xFF0000, 65280, 255, 1, -1, -1, -1), new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 255, 65280, 0xFF0000, 1, -1, -1, -1)}, new Format[]{new YUVFormat(null, -1, Format.byteArray, -1.0f, 2, -1, -1, -1, -1, -1)}, 2));
            result.add(new PlugInInfo("com.ibm.media.codec.audio.PCMToPCM", new Format[]{new AudioFormat("LINEAR", -1.0, 16, 1, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("LINEAR", -1.0, 16, 2, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("LINEAR", -1.0, 8, 1, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("LINEAR", -1.0, 8, 2, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            result.add(new PlugInInfo("com.ibm.media.codec.audio.rc.RCModule", new Format[]{new AudioFormat("LINEAR", -1.0, 16, 2, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("LINEAR", -1.0, 16, 1, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("LINEAR", -1.0, 8, 2, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("LINEAR", -1.0, 8, 1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", 8000.0, 16, 2, 0, 1, -1, -1.0, Format.byteArray), new AudioFormat("LINEAR", 8000.0, 16, 1, 0, 1, -1, -1.0, Format.byteArray)}, 2));
            result.add(new PlugInInfo("com.sun.media.codec.audio.rc.RateCvrt", new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            result.add(new PlugInInfo("com.sun.media.codec.audio.msadpcm.JavaDecoder", new Format[]{new AudioFormat("msadpcm", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            result.add(new PlugInInfo("com.ibm.media.codec.audio.ulaw.JavaDecoder", new Format[]{new AudioFormat("ULAW", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            result.add(new PlugInInfo("com.ibm.media.codec.audio.alaw.JavaDecoder", new Format[]{new AudioFormat("alaw", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            result.add(new PlugInInfo("com.ibm.media.codec.audio.dvi.JavaDecoder", new Format[]{new AudioFormat("dvi/rtp", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            result.add(new PlugInInfo("com.ibm.media.codec.audio.g723.JavaDecoder", new Format[]{new AudioFormat("g723", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("g723/rtp", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            result.add(new PlugInInfo("com.ibm.media.codec.audio.gsm.JavaDecoder", new Format[]{new AudioFormat("gsm", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("gsm/rtp", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            result.add(new PlugInInfo("com.ibm.media.codec.audio.gsm.JavaDecoder_ms", new Format[]{new AudioFormat("gsm/ms", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            result.add(new PlugInInfo("com.ibm.media.codec.audio.ima4.JavaDecoder", new Format[]{new AudioFormat("ima4", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            result.add(new PlugInInfo("com.ibm.media.codec.audio.ima4.JavaDecoder_ms", new Format[]{new AudioFormat("ima4/ms", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            result.add(new PlugInInfo("com.ibm.media.codec.audio.ulaw.JavaEncoder", new Format[]{new AudioFormat("LINEAR", -1.0, 16, 1, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("LINEAR", -1.0, 16, 2, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("LINEAR", -1.0, 8, 1, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("LINEAR", -1.0, 8, 2, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("ULAW", 8000.0, 8, 1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            result.add(new PlugInInfo("com.ibm.media.codec.audio.dvi.JavaEncoder", new Format[]{new AudioFormat("LINEAR", -1.0, 16, 1, 0, 1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("dvi/rtp", -1.0, 4, 1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            result.add(new PlugInInfo("com.ibm.media.codec.audio.gsm.JavaEncoder", new Format[]{new AudioFormat("LINEAR", -1.0, 16, 1, 0, 1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("gsm", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            result.add(new PlugInInfo("com.ibm.media.codec.audio.gsm.JavaEncoder_ms", new Format[]{new AudioFormat("LINEAR", -1.0, 16, 1, 0, 1, -1, -1.0, Format.byteArray)}, new Format[]{new WavAudioFormat("gsm/ms", -1.0, -1, -1, -1, -1, -1, -1, -1.0f, Format.byteArray, null)}, 2));
            result.add(new PlugInInfo("com.ibm.media.codec.audio.ima4.JavaEncoder", new Format[]{new AudioFormat("LINEAR", -1.0, 16, -1, 0, 1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("ima4", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            result.add(new PlugInInfo("com.ibm.media.codec.audio.ima4.JavaEncoder_ms", new Format[]{new AudioFormat("LINEAR", -1.0, 16, -1, 0, 1, -1, -1.0, Format.byteArray)}, new Format[]{new WavAudioFormat("ima4/ms", -1.0, -1, -1, -1, -1, -1, -1, -1.0f, Format.byteArray, null)}, 2));
            result.add(new PlugInInfo("com.sun.media.codec.audio.ulaw.Packetizer", new Format[]{new AudioFormat("ULAW", -1.0, 8, 1, -1, -1, 8, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("ULAW/rtp", -1.0, 8, 1, -1, -1, 8, -1.0, Format.byteArray)}, 2));
            result.add(new PlugInInfo("com.sun.media.codec.audio.ulaw.DePacketizer", new Format[]{new AudioFormat("ULAW/rtp", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("ULAW", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            result.add(new PlugInInfo("com.sun.media.codec.audio.mpa.Packetizer", new Format[]{new AudioFormat("mpeglayer3", 16000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 22050.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 24000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 32000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 44100.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 48000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 16000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 22050.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 24000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 32000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 44100.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 48000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("mpegaudio/rtp", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            result.add(new PlugInInfo("com.sun.media.codec.audio.mpa.DePacketizer", new Format[]{new AudioFormat("mpegaudio/rtp", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("mpegaudio", 44100.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 48000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 32000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 22050.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 24000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 16000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 11025.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 12000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 8000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 44100.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 48000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 32000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 22050.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 24000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 16000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 11025.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 12000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 8000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray)}, 2));
            result.add(new PlugInInfo("com.ibm.media.codec.audio.gsm.Packetizer", new Format[]{new AudioFormat("gsm", 8000.0, -1, 1, -1, -1, 264, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("gsm/rtp", 8000.0, -1, 1, -1, -1, 264, -1.0, Format.byteArray)}, 2));
            result.add(new PlugInInfo("com.ibm.media.codec.audio.g723.Packetizer", new Format[]{new AudioFormat("g723", 8000.0, -1, 1, -1, -1, 192, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("g723/rtp", 8000.0, -1, 1, -1, -1, 192, -1.0, Format.byteArray)}, 2));
        }
        if ((flags & 1) != 0) {
            result.add(new PlugInInfo("com.sun.media.codec.video.jpeg.Packetizer", new Format[]{new JPEGFormat()}, new Format[]{new VideoFormat("jpeg/rtp", null, -1, Format.byteArray, -1.0f)}, 2));
        }
        if ((flags & 2) != 0) {
            result.add(new PlugInInfo("net.sf.fmj.media.codec.video.jpeg.DePacketizer", new Format[]{new VideoFormat("jpeg/rtp", null, -1, Format.byteArray, -1.0f)}, new Format[]{new JPEGFormat()}, 2));
        }
        if ((flags & 1) != 0) {
            result.add(new PlugInInfo("com.sun.media.codec.video.jpeg.DePacketizer", new Format[]{new VideoFormat("jpeg/rtp", null, -1, Format.byteArray, -1.0f)}, new Format[]{new JPEGFormat()}, 2));
            result.add(new PlugInInfo("com.sun.media.codec.video.mpeg.Packetizer", new Format[]{new VideoFormat("mpeg", null, -1, Format.byteArray, -1.0f)}, new Format[]{new VideoFormat("mpeg/rtp", null, -1, Format.byteArray, -1.0f)}, 2));
            result.add(new PlugInInfo("com.sun.media.codec.video.mpeg.DePacketizer", new Format[]{new VideoFormat("mpeg/rtp", null, -1, Format.byteArray, -1.0f)}, new Format[]{new VideoFormat("mpeg", null, -1, Format.byteArray, -1.0f)}, 2));
        }
        if ((flags & 1) != 0) {
            result.add(new PlugInInfo("com.sun.media.renderer.audio.JavaSoundRenderer", new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("ULAW", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[0], 4));
            result.add(new PlugInInfo("com.sun.media.renderer.audio.SunAudioRenderer", new Format[]{new AudioFormat("ULAW", 8000.0, 8, 1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[0], 4));
            result.add(new PlugInInfo("com.sun.media.renderer.video.AWTRenderer", new Format[]{new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 0xFF0000, 65280, 255, 1, -1, 0, -1), new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 255, 65280, 0xFF0000, 1, -1, 0, -1)}, new Format[0], 4));
            result.add(new PlugInInfo("com.sun.media.renderer.video.LightWeightRenderer", new Format[]{new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 0xFF0000, 65280, 255, 1, -1, 0, -1), new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 255, 65280, 0xFF0000, 1, -1, 0, -1)}, new Format[0], 4));
            result.add(new PlugInInfo("com.sun.media.renderer.video.JPEGRenderer", new Format[]{new JPEGFormat()}, new Format[0], 4));
            result.add(new PlugInInfo("com.sun.media.multiplexer.RawBufferMux", new Format[0], new Format[]{new ContentDescriptor("raw")}, 5));
            result.add(new PlugInInfo("com.sun.media.multiplexer.RawSyncBufferMux", new Format[0], new Format[]{new ContentDescriptor("raw")}, 5));
            result.add(new PlugInInfo("com.sun.media.multiplexer.RTPSyncBufferMux", new Format[0], new Format[]{new ContentDescriptor("raw.rtp")}, 5));
            result.add(new PlugInInfo("com.sun.media.multiplexer.audio.GSMMux", new Format[0], new Format[]{new FileTypeDescriptor("audio.x_gsm")}, 5));
            result.add(new PlugInInfo("com.sun.media.multiplexer.audio.MPEGMux", new Format[0], new Format[]{new FileTypeDescriptor("audio.mpeg")}, 5));
            result.add(new PlugInInfo("com.sun.media.multiplexer.audio.WAVMux", new Format[0], new Format[]{new FileTypeDescriptor("audio.x_wav")}, 5));
            result.add(new PlugInInfo("com.sun.media.multiplexer.audio.AIFFMux", new Format[0], new Format[]{new FileTypeDescriptor("audio.x_aiff")}, 5));
            result.add(new PlugInInfo("com.sun.media.multiplexer.audio.AUMux", new Format[0], new Format[]{new FileTypeDescriptor("audio.basic")}, 5));
            result.add(new PlugInInfo("com.sun.media.multiplexer.video.AVIMux", new Format[0], new Format[]{new FileTypeDescriptor("video.x_msvideo")}, 5));
            result.add(new PlugInInfo("com.sun.media.multiplexer.video.QuicktimeMux", new Format[0], new Format[]{new FileTypeDescriptor("video.quicktime")}, 5));
        }
        if ((flags & 2) != 0) {
            result.add("net.sf.fmj.media.codec.video.jpeg.Packetizer");
            result.add("net.sf.fmj.media.renderer.video.SimpleSwingRenderer");
            result.add("net.sf.fmj.media.renderer.video.SimpleAWTRenderer");
            result.add("net.sf.fmj.media.renderer.video.Java2dRenderer");
            result.add("net.sf.fmj.media.renderer.video.JPEGRTPRenderer");
            result.add("net.sf.fmj.media.renderer.video.JPEGRenderer");
            result.add("net.sf.fmj.media.parser.JavaSoundParser");
            result.add("net.sf.fmj.media.codec.JavaSoundCodec");
            result.add("net.sf.fmj.media.renderer.audio.JavaSoundRenderer");
            result.add("net.sf.fmj.media.codec.audio.gsm.Decoder");
            result.add("net.sf.fmj.media.codec.audio.gsm.Encoder");
            result.add("net.sf.fmj.media.codec.audio.gsm.DePacketizer");
            result.add("net.sf.fmj.media.codec.audio.gsm.Packetizer");
            result.add("net.sf.fmj.media.multiplexer.audio.GsmMux");
            result.add("net.sf.fmj.media.parser.GsmParser");
            result.add("net.sf.fmj.media.codec.audio.ulaw.Decoder");
            result.add("net.sf.fmj.media.codec.audio.ulaw.Encoder");
            result.add("net.sf.fmj.media.codec.audio.ulaw.DePacketizer");
            result.add("net.sf.fmj.media.codec.audio.ulaw.Packetizer");
            result.add("net.sf.fmj.media.codec.audio.RateConverter");
            result.add("net.sf.fmj.media.codec.audio.alaw.Decoder");
            result.add("net.sf.fmj.media.codec.audio.alaw.Encoder");
            result.add("net.sf.fmj.media.codec.audio.alaw.DePacketizer");
            result.add("net.sf.fmj.media.codec.audio.alaw.Packetizer");
            result.add("net.sf.fmj.media.codec.video.jpeg.JpegEncoder");
            result.add("net.sf.fmj.media.codec.video.lossless.GIFEncoder");
            result.add("net.sf.fmj.media.codec.video.lossless.GIFDecoder");
            result.add("net.sf.fmj.media.codec.video.lossless.PNGEncoder");
            result.add("net.sf.fmj.media.codec.video.lossless.PNGDecoder");
            result.add("net.sf.fmj.media.parser.RawPushBufferParser");
            result.add("net.sf.fmj.media.multiplexer.RTPSyncBufferMux");
            result.add("net.sf.fmj.media.multiplexer.RawBufferMux");
            result.add("net.sf.fmj.media.multiplexer.audio.AIFFMux");
            result.add("net.sf.fmj.media.multiplexer.audio.AUMux");
            result.add("net.sf.fmj.media.multiplexer.audio.WAVMux");
            if (!DISABLE_OGG) {
                result.add("net.sf.fmj.theora_java.JavaOggParser");
            }
            result.add("net.sf.fmj.media.parser.MultipartMixedReplaceParser");
            result.add("net.sf.fmj.media.multiplexer.MultipartMixedReplaceMux");
            result.add("net.sf.fmj.media.parser.XmlMovieParser");
            result.add("net.sf.fmj.media.multiplexer.XmlMovieMux");
            result.add("net.sf.fmj.media.multiplexer.audio.CsvAudioMux");
            result.add("net.java.sip.communicator.impl.media.codec.audio.speex.JavaEncoder");
            result.add("net.java.sip.communicator.impl.media.codec.audio.speex.JavaDecoder");
            result.add("net.java.sip.communicator.impl.media.codec.audio.ilbc.JavaEncoder");
            result.add("net.java.sip.communicator.impl.media.codec.audio.ilbc.JavaDecoder");
            result.add("com.t4l.jmf.JPEGDecoder");
        }
        if ((flags & 8) != 0) {
            result.add("net.sf.fmj.ffmpeg_java.FFMPEGParser");
            result.add("net.sf.fmj.theora_java.NativeOggParser");
        }
        if ((flags & 4) != 0) {
            result.add("com.omnividea.media.parser.video.Parser");
            result.add("com.omnividea.media.codec.video.NativeDecoder");
            result.add("com.omnividea.media.codec.audio.NativeDecoder");
            result.add("com.omnividea.media.codec.video.JavaDecoder");
        }
        if ((flags & 2) != 0 && (flags & 1) != 0) {
            result.add(new PlugInInfo("com.ibm.media.parser.video.MpegParser", new Format[]{new ContentDescriptor("video.mpeg")}, new Format[0], 1));
        }
        return result;
    }

    private static List<String> removePluginsFromList(int flags, List v) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object o : v) {
            String className = (String)o;
            boolean remove = false;
            if ((flags & 1) != 0 && (className.startsWith("com.ibm.") || className.startsWith("com.sun.") || className.startsWith("javax.media."))) {
                remove = true;
            }
            if ((flags & 2) != 0 && (className.startsWith("net.sf.fmj") || className.startsWith("net.java.sip.communicator.impl.media.") || className.startsWith("com.t4l.jmf")) && !className.equals("net.sf.fmj.ffmpeg_java.FFMPEGParser") && !className.equals("net.sf.fmj.theora_java.NativeOggParser")) {
                remove = true;
            }
            if ((flags & 8) != 0 && (className.equals("net.sf.fmj.ffmpeg_java.FFMPEGParser") || className.equals("net.sf.fmj.theora_java.NativeOggParser"))) {
                remove = true;
            }
            if ((flags & 4) != 0 && className.startsWith("com.omnividea.media.")) {
                remove = true;
            }
            if (!remove) continue;
            result.add(className);
        }
        return result;
    }

    public static void unRegisterPlugins(int flags) {
        List<String> vRemove;
        List<String> v;
        if (flags == 0) {
            return;
        }
        int[] types = new int[]{1, 2, 3, 4, 5};
        Registry registry = Registry.getInstance();
        for (int type : types) {
            v = registry.getPluginList(type);
            vRemove = RegistryDefaults.removePluginsFromList(flags, v);
            v.removeAll(vRemove);
            registry.setPluginList(type, v);
        }
        for (int type : types) {
            v = PlugInManager.getPlugInList(null, null, type);
            vRemove = RegistryDefaults.removePluginsFromList(flags, v);
            for (String className : vRemove) {
                PlugInManager.removePlugIn(className, type);
            }
        }
    }
}

