/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.audio.ulaw;

public class MuLawDecoderUtil {
    private static short[] muLawToPcmMap = new short[256];

    private static short decode(byte mulaw) {
        mulaw = ~mulaw;
        int sign = mulaw & 0x80;
        int exponent = (mulaw & 0x70) >> 4;
        int data = mulaw & 0xF;
        data |= 0x10;
        data <<= 1;
        ++data;
        data <<= exponent + 2;
        return (short)(sign == 0 ? data : -(data -= 132));
    }

    public static short muLawDecode(byte mulaw) {
        return muLawToPcmMap[mulaw & 0xFF];
    }

    public static void muLawDecodeLittleEndian(byte[] data, int offset, int len, byte[] decoded) {
        int size = len;
        for (int i = 0; i < size; ++i) {
            decoded[2 * i] = (byte)(muLawToPcmMap[data[offset + i] & 0xFF] & 0xFF);
            decoded[2 * i + 1] = (byte)(muLawToPcmMap[data[offset + i] & 0xFF] >> 8 & 0xFF);
        }
    }

    public static void muLawDecodeBigEndian(byte[] data, int offset, int len, byte[] decoded) {
        int size = len;
        for (int i = 0; i < size; ++i) {
            decoded[2 * i + 1] = (byte)(muLawToPcmMap[data[offset + i] & 0xFF] & 0xFF);
            decoded[2 * i] = (byte)(muLawToPcmMap[data[offset + i] & 0xFF] >> 8 & 0xFF);
        }
    }

    public static void muLawDecode(boolean bigEndian, byte[] data, int offset, int len, byte[] decoded) {
        if (bigEndian) {
            MuLawDecoderUtil.muLawDecodeBigEndian(data, offset, len, decoded);
        } else {
            MuLawDecoderUtil.muLawDecodeLittleEndian(data, offset, len, decoded);
        }
    }

    static {
        for (int i = 0; i < muLawToPcmMap.length; i = (int)((short)(i + 1))) {
            MuLawDecoderUtil.muLawToPcmMap[i] = MuLawDecoderUtil.decode((byte)i);
        }
    }
}

