/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.video.jpeg;

import com.lti.utils.StringUtils;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.JPEGFormat;
import javax.media.format.VideoFormat;
import net.sf.fmj.media.AbstractCodec;
import net.sf.fmj.media.codec.video.jpeg.JpegRTPHeader;
import net.sf.fmj.media.codec.video.jpeg.RFC2035;
import net.sf.fmj.utility.ArrayUtility;
import net.sf.fmj.utility.LoggingStringUtils;

public class DePacketizer
extends AbstractCodec
implements Codec {
    private static final boolean COMPARE_WITH_BASELINE = false;
    private static final boolean TRACE = false;
    private static final boolean EXIT_AFTER_ONE_FRAME = false;
    private static final int MAX_ACTIVE_FRAME_ASSEMBLERS = 3;
    private final Format[] supportedInputFormats = new Format[]{new VideoFormat("jpeg/rtp", null, -1, Format.byteArray, -1.0f)};
    private final Format[] supportedOutputFormats = new Format[]{new JPEGFormat()};
    private Codec baselineCodec;
    private long lastRTPtimestamp = -1L;
    private long lastTimestamp;
    private final FrameAssemblerCollection frameAssemblers = new FrameAssemblerCollection();
    private static final BufferFragmentOffsetComparator bufferFragmentOffsetComparator = new BufferFragmentOffsetComparator();
    private static final int MAX_DUMP_SIZE = 200000;

    public void close() {
        if (this.baselineCodec != null) {
            this.baselineCodec.close();
        }
        super.close();
        this.frameAssemblers.clear();
    }

    public Object getControl(String controlType) {
        if (this.baselineCodec != null) {
            return this.baselineCodec.getControl(controlType);
        }
        return super.getControl(controlType);
    }

    public Object[] getControls() {
        if (this.baselineCodec != null) {
            return this.baselineCodec.getControls();
        }
        return super.getControls();
    }

    public String getName() {
        return "JPEG DePacketizer";
    }

    public Format[] getSupportedInputFormats() {
        return this.supportedInputFormats;
    }

    public Format[] getSupportedOutputFormats(Format input) {
        if (input == null) {
            return this.supportedOutputFormats;
        }
        VideoFormat inputCast = (VideoFormat)input;
        Dimension HARD_CODED_SIZE = new Dimension(320, 240);
        Format[] result = new Format[]{new JPEGFormat(inputCast.getSize() != null ? inputCast.getSize() : HARD_CODED_SIZE, -1, Format.byteArray, -1.0f, -1, -1)};
        if (this.baselineCodec != null) {
            Format[] baselineResult = this.baselineCodec.getSupportedOutputFormats(input);
            System.out.println("input:  " + LoggingStringUtils.formatToStr(input));
            for (int i = 0; i < baselineResult.length; ++i) {
                System.out.println("output: " + LoggingStringUtils.formatToStr(baselineResult[0]));
            }
        }
        return result;
    }

    public void open() throws ResourceUnavailableException {
        if (this.baselineCodec != null) {
            this.baselineCodec.open();
        }
        super.open();
    }

    public void reset() {
        if (this.baselineCodec != null) {
            this.baselineCodec.reset();
        }
        super.reset();
        this.frameAssemblers.clear();
    }

    public Format setInputFormat(Format format) {
        if (this.baselineCodec != null) {
            super.setInputFormat(format);
            return this.baselineCodec.setInputFormat(format);
        }
        return super.setInputFormat(format);
    }

    public Format setOutputFormat(Format format) {
        if (this.baselineCodec != null) {
            super.setOutputFormat(format);
            return this.baselineCodec.setOutputFormat(format);
        }
        return super.setOutputFormat(format);
    }

    public int process(Buffer input, Buffer output) {
        if (!input.isDiscard()) {
            if (this.baselineCodec != null) {
                int baselineResult = this.baselineCodec.process(input, output);
            }
            JpegRTPHeader jpegRtpHeader = input.getLength() >= 8 ? JpegRTPHeader.parse((byte[])input.getData(), input.getOffset()) : null;
            long timestamp = input.getTimeStamp();
            boolean rtpMarker = (input.getFlags() & 0x800) != 0;
            FrameAssembler assembler = this.frameAssemblers.findOrAdd(timestamp);
            assembler.put((Buffer)input.clone());
            if (assembler.complete()) {
                Buffer bComplete = this.baselineCodec == null ? output : new Buffer();
                int offsetAfterHeaders = assembler.copyToBuffer(bComplete);
                this.frameAssemblers.remove(timestamp);
                this.frameAssemblers.removeOlderThan(timestamp);
                if (this.lastRTPtimestamp == -1L) {
                    this.lastRTPtimestamp = input.getTimeStamp();
                    this.lastTimestamp = System.nanoTime();
                }
                return 0;
            }
            this.frameAssemblers.removeAllButNewestN(3);
            output.setDiscard(true);
            return 4;
        }
        output.setDiscard(true);
        return 4;
    }

    private static void zeroData(byte[] data) {
        int len = data.length;
        for (int i = 0; i < len; ++i) {
            data[i] = 0;
        }
    }

    private static boolean hasJPEGHeaders(byte[] data, int offset, int len) {
        if (len < 2) {
            throw new IllegalArgumentException();
        }
        if (data[offset++] != -1) {
            return false;
        }
        return data[offset++] == -40;
    }

    private static boolean hasJPEGTrailer(byte[] data, int offset, int len) {
        if (len < 2) {
            throw new IllegalArgumentException();
        }
        if (data[offset++] != -1) {
            return false;
        }
        return data[offset++] == -39;
    }

    private static int buildJFIFHeader(byte[] data, int offset) {
        data[offset++] = -1;
        data[offset++] = -32;
        data[offset++] = 0;
        data[offset++] = 16;
        data[offset++] = 74;
        data[offset++] = 70;
        data[offset++] = 73;
        data[offset++] = 70;
        data[offset++] = 0;
        data[offset++] = 1;
        data[offset++] = 1;
        data[offset++] = 0;
        data[offset++] = 0;
        data[offset++] = 1;
        data[offset++] = 0;
        data[offset++] = 1;
        data[offset++] = 0;
        data[offset++] = 0;
        return offset;
    }

    private static String dump(byte[] data, int offset, int len) {
        return StringUtils.dump(data, offset, offset + len);
    }

    private static void dump(Buffer b, String name) {
    }

    private static class FrameAssemblerCollection {
        private Map frameAssemblers = new HashMap();

        private FrameAssemblerCollection() {
        }

        public FrameAssembler findOrAdd(long timestamp) {
            FrameAssembler result = (FrameAssembler)this.frameAssemblers.get(new Long(timestamp));
            if (result == null) {
                result = new FrameAssembler();
                this.frameAssemblers.put(new Long(timestamp), result);
            }
            return result;
        }

        public void remove(long timestamp) {
            this.frameAssemblers.remove(new Long(timestamp));
        }

        public void removeOlderThan(long timestamp) {
            Iterator i = this.frameAssemblers.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                Long entryTimestamp = (Long)e.getKey();
                if (entryTimestamp >= timestamp) continue;
                i.remove();
            }
        }

        public void removeAllButNewestN(int n) {
            while (this.frameAssemblers.size() > n) {
                long oldestTimestamp = this.getOldestTimestamp();
                if (oldestTimestamp < 0L) {
                    throw new RuntimeException();
                }
                Long key = new Long(oldestTimestamp);
                FrameAssembler a = (FrameAssembler)this.frameAssemblers.get(key);
                String completeIncomplete = a.complete() ? "complete" : "incomplete";
                this.frameAssemblers.remove(key);
            }
        }

        public long getOldestTimestamp() {
            long oldestSoFar = -1L;
            for (Long ts : this.frameAssemblers.keySet()) {
                if (oldestSoFar >= 0L && ts >= oldestSoFar) continue;
                oldestSoFar = ts;
            }
            return oldestSoFar;
        }

        public void clear() {
            this.frameAssemblers.clear();
        }
    }

    private static class BufferFragmentOffsetComparator
    implements Comparator {
        private BufferFragmentOffsetComparator() {
        }

        public int compare(Object a, Object b) {
            if (a == null && b == null) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            Buffer aCast = (Buffer)a;
            Buffer bCast = (Buffer)b;
            JpegRTPHeader jpegRtpHeaderA = JpegRTPHeader.parse((byte[])aCast.getData(), aCast.getOffset());
            JpegRTPHeader jpegRtpHeaderB = JpegRTPHeader.parse((byte[])bCast.getData(), bCast.getOffset());
            return jpegRtpHeaderA.getFragmentOffset() - jpegRtpHeaderB.getFragmentOffset();
        }
    }

    static class FrameAssembler {
        private final List list = new ArrayList();
        private boolean rtpMarker;

        FrameAssembler() {
        }

        public void put(Buffer buffer) {
            if (!this.rtpMarker) {
                boolean bl = this.rtpMarker = (buffer.getFlags() & 0x800) != 0;
            }
            if (buffer.getLength() <= 8) {
                return;
            }
            this.list.add(buffer);
            Collections.sort(this.list, bufferFragmentOffsetComparator);
        }

        public boolean complete() {
            if (!this.rtpMarker) {
                return false;
            }
            if (this.list.size() <= 0) {
                return false;
            }
            return this.contiguous();
        }

        private JpegRTPHeader parseJpegRTPHeader(Buffer b) {
            return JpegRTPHeader.parse((byte[])b.getData(), b.getOffset());
        }

        private boolean contiguous() {
            int expect = 0;
            for (int i = 0; i < this.list.size(); ++i) {
                Buffer b = (Buffer)this.list.get(i);
                JpegRTPHeader jpegRtpHeader = this.parseJpegRTPHeader(b);
                int otherOffset = 0;
                if (jpegRtpHeader.getType() > 63) {
                    otherOffset += 4;
                }
                if (jpegRtpHeader.getQ() >= 128) {
                    int length = 0;
                    int j = b.getOffset() + 8 + otherOffset + 2;
                    byte[] data = (byte[])b.getData();
                    length = data[j++] & 0xFF;
                    length <<= 8;
                    length |= data[j] & 0xFF;
                    otherOffset += (length += 4);
                }
                if (jpegRtpHeader.getFragmentOffset() != expect) {
                    return false;
                }
                expect += b.getLength() - 8 - otherOffset;
            }
            return true;
        }

        public int frameLength() {
            if (!this.rtpMarker) {
                throw new IllegalStateException();
            }
            if (this.list.size() <= 0) {
                throw new IllegalStateException();
            }
            Buffer b = (Buffer)this.list.get(this.list.size() - 1);
            JpegRTPHeader jpegRtpHeader = this.parseJpegRTPHeader(b);
            return jpegRtpHeader.getFragmentOffset() + b.getLength() - 8;
        }

        public int copyToBuffer(Buffer bDest) {
            byte[] data;
            if (!this.rtpMarker) {
                throw new IllegalStateException();
            }
            if (this.list.size() <= 0) {
                throw new IllegalStateException();
            }
            Buffer bFirst = (Buffer)this.list.get(0);
            boolean prependHeader = !DePacketizer.hasJPEGHeaders((byte[])bFirst.getData(), bFirst.getOffset() + 8, bFirst.getLength() - 8);
            int MAX_HEADER = prependHeader ? 1024 : 0;
            int MAX_TRAILER = 2;
            int frameLength = this.frameLength();
            int inputOffset = bFirst.getOffset();
            int dri = 0;
            byte[] lqt = null;
            byte[] cqt = null;
            byte[] inputData = (byte[])bFirst.getData();
            if (bDest.getData() != null && ((byte[])bDest.getData()).length >= frameLength + MAX_HEADER + 2) {
                data = (byte[])bDest.getData();
                DePacketizer.zeroData(data);
            } else {
                data = new byte[frameLength + MAX_HEADER + 2];
            }
            int offsetAfterHeaders = 0;
            if (prependHeader) {
                data[offsetAfterHeaders++] = -1;
                data[offsetAfterHeaders++] = -40;
                offsetAfterHeaders = DePacketizer.buildJFIFHeader(data, offsetAfterHeaders);
                JpegRTPHeader jpegRtpHeaderFirst = this.parseJpegRTPHeader(bFirst);
                inputOffset += 8;
                if (jpegRtpHeaderFirst.getType() >= 64 && jpegRtpHeaderFirst.getType() <= 127) {
                    dri = inputData[inputOffset++] & 0xFF;
                    dri <<= 8;
                    dri |= inputData[inputOffset++] & 0xFF;
                    inputOffset += 2;
                }
                if (jpegRtpHeaderFirst.getQ() > 127) {
                    inputOffset += 2;
                    int length = inputData[inputOffset++] & 0xFF;
                    length <<= 8;
                    lqt = ArrayUtility.copyOfRange(inputData, inputOffset, inputOffset + (length |= inputData[inputOffset++] & 0xFF) / 2);
                    cqt = ArrayUtility.copyOfRange(inputData, inputOffset += length / 2, inputOffset + length / 2);
                    inputOffset += length / 2;
                }
                offsetAfterHeaders = RFC2035.MakeHeaders(false, data, offsetAfterHeaders, jpegRtpHeaderFirst.getType(), jpegRtpHeaderFirst.getQ(), jpegRtpHeaderFirst.getWidthInBlocks(), jpegRtpHeaderFirst.getHeightInBlocks(), lqt, cqt, dri);
            }
            for (int i = 0; i < this.list.size(); ++i) {
                Buffer b = (Buffer)this.list.get(i);
                JpegRTPHeader jpegRtpHeader = this.parseJpegRTPHeader(b);
                System.arraycopy(b.getData(), b.getOffset() + 8, data, offsetAfterHeaders + jpegRtpHeader.getFragmentOffset(), b.getLength() - 8);
            }
            boolean appendEOI = !DePacketizer.hasJPEGTrailer(data, offsetAfterHeaders + frameLength, 2);
            int trailing = 0;
            if (appendEOI) {
                data[offsetAfterHeaders + frameLength + trailing++] = -1;
                data[offsetAfterHeaders + frameLength + trailing++] = -39;
            }
            bDest.setData(data);
            bDest.setLength(offsetAfterHeaders + frameLength + trailing);
            bDest.setOffset(0);
            bDest.setTimeStamp(bFirst.getTimeStamp());
            return offsetAfterHeaders;
        }
    }
}

