/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.multiplexer;

import java.awt.Component;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.Owned;
import javax.media.ResourceUnavailableException;
import javax.media.Time;
import javax.media.control.BitRateControl;
import javax.media.control.FrameRateControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import net.sf.fmj.media.AbstractMultiplexer;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.RingBuffer;

public class RawBufferMux
extends AbstractMultiplexer {
    private final boolean TRACE = false;
    private static final Logger logger = LoggerSingleton.logger;
    private RawBufferDataSource dataOutput;
    private RawBufferSourceStream[] streams;
    private RingBuffer[] jitterBuffer;
    private final ContentDescriptor contentDescriptor;
    private long lastTimestamp = -1L;
    private int bytesProcessed;
    private int bitsPerSecond;
    private float frameRate = -1.0f;
    private int framesProcessed;

    protected RawBufferMux(ContentDescriptor contentDescriptor) {
        this.contentDescriptor = contentDescriptor;
    }

    public RawBufferMux() {
        this(new ContentDescriptor("raw"));
    }

    public DataSource getDataOutput() {
        if (this.dataOutput == null) {
            this.dataOutput = new RawBufferDataSource();
        }
        return this.dataOutput;
    }

    public Format[] getSupportedInputFormats() {
        return new Format[]{new AudioFormat(null, -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray), new VideoFormat(null, null, -1, Format.byteArray, -1.0f)};
    }

    public void close() {
        super.close();
        if (this.dataOutput != null) {
            try {
                this.dataOutput.stop();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
            }
            this.dataOutput.disconnect();
        }
    }

    public void open() throws ResourceUnavailableException {
        super.open();
    }

    public ContentDescriptor[] getSupportedOutputContentDescriptors(Format[] inputs) {
        return new ContentDescriptor[]{this.contentDescriptor};
    }

    public int process(Buffer buffer, int trackID) {
        if (buffer.isEOM()) {
            logger.fine("EOM, finished");
        }
        if (null != this.dataOutput) {
            this.jitterBuffer[trackID].put(buffer.clone());
            this.dataOutput.notifyDataAvailable(trackID);
        }
        return 0;
    }

    public int setNumTracks(int numTracks) {
        int track;
        numTracks = super.setNumTracks(numTracks);
        this.jitterBuffer = new RingBuffer[numTracks];
        for (track = 0; track < numTracks; ++track) {
            this.jitterBuffer[track] = new RingBuffer(1);
        }
        this.streams = new RawBufferSourceStream[numTracks];
        for (track = 0; track < numTracks; ++track) {
            this.streams[track] = new RawBufferSourceStream(this.jitterBuffer[track]);
        }
        return numTracks;
    }

    public Format setInputFormat(Format format, int trackID) {
        Format result = super.setInputFormat(format, trackID);
        if (result != null && this.streams != null) {
            this.streams[trackID].setFormat(result);
        }
        return result;
    }

    private class RawBufferSourceStream
    implements PushBufferStream {
        private final RingBuffer jitterBuffer;
        private boolean eos;
        private Format format;
        private BufferTransferHandler transferHandler;

        public RawBufferSourceStream(RingBuffer jitterBuffer) {
            this.jitterBuffer = jitterBuffer;
        }

        public boolean endOfStream() {
            return this.eos;
        }

        public ContentDescriptor getContentDescriptor() {
            return RawBufferMux.this.outputContentDescriptor;
        }

        public long getContentLength() {
            return 0L;
        }

        public Object getControl(String controlType) {
            return null;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        void setFormat(Format f) {
            this.format = f;
        }

        public Format getFormat() {
            return this.format;
        }

        public void read(Buffer buffer) throws IOException {
            Buffer next = null;
            try {
                next = (Buffer)this.jitterBuffer.get();
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (next == null || next.isEOM()) {
                this.eos = true;
            }
            if (next != null) {
                if (buffer.getData() == null) {
                    buffer.copy(next, false);
                } else {
                    Object originalData = buffer.getData();
                    int originalOffset = buffer.getOffset();
                    int originalLength = this.arrayLength(buffer.getData());
                    buffer.copy(next, false);
                    buffer.setData(originalData);
                    buffer.setOffset(originalOffset);
                    long currentTimestamp = System.nanoTime();
                    if (-1L == RawBufferMux.this.lastTimestamp) {
                        RawBufferMux.this.lastTimestamp = currentTimestamp;
                    }
                    RawBufferMux.this.bytesProcessed += buffer.getLength();
                    if ((buffer.getFlags() & 0x800) > 0) {
                        RawBufferMux.this.framesProcessed++;
                    }
                    if (currentTimestamp - RawBufferMux.this.lastTimestamp > 1000000000L) {
                        RawBufferMux.this.bitsPerSecond = RawBufferMux.this.bytesProcessed << 3;
                        float diffTime = (float)(currentTimestamp - RawBufferMux.this.lastTimestamp) / 1000000.0f;
                        RawBufferMux.this.frameRate = (float)RawBufferMux.this.framesProcessed * (1000.0f / diffTime);
                        RawBufferMux.this.bytesProcessed = 0;
                        RawBufferMux.this.framesProcessed = 0;
                        RawBufferMux.this.lastTimestamp = currentTimestamp;
                    }
                    if (next.getLength() > 0) {
                        if (next.getLength() > originalLength) {
                            logger.warning("Buffer passed in has length: " + originalLength + "; needs to be at least: " + next.getLength() + "; not able to re-use passed in buffer data");
                            buffer.copy(next, false);
                        } else {
                            System.arraycopy(next.getData(), next.getOffset(), originalData, originalOffset, next.getLength());
                        }
                    }
                }
            } else {
                System.out.println("RawBufferMux EOS");
                System.out.flush();
                buffer.setEOM(true);
                buffer.setLength(0);
                buffer.setOffset(0);
            }
        }

        private int arrayLength(Object data) {
            if (data instanceof byte[]) {
                return ((byte[])data).length;
            }
            if (data instanceof short[]) {
                return ((short[])data).length;
            }
            if (data instanceof int[]) {
                return ((int[])data).length;
            }
            throw new IllegalArgumentException();
        }

        public void setTransferHandler(BufferTransferHandler transferHandler) {
            this.transferHandler = transferHandler;
        }

        public void notifyDataAvailable() {
            if (this.transferHandler != null) {
                this.transferHandler.transferData(this);
            }
        }
    }

    private class RawBufferDataSource
    extends PushBufferDataSource {
        private Object[] controls;

        private RawBufferDataSource() {
            this.controls = new Object[]{new RawBufferBitRateControl(), new VideoFrameRateControl()};
        }

        public PushBufferStream[] getStreams() {
            return RawBufferMux.this.streams;
        }

        public void connect() throws IOException {
        }

        public void disconnect() {
        }

        public String getContentType() {
            return RawBufferMux.this.outputContentDescriptor.getContentType();
        }

        public Object getControl(String controlType) {
            return null;
        }

        public Object[] getControls() {
            return this.controls;
        }

        public Time getDuration() {
            return DURATION_UNKNOWN;
        }

        public void start() throws IOException {
        }

        public void stop() throws IOException {
            RawBufferMux.this.lastTimestamp = -1L;
            RawBufferMux.this.bytesProcessed = 0;
            RawBufferMux.this.bitsPerSecond = 0;
            RawBufferMux.this.frameRate = -1.0f;
            RawBufferMux.this.framesProcessed = 0;
        }

        public void notifyDataAvailable(int track) {
            RawBufferMux.this.streams[track].notifyDataAvailable();
        }
    }

    private class RawBufferBitRateControl
    implements BitRateControl,
    Owned {
        private RawBufferBitRateControl() {
        }

        public Object getOwner() {
            return RawBufferMux.this;
        }

        public int getBitRate() {
            return RawBufferMux.this.bitsPerSecond;
        }

        public int setBitRate(int bitrate) {
            return -1;
        }

        public int getMinSupportedBitRate() {
            return -1;
        }

        public int getMaxSupportedBitRate() {
            return -1;
        }

        public Component getControlComponent() {
            return null;
        }
    }

    private class VideoFrameRateControl
    implements FrameRateControl,
    Owned {
        private VideoFrameRateControl() {
        }

        public Object getOwner() {
            return RawBufferMux.this;
        }

        public float getFrameRate() {
            return RawBufferMux.this.frameRate;
        }

        public float setFrameRate(float newFrameRate) {
            return -1.0f;
        }

        public float getMaxSupportedFrameRate() {
            return -1.0f;
        }

        public float getPreferredFrameRate() {
            return -1.0f;
        }

        public Component getControlComponent() {
            return null;
        }
    }
}

