/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import javax.media.Format;
import javax.media.Time;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.ReceptionStats;
import net.sf.fmj.media.rtp.RTPAudioDataStream;
import net.sf.fmj.media.rtp.RTPDataStream;
import net.sf.fmj.media.rtp.RTPHeader;
import net.sf.fmj.media.rtp.RTPVideoDataStream;

public class RTPDataSource
extends PushBufferDataSource {
    private PushBufferStream stream = null;
    private boolean connected = false;
    private boolean started = false;

    public RTPDataSource(long ssrc, Format format) {
        if (format instanceof VideoFormat) {
            this.stream = new RTPVideoDataStream(ssrc, format);
        } else if (format instanceof AudioFormat) {
            this.stream = new RTPAudioDataStream(ssrc, format);
        }
    }

    public PushBufferStream[] getStreams() {
        return new PushBufferStream[]{this.stream};
    }

    public String getContentType() {
        if (!this.connected) {
            return null;
        }
        return "raw";
    }

    public void connect() {
        this.connected = true;
    }

    public void disconnect() {
        if (this.started) {
            this.stop();
        }
        this.connected = false;
    }

    public void start() {
        this.started = true;
    }

    public void stop() {
        this.started = false;
    }

    public Object getControl(String arg0) {
        return this.stream.getControl(arg0);
    }

    public Object[] getControls() {
        return this.stream.getControls();
    }

    public Time getDuration() {
        return DURATION_UNBOUNDED;
    }

    public void handleRTPPacket(RTPHeader header, byte[] data, int offset, int length) {
        if (this.stream instanceof RTPDataStream) {
            ((RTPDataStream)this.stream).addPacket(header, data, offset, length);
        }
    }

    public long getJitter() {
        if (this.stream instanceof RTPDataStream) {
            return ((RTPDataStream)this.stream).getJitter();
        }
        return 0L;
    }

    public ReceptionStats getSourceReceptionStats() {
        if (this.stream instanceof RTPDataStream) {
            return ((RTPDataStream)this.stream).getReceptionStats();
        }
        return null;
    }
}

