/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.awt.Component;
import java.io.IOException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.control.BitRateControl;
import javax.media.control.BufferControl;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.GlobalReceptionStats;
import javax.media.rtp.RTPControl;
import javax.media.rtp.ReceptionStats;
import net.sf.fmj.media.rtp.RTPBuffer;
import net.sf.fmj.media.rtp.RTPHeader;
import net.sf.fmj.media.rtp.RTPReceptionStats;

public abstract class RTPDataStream
implements PushBufferStream,
RTPControl {
    protected Format format = null;
    protected double clockRate = 90000.0;
    protected int packetSize = -1;
    protected BufferTransferHandler handler = null;
    protected long ssrc = 0L;
    protected long threshold;
    protected Object[] controls = new Object[]{this, new RTPDataStreamBufferControl(), new RTPDataStreamRateControl()};
    protected RTPReceptionStats receptionStats = new RTPReceptionStats();
    protected long jitter = 0L;
    protected RTPBuffer itsRTPBuffer;
    protected int rtpbufferlen = 3;
    protected long rtpbufferlenMS = -1L;
    private long lastDelay = -1L;
    private long lastRTPReceiveTime = -1L;
    private long lastRTPTimestamp = -1L;
    protected long lastTimestamp = -1L;
    protected int bytesProcessed;
    protected int bitsPerSecond;

    public RTPDataStream(long ssrc, Format format) {
        this.ssrc = ssrc;
        this.format = format;
        this.itsRTPBuffer = new RTPBuffer(this.rtpbufferlen, this.receptionStats);
    }

    protected abstract void addPacket(RTPHeader var1, byte[] var2, int var3, int var4);

    public Format getFormat() {
        return this.format;
    }

    public void setTransferHandler(BufferTransferHandler transferHandler) {
        this.handler = transferHandler;
    }

    public ContentDescriptor getContentDescriptor() {
        return new ContentDescriptor("raw.rtp");
    }

    public long getContentLength() {
        return -1L;
    }

    public boolean endOfStream() {
        return false;
    }

    public Object[] getControls() {
        return this.controls;
    }

    public Object getControl(String controlType) {
        if (controlType.equals("javax.media.rtp.RTPControl")) {
            return this;
        }
        return null;
    }

    public abstract void read(Buffer var1) throws IOException;

    public void addFormat(Format fmt, int payload) {
    }

    public ReceptionStats getReceptionStats() {
        return this.receptionStats;
    }

    public GlobalReceptionStats getGlobalStats() {
        return null;
    }

    public Format[] getFormatList() {
        return new Format[0];
    }

    public Format getFormat(int payload) {
        return this.format;
    }

    public Component getControlComponent() {
        return null;
    }

    protected void calculateJitter(long rtpTimestamp) {
        long now = System.nanoTime() / 1000000L;
        if (this.lastRTPTimestamp != -1L && this.lastRTPReceiveTime != -1L) {
            double rtpDiffTimestamp = rtpTimestamp - this.lastRTPTimestamp;
            double rtpDiffReceiveTime = (double)(now - this.lastRTPReceiveTime) * this.clockRate / 1000.0;
            long delta = Math.abs(Math.round(rtpDiffReceiveTime - rtpDiffTimestamp));
            this.jitter += Math.round((double)(delta - this.jitter) / 16.0);
        }
        this.lastRTPTimestamp = rtpTimestamp;
        this.lastRTPReceiveTime = now;
    }

    public long getJitter() {
        return this.jitter;
    }

    public long getJitterBufferSize() {
        return this.itsRTPBuffer.getMaxItems();
    }

    public long getJitterBufferItemCount() {
        return this.itsRTPBuffer.getItemCount();
    }

    private class RTPDataStreamRateControl
    implements BitRateControl {
        private RTPDataStreamRateControl() {
        }

        public int getBitRate() {
            return RTPDataStream.this.bitsPerSecond;
        }

        public int setBitRate(int bitrate) {
            return -1;
        }

        public int getMinSupportedBitRate() {
            return -1;
        }

        public int getMaxSupportedBitRate() {
            return -1;
        }

        public Component getControlComponent() {
            return null;
        }
    }

    private class RTPDataStreamBufferControl
    implements BufferControl {
        private RTPDataStreamBufferControl() {
        }

        public long getBufferLength() {
            return RTPDataStream.this.rtpbufferlenMS;
        }

        public long setBufferLength(long time) {
            RTPDataStream.this.rtpbufferlenMS = time;
            if (RTPDataStream.this.format instanceof VideoFormat) {
                RTPDataStream.this.rtpbufferlen = (int)Math.round((double)time / 50.0);
            } else {
                int bytesToBuffer = (int)((double)RTPDataStream.this.rtpbufferlenMS * (RTPDataStream.this.clockRate / 1000.0));
                RTPDataStream.this.rtpbufferlen = bytesToBuffer / RTPDataStream.this.packetSize;
                if (RTPDataStream.this.rtpbufferlen < 1) {
                    RTPDataStream.this.rtpbufferlen = 1;
                }
            }
            RTPDataStream.this.itsRTPBuffer.resize(RTPDataStream.this.rtpbufferlen);
            return RTPDataStream.this.rtpbufferlenMS;
        }

        public long getMinimumThreshold() {
            return -1L;
        }

        public long setMinimumThreshold(long time) {
            return -1L;
        }

        public void setEnabledThreshold(boolean b) {
        }

        public boolean getEnabledThreshold() {
            return false;
        }

        public Component getControlComponent() {
            return null;
        }
    }
}

