/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceTransferHandler;
import javax.media.rtp.OutputDataStream;
import javax.media.rtp.Participant;
import javax.media.rtp.SendStream;
import javax.media.rtp.TransmissionStats;
import javax.media.rtp.rtcp.SenderReport;
import javax.media.rtp.rtcp.SourceDescription;
import net.sf.fmj.media.rtp.RTPHeader;
import net.sf.fmj.media.rtp.RTPLocalParticipant;
import net.sf.fmj.media.rtp.RTPSessionMgr;
import net.sf.fmj.media.rtp.RTPTransmissionStats;
import net.sf.fmj.media.rtp.SSRCGenerator;
import net.sf.fmj.utility.LoggerSingleton;

public class RTPSendStream
implements SendStream,
SourceTransferHandler,
BufferTransferHandler {
    private static final Logger logger = LoggerSingleton.logger;
    private long ssrc = 0L;
    private DataSource dataSource = null;
    private OutputDataStream rtpDataStream = null;
    private HashMap sourceDescriptions = new HashMap();
    private int sdesSize = 0;
    private int index = 0;
    private int format = 0;
    private double clockRate = 90000.0;
    private RTPSessionMgr rtpMgr;
    private boolean started = false;
    private RTPLocalParticipant participant = null;
    private byte[] buffer = new byte[0];
    private int lastSequence = SSRCGenerator.nextSecuredRandomShort();
    private long lastSendTime = -1L;
    private long initialSendTime = -1L;
    private long lastTimestamp;
    private long initialTimestamp;
    private long lastBufferTimestamp;
    private long initialBufferTimestamp;
    private byte header0 = (byte)-128;
    private RTPTransmissionStats stats = new RTPTransmissionStats();
    private static final int MAX_PUSHBUFFER_DATA_SIZE = 2048;
    private int lop = 0;

    public RTPSendStream(long ssrc, DataSource dataSource, OutputDataStream rtpDataStream, int index, RTPLocalParticipant participant, int format, double clockRate, RTPSessionMgr rtpMgr) {
        this.ssrc = ssrc;
        if (dataSource instanceof PushDataSource) {
            logger.warning("RTPSendStream initialized with PushDataSource");
        }
        this.dataSource = dataSource;
        this.rtpDataStream = rtpDataStream;
        this.index = index;
        this.participant = participant;
        this.format = format;
        this.clockRate = clockRate;
        this.rtpMgr = rtpMgr;
        this.lastTimestamp = this.initialTimestamp = (long)SSRCGenerator.nextSecuredRandomInt();
        this.addSourceDescription(new SourceDescription(1, participant.getCNAME(), 1, false));
        this.addSourceDescription(new SourceDescription(2, participant.getCNAME(), 1, false));
    }

    public void addSourceDescription(SourceDescription sdes) {
        SourceDescription oldSdes = (SourceDescription)this.sourceDescriptions.get(new Integer(sdes.getType()));
        if (oldSdes != null) {
            this.sdesSize -= oldSdes.getDescription().length();
            this.sdesSize -= 2;
        }
        this.sourceDescriptions.put(new Integer(sdes.getType()), sdes);
        this.sdesSize += 2;
        this.sdesSize += sdes.getDescription().length();
    }

    public void setSourceDescription(SourceDescription[] sourceDesc) {
        for (int i = 0; i < sourceDesc.length; ++i) {
            this.addSourceDescription(sourceDesc[i]);
        }
    }

    public void close() {
        logger.fine("RTPSendStream closing");
        if (this.started) {
            try {
                this.stop();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
            }
        }
    }

    public void stop() throws IOException {
        if (this.started) {
            this.dataSource.stop();
        }
        this.started = false;
    }

    public void start() throws IOException {
        if (!this.started) {
            if (this.dataSource instanceof PushBufferDataSource) {
                logger.fine("RTPSendStream started with PushBufferDataSource");
                PushBufferStream[] streams = ((PushBufferDataSource)this.dataSource).getStreams();
                streams[this.index].setTransferHandler(this);
            } else if (this.dataSource instanceof PushDataSource) {
                logger.warning("RTPSendStream started with PushDataSource");
                PushSourceStream[] streams = ((PushDataSource)this.dataSource).getStreams();
                streams[this.index].setTransferHandler(this);
            } else {
                throw new IOException("Unknown datasource: " + this.dataSource);
            }
            this.dataSource.start();
            this.started = true;
        }
    }

    public int setBitRate(int bitRate) {
        return -1;
    }

    public TransmissionStats getSourceTransmissionStats() {
        return this.stats;
    }

    public Participant getParticipant() {
        return this.participant;
    }

    public SenderReport getSenderReport() {
        return null;
    }

    public long getSSRC() {
        return this.ssrc;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    private void writeHeaderToBuffer(boolean marker, long timestamp) {
        this.buffer[0] = this.header0;
        this.buffer[1] = (byte)(this.format & 0xFF);
        if (marker) {
            this.buffer[1] = (byte)(this.buffer[1] | 0x80);
        }
        this.buffer[2] = (byte)(this.lastSequence >> 8 & 0xFF);
        this.buffer[3] = (byte)(this.lastSequence & 0xFF);
        this.buffer[4] = (byte)(timestamp >> 24 & 0xFFL);
        this.buffer[5] = (byte)(timestamp >> 16 & 0xFFL);
        this.buffer[6] = (byte)(timestamp >> 8 & 0xFFL);
        this.buffer[7] = (byte)(timestamp & 0xFFL);
        this.buffer[8] = (byte)(this.ssrc >> 24 & 0xFFL);
        this.buffer[9] = (byte)(this.ssrc >> 16 & 0xFFL);
        this.buffer[10] = (byte)(this.ssrc >> 8 & 0xFFL);
        this.buffer[11] = (byte)(this.ssrc & 0xFFL);
        ++this.lastSequence;
        if (this.lastSequence > 65535) {
            this.lastSequence = 0;
        }
    }

    public void transferData(PushSourceStream stream) {
        logger.warning("RTP PUSH SOURCE STREAM !!");
        if (!stream.endOfStream()) {
            int length = 0;
            int size = stream.getMinimumTransferSize();
            if (this.buffer.length < size + 12) {
                this.buffer = new byte[size + 12];
            }
            try {
                length = stream.read(this.buffer, 12, this.buffer.length - 12);
                if (length > 0) {
                    long time = System.currentTimeMillis();
                    if (this.lastSendTime != -1L) {
                        this.lastTimestamp = (long)((double)this.lastTimestamp + (double)(time - this.lastSendTime) * this.clockRate / 1000.0);
                    }
                    this.lastSendTime = time;
                    this.writeHeaderToBuffer(false, this.lastTimestamp);
                    this.rtpDataStream.write(this.buffer, 0, length + 12);
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
            }
            this.stats.addPDUTransmitted();
            RTPHeader header = null;
            try {
                header = new RTPHeader(this.buffer, 0, 12);
                int len = length - (header.getPadding() > 0 ? this.buffer[this.buffer.length - 1] : 0);
                this.stats.addBytesTransmitted(len);
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.rtpMgr.RTPPacketSent(this.lastSendTime, length + 12);
        }
    }

    public void transferData(PushBufferStream stream) {
        if (!stream.endOfStream()) {
            Buffer recvBuffer = new Buffer();
            try {
                if (this.buffer.length < 2060) {
                    this.buffer = new byte[2060];
                }
                recvBuffer.setData(this.buffer);
                recvBuffer.setOffset(12);
                recvBuffer.setLength(this.buffer.length - 12);
                stream.read(recvBuffer);
                if (recvBuffer.getLength() > 0) {
                    if (recvBuffer.getData() != this.buffer) {
                        System.arraycopy(recvBuffer.getData(), recvBuffer.getOffset(), this.buffer, 12, recvBuffer.getLength());
                    }
                    boolean marker = (recvBuffer.getFlags() & 0x800) != 0;
                    long rtpTimestamp = 0L;
                    if (stream.getFormat().getEncoding() == "ULAW/rtp" || stream.getFormat().getEncoding() == "gsm/rtp") {
                        rtpTimestamp = this.lastTimestamp;
                    } else if (stream.getFormat().getEncoding() == "jpeg/rtp") {
                        rtpTimestamp = this.lastTimestamp;
                        if (0L == this.lastBufferTimestamp) {
                            this.lastBufferTimestamp = System.nanoTime() / 1000000L;
                        }
                    }
                    this.writeHeaderToBuffer(marker, rtpTimestamp);
                    if (recvBuffer.getData() != this.buffer) {
                        System.arraycopy(recvBuffer.getData(), recvBuffer.getOffset(), this.buffer, 12, recvBuffer.getLength());
                    }
                    this.rtpDataStream.write(this.buffer, 0, recvBuffer.getLength() + 12);
                    if (stream.getFormat().getEncoding() == "ULAW/rtp") {
                        this.lastTimestamp += (long)recvBuffer.getLength();
                    } else if (stream.getFormat().getEncoding() == "gsm/rtp") {
                        this.lastTimestamp += (long)(recvBuffer.getLength() * 8000 / 1650);
                    } else if (stream.getFormat().getEncoding() == "jpeg/rtp" && (recvBuffer.getFlags() & 0x800) > 0) {
                        long currentTime = System.nanoTime() / 1000000L;
                        long diffTime = currentTime - this.lastBufferTimestamp;
                        this.lastTimestamp += diffTime * 90L;
                        this.lastBufferTimestamp = currentTime;
                    }
                    this.lastSendTime = System.currentTimeMillis() - -2208988800000L;
                    if (this.initialSendTime == -1L) {
                        this.initialSendTime = this.lastSendTime;
                    }
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
            }
            this.stats.addPDUTransmitted();
            RTPHeader header = null;
            try {
                header = new RTPHeader(this.buffer, 0, 12);
                int len = recvBuffer.getLength() - (header.getPadding() > 0 ? this.buffer[this.buffer.length - 1] : 0);
                this.stats.addBytesTransmitted(len);
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.rtpMgr.RTPPacketSent(this.lastSendTime, recvBuffer.getLength() + 12);
        }
    }

    private static void printFlags(Buffer buf) {
        StringBuffer out = new StringBuffer("FLAGS :");
        if ((buf.getFlags() & 0x2000) != 0) {
            out.append("OVERFLOWN ");
        }
        if ((buf.getFlags() & 0x4000) != 0) {
            out.append("UNDERFLOWN ");
        }
        if ((buf.getFlags() & 2) != 0) {
            out.append("DISCARDED ");
        }
        if ((buf.getFlags() & 1) != 0) {
            out.append("EOM ");
        }
        if ((buf.getFlags() & 0x200) != 0) {
            out.append("FLUSH ");
        }
        if ((buf.getFlags() & 0x10) != 0) {
            out.append("KEY_FRAME ");
        }
        if ((buf.getFlags() & 0x8000) != 0) {
            out.append("LIVE_DATA ");
        }
        if ((buf.getFlags() & 0x20) != 0) {
            out.append("NO_DROP ");
        }
        if ((buf.getFlags() & 0x60) != 0) {
            out.append("NO_SYNC ");
        }
        if ((buf.getFlags() & 0x40) != 0) {
            out.append("NO_WAIT ");
        }
        if ((buf.getFlags() & 0x100) != 0) {
            out.append("RELATIVE_TIME ");
        }
        if ((buf.getFlags() & 0x800) != 0) {
            out.append("MARKER ");
        }
        if ((buf.getFlags() & 0x1000) != 0) {
            out.append("RTP_TIME ");
        }
        if ((buf.getFlags() & 8) != 0) {
            out.append("SID ");
        }
        if ((buf.getFlags() & 4) != 0) {
            out.append("SILENCE ");
        }
        if ((buf.getFlags() & 0x400) != 0) {
            out.append("SYSMARKER ");
        }
        if ((buf.getFlags() & 0x80) != 0) {
            out.append("SYSTIME ");
        }
        System.out.println(out);
    }

    public Vector getSourceDescription() {
        return new Vector(this.sourceDescriptions.values());
    }

    public int getSdesSize() {
        return this.sdesSize;
    }

    public long getLastSendTime() {
        return this.lastSendTime;
    }

    public long getInitialSendTime() {
        return this.initialSendTime;
    }

    public long getLastTimestamp() {
        return this.lastTimestamp;
    }

    public long getInitialTimestamp() {
        return this.initialTimestamp;
    }

    public double getClockRate() {
        return this.clockRate;
    }
}

