/*
 * Decompiled with CFR 0.152.
 */
package org.bushe.swing.event.annotation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bushe.swing.event.EventService;
import org.bushe.swing.event.EventTopicSubscriber;
import org.bushe.swing.event.annotation.AbstractProxySubscriber;
import org.bushe.swing.event.annotation.ReferenceStrength;

public class ProxyTopicSubscriber
extends AbstractProxySubscriber
implements EventTopicSubscriber {
    private String topic;

    public ProxyTopicSubscriber(Object object, Method method, ReferenceStrength referenceStrength, EventService eventService, String string) {
        super(object, method, referenceStrength, eventService);
        this.topic = string;
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray == null || classArray.length != 2 || !String.class.equals(classArray[0]) || classArray[1].isPrimitive()) {
            throw new IllegalArgumentException("The subscriptionMethod must have the two parameters, the first one must be a String and the second a non-primitive (Object or derivative).");
        }
    }

    public void onEvent(String string, Object object) {
        Object[] objectArray = new Object[]{string, object};
        try {
            Object object2 = this.getProxiedSubscriber();
            if (object2 == null) {
                return;
            }
            this.getSubscriptionMethod().invoke(object2, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("IllegalAccessException when invoking annotated method from EventService publication.  Topic:" + string + ", data:" + object + ", subscriber:" + this.getProxiedSubscriber() + ", subscription Method=" + this.getSubscriptionMethod(), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException("InvocationTargetException when invoking annotated method from EventService publication.  Topic:" + string + ", data:" + object + ", subscriber:" + this.getProxiedSubscriber() + ", subscription Method=" + this.getSubscriptionMethod(), invocationTargetException);
        }
    }

    protected void unsubscribe(String string) {
        this.getEventService().unsubscribe(string, (EventTopicSubscriber)this);
    }

    public boolean equals(Object object) {
        if (object instanceof ProxyTopicSubscriber) {
            if (!super.equals(object)) {
                return false;
            }
            ProxyTopicSubscriber proxyTopicSubscriber = (ProxyTopicSubscriber)object;
            if (this.topic != proxyTopicSubscriber.topic) {
                if (this.topic == null) {
                    return false;
                }
                if (!this.topic.equals(proxyTopicSubscriber.topic)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "ProxyTopicSubscriber{topic='" + this.topic + '\'' + "realSubscriber=" + this.getProxiedSubscriber() + ", subscriptionMethod=" + this.getSubscriptionMethod() + ", referenceStrength=" + (Object)((Object)this.getReferenceStrength()) + ", eventService=" + this.getEventService() + '}';
    }
}

