/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.AsfHeader;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.io.WriteableChunk;
import org.jaudiotagger.audio.asf.util.Utils;

public class ContentDescription
extends Chunk
implements WriteableChunk {
    private String author = null;
    private String copyRight = null;
    private String description = null;
    private String rating = null;
    private String title = null;

    public ContentDescription() {
        this(0L, BigInteger.valueOf(0L));
    }

    public ContentDescription(long pos, BigInteger chunkLen) {
        super(GUID.GUID_CONTENTDESCRIPTION, pos, chunkLen);
    }

    public String getAuthor() {
        if (this.author == null) {
            return "";
        }
        return this.author;
    }

    public String getComment() {
        if (this.description == null) {
            return "";
        }
        return this.description;
    }

    public String getCopyRight() {
        if (this.copyRight == null) {
            return "";
        }
        return this.copyRight;
    }

    @Override
    public long getCurrentAsfChunkSize() {
        long result = 44L;
        result += (long)(this.getAuthor().length() * 2);
        result += (long)(this.getComment().length() * 2);
        result += (long)(this.getRating().length() * 2);
        result += (long)(this.getTitle().length() * 2);
        return result += (long)(this.getCopyRight().length() * 2);
    }

    public String getRating() {
        if (this.rating == null) {
            return "";
        }
        return this.rating;
    }

    public String getTitle() {
        if (this.title == null) {
            return "";
        }
        return this.title;
    }

    @Override
    public boolean isEmpty() {
        return Utils.isBlank(this.author) && Utils.isBlank(this.copyRight) && Utils.isBlank(this.description) && Utils.isBlank(this.rating) && Utils.isBlank(this.title);
    }

    @Override
    public String prettyPrint(String prefix) {
        StringBuffer result = new StringBuffer(super.prettyPrint(prefix));
        result.append(prefix + "  |->Title      : " + this.getTitle() + Utils.LINE_SEPARATOR);
        result.append(prefix + "  |->Author     : " + this.getAuthor() + Utils.LINE_SEPARATOR);
        result.append(prefix + "  |->Copyright  : " + this.getCopyRight() + Utils.LINE_SEPARATOR);
        result.append(prefix + "  |->Description: " + this.getComment() + Utils.LINE_SEPARATOR);
        result.append(prefix + "  |->Rating     :" + this.getRating() + Utils.LINE_SEPARATOR);
        return result.toString();
    }

    public void setAuthor(String fileAuthor) throws IllegalArgumentException {
        Utils.checkStringLengthNullSafe(fileAuthor);
        this.author = fileAuthor;
    }

    public void setComment(String tagComment) throws IllegalArgumentException {
        Utils.checkStringLengthNullSafe(tagComment);
        this.description = tagComment;
    }

    public void setCopyRight(String cpright) throws IllegalArgumentException {
        Utils.checkStringLengthNullSafe(cpright);
        this.copyRight = cpright;
    }

    public void setRating(String ratingText) throws IllegalArgumentException {
        Utils.checkStringLengthNullSafe(ratingText);
        this.rating = ratingText;
    }

    public void setTitle(String songTitle) throws IllegalArgumentException {
        Utils.checkStringLengthNullSafe(songTitle);
        this.title = songTitle;
    }

    @Override
    public long writeInto(OutputStream out) throws IOException {
        long chunkSize = this.getCurrentAsfChunkSize();
        out.write(this.getGuid().getBytes());
        Utils.writeUINT64(this.getCurrentAsfChunkSize(), out);
        Utils.writeUINT16(this.getTitle().length() * 2 + 2, out);
        Utils.writeUINT16(this.getAuthor().length() * 2 + 2, out);
        Utils.writeUINT16(this.getCopyRight().length() * 2 + 2, out);
        Utils.writeUINT16(this.getComment().length() * 2 + 2, out);
        Utils.writeUINT16(this.getRating().length() * 2 + 2, out);
        out.write(Utils.getBytes(this.getTitle(), AsfHeader.ASF_CHARSET));
        out.write(AsfHeader.ZERO_TERM);
        out.write(Utils.getBytes(this.getAuthor(), AsfHeader.ASF_CHARSET));
        out.write(AsfHeader.ZERO_TERM);
        out.write(Utils.getBytes(this.getCopyRight(), AsfHeader.ASF_CHARSET));
        out.write(AsfHeader.ZERO_TERM);
        out.write(Utils.getBytes(this.getComment(), AsfHeader.ASF_CHARSET));
        out.write(AsfHeader.ZERO_TERM);
        out.write(Utils.getBytes(this.getRating(), AsfHeader.ASF_CHARSET));
        out.write(AsfHeader.ZERO_TERM);
        return chunkSize;
    }
}

