/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.ContentDescriptor;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.io.WriteableChunk;
import org.jaudiotagger.audio.asf.util.Utils;

public class ExtendedContentDescription
extends Chunk
implements WriteableChunk {
    private final Map<String, List<ContentDescriptor>> descriptors = new LinkedHashMap<String, List<ContentDescriptor>>();

    public ExtendedContentDescription() {
        this(BigInteger.valueOf(0L));
    }

    public ExtendedContentDescription(BigInteger chunkLen) {
        super(GUID.GUID_EXTENDED_CONTENT_DESCRIPTION, chunkLen);
    }

    public void addDescriptor(ContentDescriptor toAdd) {
        assert (toAdd != null) : "Argument must not be null.";
        List<ContentDescriptor> list = this.getDescriptors(toAdd.getName());
        if (list == null) {
            list = new ArrayList<ContentDescriptor>();
            this.descriptors.put(toAdd.getName(), list);
        }
        list.add(toAdd);
    }

    public void addOrReplace(ContentDescriptor descriptor) {
        assert (descriptor != null) : "Argument must not be null";
        this.remove(descriptor.getName());
        this.addDescriptor(descriptor);
    }

    public boolean containsDescriptor(String fieldName) {
        return this.descriptors.containsKey(fieldName);
    }

    @Override
    public long getCurrentAsfChunkSize() {
        long result = 26L;
        for (ContentDescriptor curr : this.getDescriptors()) {
            result += (long)curr.getCurrentAsfSize();
        }
        return result;
    }

    public int getDescriptorCount() {
        int result = 0;
        for (List<ContentDescriptor> curr : this.descriptors.values()) {
            result += curr.size();
        }
        return result;
    }

    public List<ContentDescriptor> getDescriptors() {
        ArrayList<ContentDescriptor> result = new ArrayList<ContentDescriptor>();
        for (List<ContentDescriptor> curr : this.descriptors.values()) {
            result.addAll(curr);
        }
        return result;
    }

    public List<ContentDescriptor> getDescriptors(String name) {
        return this.descriptors.get(name);
    }

    @Override
    public boolean isEmpty() {
        return this.getDescriptorCount() == 0;
    }

    @Override
    public String prettyPrint(String prefix) {
        StringBuffer result = new StringBuffer(super.prettyPrint(prefix));
        List<ContentDescriptor> list = this.getDescriptors();
        Collections.sort(list);
        for (ContentDescriptor curr : list) {
            result.append(prefix + "  |-> ");
            result.append(curr);
            result.append(Utils.LINE_SEPARATOR);
        }
        return result.toString();
    }

    public List<ContentDescriptor> remove(String id) {
        return this.descriptors.remove(id);
    }

    @Override
    public long writeInto(OutputStream out) throws IOException {
        long chunkSize = this.getCurrentAsfChunkSize();
        List<ContentDescriptor> descriptorList = this.getDescriptors();
        out.write(this.getGuid().getBytes());
        Utils.writeUINT64(chunkSize, out);
        Utils.writeUINT16(descriptorList.size(), out);
        for (ContentDescriptor curr : descriptorList) {
            curr.writeInto(out);
        }
        return chunkSize;
    }
}

