/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.mp4.field;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.mp4.Mp4TagField;
import org.jaudiotagger.tag.mp4.field.Mp4FieldType;

public class Mp4TagBinaryField
extends Mp4TagField {
    protected int dataSize;
    protected byte[] dataBytes;
    protected boolean isBinary = false;

    public Mp4TagBinaryField(String id) {
        super(id);
    }

    public Mp4TagBinaryField(String id, byte[] data) {
        super(id);
        this.dataBytes = data;
    }

    public Mp4TagBinaryField(String id, ByteBuffer raw) throws UnsupportedEncodingException {
        super(id, raw);
    }

    @Override
    public Mp4FieldType getFieldType() {
        return Mp4FieldType.NUMERIC;
    }

    @Override
    protected byte[] getDataBytes() throws UnsupportedEncodingException {
        return this.dataBytes;
    }

    @Override
    protected void build(ByteBuffer raw) {
        Mp4BoxHeader header = new Mp4BoxHeader(raw);
        this.dataSize = header.getDataLength();
        raw.position(raw.position() + 8);
        this.dataBytes = new byte[this.dataSize - 8];
        for (int i = 0; i < this.dataBytes.length; ++i) {
            this.dataBytes[i] = raw.get();
        }
    }

    @Override
    public boolean isBinary() {
        return this.isBinary;
    }

    @Override
    public boolean isEmpty() {
        return this.dataBytes.length == 0;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public byte[] getData() {
        return this.dataBytes;
    }

    public void setData(byte[] d) {
        this.dataBytes = d;
    }

    @Override
    public void copyContent(TagField field) {
        if (field instanceof Mp4TagBinaryField) {
            this.dataBytes = ((Mp4TagBinaryField)field).getData();
            this.isBinary = ((Mp4TagBinaryField)field).isBinary();
        }
    }
}

