/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.activation.impl;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Locale;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.limewire.activation.api.ActivationSettingsController;
import org.limewire.activation.impl.ActivationCommunicator;
import org.limewire.activation.impl.ActivationResponse;
import org.limewire.activation.impl.ActivationResponseFactory;
import org.limewire.activation.impl.InvalidTokenException;
import org.limewire.http.httpclient.HttpClientUtils;
import org.limewire.http.httpclient.LimeHttpClient;
import org.limewire.io.IOUtils;
import org.limewire.io.InvalidDataException;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.security.certificate.CipherProvider;
import org.limewire.util.EncodingUtils;
import org.limewire.util.StringUtils;

class ActivationCommunicatorImpl
implements ActivationCommunicator {
    private static final Log log = LogFactory.getLog(ActivationCommunicatorImpl.class);
    private static final String ENCRYPTION_ALGORITHM = "RSA";
    private static final CipherProvider.CipherType CIPHER_TYPE = CipherProvider.CipherType.RSA;
    private final ActivationResponseFactory activationFactory;
    private final Provider<LimeHttpClient> httpClientProvider;
    private final ActivationSettingsController activationSettings;
    private final CipherProvider cipherProvider;

    @Inject
    public ActivationCommunicatorImpl(ActivationSettingsController activationSettings, ActivationResponseFactory activationFactory, Provider<LimeHttpClient> httpClientProvider, CipherProvider cipherProvider) {
        this.activationSettings = activationSettings;
        this.httpClientProvider = httpClientProvider;
        this.activationFactory = activationFactory;
        this.cipherProvider = cipherProvider;
    }

    @Override
    public ActivationResponse activate(String licenseId, ActivationCommunicator.RequestType type) throws IOException, InvalidDataException, InvalidTokenException {
        String randomNumber = ActivationCommunicatorImpl.getRandomToken();
        String lidToken = this.getEncryptedToken(licenseId, randomNumber);
        String postContent = this.activationSettings.getQueryString() + "&lid=" + licenseId + "&lidtoken=" + lidToken;
        String jsonResult = this.sendToServer(postContent, licenseId, type);
        ActivationResponse activationResponse = this.activationFactory.createFromJson(jsonResult);
        boolean responseHasSameRandomNumber = randomNumber.equals(activationResponse.getToken());
        if (activationResponse.getResponseType() == ActivationResponse.Type.VALID && !responseHasSameRandomNumber) {
            log.debug("Invalid random number");
            throw new InvalidTokenException("random number security check failed");
        }
        return activationResponse;
    }

    private static String getRandomToken() {
        return String.valueOf(Math.random()).substring(2);
    }

    private String getEncryptedToken(String licenseId, String randomNumber) throws IOException {
        byte[] cipherData;
        byte[] keyBytes = Base64.decodeBase64(this.activationSettings.getServerKey().getBytes());
        try {
            KeyFactory fac = KeyFactory.getInstance(ENCRYPTION_ALGORITHM);
            PublicKey publicKey = fac.generatePublic(new X509EncodedKeySpec(keyBytes));
            byte[] messageToEcrypt = StringUtils.toUTF8Bytes(licenseId + "," + randomNumber);
            cipherData = this.cipherProvider.encrypt(messageToEcrypt, publicKey, CIPHER_TYPE);
        }
        catch (GeneralSecurityException e) {
            throw IOUtils.getIOException("Security exception while initializing key", e);
        }
        String noEncoding = new String(Base64.encodeBase64(cipherData));
        return EncodingUtils.encode(noEncoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String sendToServer(String queryStringToPost, String key, ActivationCommunicator.RequestType type) throws IOException {
        String submitUrl = this.activationSettings.getActivationHost();
        StringEntity postContent = new StringEntity(queryStringToPost);
        HttpPost httpPost = new HttpPost(this.getQueryString(submitUrl, type, key));
        httpPost.addHeader("Connection", "close");
        httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded");
        httpPost.setEntity(postContent);
        HttpClient httpClient = this.httpClientProvider.get();
        HttpResponse response = null;
        try {
            response = httpClient.execute(httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            if (statusCode != 200 || entity == null) {
                throw new IOException("invalid http response, status: " + statusCode + ", entity: " + (entity != null ? EntityUtils.toString(entity) : "none"));
            }
            String string = EntityUtils.toString(entity);
            return string;
        }
        finally {
            HttpClientUtils.releaseConnection(response);
        }
    }

    private String getQueryString(String url, ActivationCommunicator.RequestType type, String key) {
        if (url.indexOf(63) == -1) {
            url = url + "?";
        }
        return url + "reqtype=" + EncodingUtils.encode(type.toString().toLowerCase(Locale.US)) + (this.isBetaKey(key) ? "&lid=" + key : "");
    }

    private boolean isBetaKey(String key) {
        return key.startsWith("BETA");
    }
}

