/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.limewire.service.ErrorService;

public class FixedSizeSortedSet<E>
implements Iterable<E> {
    private SortedSet<E> _sortedSet;
    private Map<E, E> _map;
    private int _maxSize;

    public FixedSizeSortedSet() {
        this(50);
    }

    public FixedSizeSortedSet(int size) {
        this._maxSize = size;
        this._sortedSet = new TreeSet();
        this._map = new HashMap<E, E>();
    }

    public FixedSizeSortedSet(Comparator<? super E> c) {
        this(c, 50);
    }

    public FixedSizeSortedSet(Comparator<? super E> c, int maxSize) {
        this._maxSize = maxSize;
        this._sortedSet = new TreeSet<E>(c);
        this._map = new HashMap<E, E>();
    }

    public Object clone() throws CloneNotSupportedException {
        FixedSizeSortedSet<E> ret = new FixedSizeSortedSet<E>(this._maxSize);
        ret._sortedSet = (SortedSet)((TreeSet)this._sortedSet).clone();
        ret._map = (Map)((HashMap)this._map).clone();
        return ret;
    }

    public boolean add(E o) {
        if (o == null) {
            return false;
        }
        E val = this._map.get(o);
        if (val != null) {
            boolean removed = this._sortedSet.remove(val);
            if (!removed) {
                this.invariantsBroken(o, val);
            }
            this._sortedSet.add(o);
            this._map.put(o, o);
            return false;
        }
        if (this._map.size() >= this._maxSize) {
            boolean removed;
            E highest = this._sortedSet.last();
            boolean bl = removed = this._map.remove(highest) != null;
            if (!removed) {
                this.invariantsBroken(highest, highest);
            }
            if (!(removed = this._sortedSet.remove(highest))) {
                this.invariantsBroken(highest, highest);
            }
        }
        this._map.put(o, o);
        boolean added = this._sortedSet.add(o);
        if (!added) {
            this.invariantsBroken(o, o);
        }
        return true;
    }

    public boolean addAll(Collection<? extends E> c) {
        boolean ret = false;
        for (E e : c) {
            ret |= this.add(e);
        }
        return ret;
    }

    public E get(E o) {
        return this._map.get(o);
    }

    public E last() {
        return this._sortedSet.last();
    }

    public E first() {
        return this._sortedSet.first();
    }

    public boolean remove(E o) {
        boolean b2;
        E obj = this._map.remove(o);
        boolean b1 = obj != null;
        if (b1 != (b2 = this._sortedSet.remove(obj))) {
            this.invariantsBroken(o, obj);
        }
        return b1;
    }

    public void clear() {
        this._sortedSet.clear();
        this._map.clear();
    }

    public boolean contains(Object o) {
        return this._map.get(o) != null;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof FixedSizeSortedSet)) {
            return false;
        }
        FixedSizeSortedSet other = (FixedSizeSortedSet)o;
        return this._sortedSet.equals(other._sortedSet) && ((Object)this._map).equals(other._map);
    }

    public int hashCode() {
        return this._sortedSet.hashCode() + 37 * ((Object)this._map).hashCode();
    }

    public boolean isEmpty() {
        assert (this._sortedSet.isEmpty() == this._map.isEmpty());
        return this._sortedSet.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new FSSSIterator();
    }

    public int size() {
        if (this._sortedSet.size() != this._map.size()) {
            this.invariantsBroken(null, null);
        }
        return this._sortedSet.size();
    }

    private void invariantsBroken(E key, E value) {
        String mapBefore = this._map.toString();
        String setBefore = this._sortedSet.toString();
        String mapSizeBefore = "" + this._map.size();
        String setSizeBefore = "" + this._sortedSet.size();
        this.stabilize();
        String mapAfter = this._map.toString();
        String setAfter = this._sortedSet.toString();
        String mapSizeAfter = "" + this._map.size();
        String setSizeAfter = "" + this._sortedSet.size();
        ErrorService.error(new IllegalStateException("key: " + key + ", value: " + value + "\nbefore stabilization: " + "\nsize of map: " + mapSizeBefore + ", set: " + setSizeBefore + "\nmap: " + mapBefore + "\nset: " + setBefore + "\nafter stabilization: " + "\nsize of map " + mapSizeAfter + ", set: " + setSizeAfter + "\nmap: " + mapAfter + "\nset: " + setAfter));
    }

    private void stabilize() {
        Iterator<Map.Entry<E, E>> iter = this._map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<E, E> entry = iter.next();
            if (this._sortedSet.contains(entry.getValue())) continue;
            iter.remove();
        }
        Collection<E> values = this._map.values();
        Iterator iter2 = this._sortedSet.iterator();
        while (iter2.hasNext()) {
            Object o = iter2.next();
            if (values.contains(o)) continue;
            iter2.remove();
        }
    }

    private class FSSSIterator
    implements Iterator<E> {
        private final Iterator<E> _setIterator;
        private E _current;

        public FSSSIterator() {
            this._setIterator = FixedSizeSortedSet.this._sortedSet.iterator();
        }

        @Override
        public boolean hasNext() {
            return this._setIterator.hasNext();
        }

        @Override
        public E next() {
            this._current = this._setIterator.next();
            return this._current;
        }

        @Override
        public void remove() {
            this._setIterator.remove();
            FixedSizeSortedSet.this._map.remove(this._current);
            this._current = null;
        }
    }
}

