/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

public class LongHashMap<V> {
    private transient Entry<V>[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    public LongHashMap() {
        this(20, 0.75f);
    }

    public LongHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public LongHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public LongHashMap(LongHashMap<? extends V> m) {
        this((int)((double)(1 + m.size()) * 1.1));
        this.putAll(m);
    }

    public void putAll(LongHashMap<? extends V> m) {
        Entry<V>[] tab = m.table;
        int i = tab.length;
        while (i-- > 0) {
            Entry<V> e = tab[i];
            while (e != null) {
                this.put(e.key, e.value);
                e = e.next;
            }
        }
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Entry<V>[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            Entry<V> e = tab[i];
            while (e != null) {
                if (e.value.equals(value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean containsValue(Object value) {
        return this.contains(value);
    }

    public boolean containsKey(long key) {
        Entry<V>[] tab = this.table;
        int hash = (int)key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<V> e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public V get(long key) {
        Entry<V>[] tab = this.table;
        int hash = (int)key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<V> e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        Entry<V>[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry<V> old = oldMap[i];
            while (old != null) {
                Entry<V> e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public V put(long key, V value) {
        Entry<V>[] tab = this.table;
        int hash = (int)key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<V> e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key == key) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e = new Entry<V>(hash, key, value, tab[index]);
        ++this.count;
        return null;
    }

    public V remove(long key) {
        Entry<V>[] tab = this.table;
        int hash = (int)key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<V> e = tab[index];
        Entry<V> prev = null;
        while (e != null) {
            if (e.hash == hash && e.key == key) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                Object oldValue = e.value;
                e.value = null;
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public synchronized void clear() {
        Entry<V>[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    private static class Entry<V> {
        int hash;
        long key;
        V value;
        Entry<V> next;

        protected Entry(int hash, long key, V value, Entry<V> next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

