/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.limewire.collection.MultiIterable;

public class MultiCollection<T>
extends MultiIterable<T>
implements Collection<T> {
    private final Iterable<? extends Collection<? extends T>> collections;

    public MultiCollection(Collection<? extends T> i1, Collection<? extends T> i2) {
        super(i1, i2);
        ArrayList<Collection<T>> l = new ArrayList<Collection<T>>(2);
        l.add(i1);
        l.add(i2);
        this.collections = l;
    }

    public MultiCollection(Collection<? extends T> ... collections) {
        super((Iterable[])collections);
        ArrayList<Collection<T>> l = new ArrayList<Collection<T>>(collections.length);
        l.addAll(Arrays.asList(collections));
        this.collections = l;
    }

    public MultiCollection(Iterable<? extends Collection<? extends T>> collections) {
        super(collections);
        this.collections = collections;
    }

    @Override
    public boolean add(T o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        for (Collection<T> c : this.collections) {
            c.clear();
        }
    }

    @Override
    public boolean contains(Object o) {
        for (Collection<T> c : this.collections) {
            if (!c.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object obj : c) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        for (Collection<T> c : this.collections) {
            if (c.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        for (Collection<T> c : this.collections) {
            if (!c.remove(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean ret = false;
        for (Object o : c) {
            if (!this.remove(o)) continue;
            ret = true;
        }
        return ret;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean ret = false;
        for (Collection<T> col : this.collections) {
            if (!col.retainAll(c)) continue;
            ret = true;
        }
        return ret;
    }

    @Override
    public int size() {
        int ret = 0;
        for (Collection<T> c : this.collections) {
            ret += c.size();
        }
        return ret;
    }

    @Override
    public Object[] toArray() {
        ArrayList<? extends T> t = new ArrayList<T>(this.size());
        for (Collection<? extends T> collection : this.collections) {
            t.addAll(collection);
        }
        return t.toArray();
    }

    @Override
    public <B> B[] toArray(B[] a) {
        ArrayList<? extends T> t = new ArrayList<T>(this.size());
        for (Collection<? extends T> collection : this.collections) {
            t.addAll(collection);
        }
        return t.toArray(a);
    }
}

