/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.friend;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.SocketProcessor;
import com.limegroup.gnutella.downloader.PushDownloadManager;
import com.limegroup.gnutella.downloader.PushedSocketHandler;
import com.limegroup.gnutella.downloader.PushedSocketHandlerRegistry;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.limewire.friend.api.FriendException;
import org.limewire.friend.api.FriendPresence;
import org.limewire.friend.api.feature.ConnectBackRequestFeature;
import org.limewire.friend.api.feature.FeatureTransport;
import org.limewire.friend.impl.address.FriendAddressResolver;
import org.limewire.friend.impl.address.FriendFirewalledAddress;
import org.limewire.inject.EagerSingleton;
import org.limewire.io.Address;
import org.limewire.io.Connectable;
import org.limewire.io.GUID;
import org.limewire.io.IOUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.net.ConnectBackRequest;
import org.limewire.net.SocketsManager;
import org.limewire.net.address.AddressConnector;
import org.limewire.net.address.FirewalledAddress;
import org.limewire.nio.AbstractNBSocket;
import org.limewire.nio.observer.ConnectObserver;
import org.limewire.rudp.UDPSelectorProvider;

@EagerSingleton
class FriendFirewalledAddressConnector
implements AddressConnector,
PushedSocketHandler {
    private static final Log LOG = LogFactory.getLog(FriendFirewalledAddressConnector.class, "address-connecting");
    private final PushDownloadManager pushDownloadManager;
    private final NetworkManager networkManager;
    private final ScheduledExecutorService backgroundExecutor;
    final List<PushedSocketConnectObserver> observers = new CopyOnWriteArrayList<PushedSocketConnectObserver>();
    private final Provider<UDPSelectorProvider> udpSelectorProvider;
    private final Provider<SocketProcessor> socketProcessor;
    private final FriendAddressResolver friendAddressResolver;

    @Inject
    public FriendFirewalledAddressConnector(FriendAddressResolver friendAddressResolver, PushDownloadManager pushDownloadManager, NetworkManager networkManager, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, Provider<UDPSelectorProvider> udpSelectorProvider, Provider<SocketProcessor> socketProcessor) {
        this.friendAddressResolver = friendAddressResolver;
        this.pushDownloadManager = pushDownloadManager;
        this.networkManager = networkManager;
        this.backgroundExecutor = backgroundExecutor;
        this.udpSelectorProvider = udpSelectorProvider;
        this.socketProcessor = socketProcessor;
    }

    @Inject
    void register(SocketsManager socketsManager) {
        socketsManager.registerConnector(this);
    }

    @Inject
    void register(PushedSocketHandlerRegistry pushedSocketHandlerRegistry) {
        pushedSocketHandlerRegistry.register(this);
    }

    @Override
    public boolean canConnect(Address address) {
        if (address instanceof FriendFirewalledAddress) {
            FriendFirewalledAddress friendFirewalledAddress = (FriendFirewalledAddress)address;
            boolean canConnect = this.pushDownloadManager.canConnect(friendFirewalledAddress.getFirewalledAddress());
            LOG.debugf("{0} connect remote address {1}, because PDM cannot connect {2}", (Object)(canConnect ? "can" : "can not"), (Object)address, (Object)friendFirewalledAddress.getFirewalledAddress());
            return canConnect;
        }
        LOG.debugf("can not connect remote address {0}", (Object)address);
        return false;
    }

    @Override
    public void connect(Address address, ConnectObserver observer) {
        try {
            this.connectSendingConnectBack(address, observer);
        }
        catch (ConnectBackRequestException ce) {
            LOG.debugf(ce, "could not send connect back request {0}", address);
            this.pushDownloadManager.connect((Address)((FriendFirewalledAddress)address).getFirewalledAddress(), observer);
        }
    }

    void connectSendingConnectBack(Address address, ConnectObserver observer) throws ConnectBackRequestException {
        FriendFirewalledAddress friendFirewalledAddress = (FriendFirewalledAddress)address;
        FirewalledAddress firewalledAddress = friendFirewalledAddress.getFirewalledAddress();
        GUID clientGuid = firewalledAddress.getClientGuid();
        Connectable publicAddress = this.networkManager.getPublicAddress();
        if (!NetworkUtils.isValidIpPort(publicAddress)) {
            LOG.debugf("not a valid public address yet: {0}", (Object)publicAddress);
            observer.handleIOException(new ConnectException("no valid address yet: " + publicAddress));
            return;
        }
        boolean isFWT = !this.networkManager.acceptedIncomingConnection();
        FriendPresence presence = this.friendAddressResolver.getPresence(friendFirewalledAddress.getFriendAddress());
        if (presence == null) {
            throw new ConnectBackRequestException("no presence available for: " + friendFirewalledAddress.getFriendAddress());
        }
        FeatureTransport transport = presence.getTransport(ConnectBackRequestFeature.class);
        if (transport == null) {
            throw new ConnectBackRequestException("no transport for presence: " + presence);
        }
        final PushedSocketConnectObserver pushedSocketObserver = new PushedSocketConnectObserver(firewalledAddress, observer);
        this.observers.add(pushedSocketObserver);
        try {
            transport.sendFeature(presence, new ConnectBackRequest(publicAddress, clientGuid, isFWT ? this.networkManager.supportsFWTVersion() : 0));
        }
        catch (FriendException e) {
            this.observers.remove(pushedSocketObserver);
            throw new ConnectBackRequestException(e);
        }
        if (isFWT) {
            LOG.debug("Starting fwt communication");
            assert (NetworkUtils.isValidIpPort(firewalledAddress.getPublicAddress())) : "invalid public address" + firewalledAddress;
            AbstractNBSocket socket = this.udpSelectorProvider.get().openSocketChannel().socket();
            socket.connect(firewalledAddress.getPublicAddress().getInetSocketAddress(), 20000, new ConnectObserver(){

                @Override
                public void handleConnect(Socket socket) throws IOException {
                    LOG.debugf("handling socket: {0}", (Object)socket);
                    ((SocketProcessor)FriendFirewalledAddressConnector.this.socketProcessor.get()).processSocket(socket, "GIV");
                }

                @Override
                public void handleIOException(IOException iox) {
                    pushedSocketObserver.handleIOException(iox);
                }

                @Override
                public void shutdown() {
                    pushedSocketObserver.handleIOException(new IOException("shutdown"));
                }
            });
        }
        this.scheduleExpirerFor(pushedSocketObserver, 30000);
    }

    private void scheduleExpirerFor(final PushedSocketConnectObserver pushedSocketObserver, int timeout) {
        this.backgroundExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                FriendFirewalledAddressConnector.this.observers.remove(pushedSocketObserver);
                pushedSocketObserver.handleTimeout();
            }
        }, (long)timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean acceptPushedSocket(String file, int index, byte[] clientGUID, Socket socket) {
        for (PushedSocketConnectObserver observer : this.observers) {
            if (!observer.acceptSocket(clientGUID, socket)) continue;
            return true;
        }
        return false;
    }

    static class ConnectBackRequestException
    extends Exception {
        public ConnectBackRequestException(String message) {
            super(message);
        }

        public ConnectBackRequestException(Throwable cause) {
            super(cause);
        }
    }

    static class PushedSocketConnectObserver {
        private final FirewalledAddress firewalledAddress;
        private final ConnectObserver observer;
        final AtomicBoolean acceptedOrFailed = new AtomicBoolean(false);

        public PushedSocketConnectObserver(FirewalledAddress firewalledAddress, ConnectObserver observer) {
            this.firewalledAddress = firewalledAddress;
            this.observer = observer;
        }

        public boolean acceptSocket(byte[] clientGuid, Socket socket) {
            if (Arrays.equals(clientGuid, this.firewalledAddress.getClientGuid().bytes())) {
                Connectable expectedAddress = this.firewalledAddress.getPublicAddress();
                if (NetworkUtils.isValidIpPort(expectedAddress) && !expectedAddress.getInetAddress().equals(socket.getInetAddress())) {
                    LOG.debugf("received socket from unexpected location, expected: {0}, actual: {1}", (Object)expectedAddress, (Object)socket);
                    return false;
                }
                if (this.acceptedOrFailed.compareAndSet(false, true)) {
                    try {
                        LOG.debugf("handling connect from: {0}", (Object)socket);
                        this.observer.handleConnect(socket);
                    }
                    catch (IOException ie) {
                        IOUtils.close(socket);
                    }
                    return true;
                }
            }
            return false;
        }

        public void handleTimeout() {
            LOG.debug("handling timeout");
            this.handleIOException(new ConnectException("connect request timed out"));
        }

        public void handleIOException(IOException ie) {
            LOG.debug("handling io exception", ie);
            if (this.acceptedOrFailed.compareAndSet(false, true)) {
                this.observer.handleIOException(ie);
            }
        }
    }
}

