/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.inspections;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.core.impl.inspections.InspectionDataContainer;
import org.limewire.core.impl.inspections.InspectionsCommunicator;
import org.limewire.core.impl.inspections.InspectionsParser;
import org.limewire.core.impl.inspections.InspectionsResultProcessor;
import org.limewire.core.impl.inspections.InspectionsSpec;
import org.limewire.core.settings.ApplicationSettings;
import org.limewire.core.settings.InspectionsSettings;
import org.limewire.http.httpclient.HttpClientInstanceUtils;
import org.limewire.http.httpclient.HttpClientUtils;
import org.limewire.http.httpclient.LimeHttpClient;
import org.limewire.inject.EagerSingleton;
import org.limewire.inspection.InspectionsServerUrls;
import org.limewire.inspection.Inspector;
import org.limewire.io.InvalidDataException;
import org.limewire.lifecycle.Asynchronous;
import org.limewire.lifecycle.Join;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.setting.StringSetting;

@EagerSingleton
public class InspectionsCommunicatorImpl
implements InspectionsCommunicator,
Service {
    private static final Log LOG = LogFactory.getLog(InspectionsCommunicatorImpl.class);
    private static final String SERVICE_NAME = "Push Inspections Communicator";
    private final ScheduledExecutorService scheduler;
    private final Inspector inspector;
    private InspectionsResultProcessor processor;
    private final Provider<LimeHttpClient> httpClientProvider;
    private final InspectionsParser parser;
    private final Provider<Map<String, StringSetting>> inspectionsServerUrls;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private List<InspectionsSpec> inspectionsSpecs = new ArrayList<InspectionsSpec>();
    private final HttpClientInstanceUtils httpClientInstanceUtils;

    @Inject
    public InspectionsCommunicatorImpl(@Named(value="fastExecutor") ScheduledExecutorService scheduler, Provider<LimeHttpClient> httpClientProvider, @InspectionsServerUrls Provider<Map<String, StringSetting>> inspectionsServerUrls, Inspector inspector, HttpClientInstanceUtils httpClientInstanceUtils) {
        this.scheduler = scheduler;
        this.inspector = inspector;
        this.httpClientProvider = httpClientProvider;
        this.inspectionsServerUrls = inspectionsServerUrls;
        this.httpClientInstanceUtils = httpClientInstanceUtils;
        this.processor = null;
        this.parser = new InspectionsParser();
    }

    @Inject
    public void register(ServiceRegistry serviceRegistry) {
        serviceRegistry.register(this);
    }

    @Override
    public void setResultProcessor(InspectionsResultProcessor processor) {
        this.processor = processor;
    }

    @Override
    public InspectionsResultProcessor getResultProcessor() {
        if (this.processor == null) {
            this.processor = new DefaultInspectionsProcessor();
        }
        return this.processor;
    }

    @Override
    public synchronized void initInspectionSpecs(List<InspectionsSpec> inspSpecs) {
        for (InspectionsSpec spec : inspSpecs) {
            if (spec.getInspectionPoints().isEmpty()) continue;
            spec.schedule(this.getResultProcessor(), this.inspector, this.scheduler);
            this.inspectionsSpecs.add(spec);
        }
    }

    public synchronized void cancelInspections(List<InspectionsSpec> inspSpecs) {
        for (InspectionsSpec spec : inspSpecs) {
            spec.ensureCancelled();
        }
        this.inspectionsSpecs.removeAll(inspSpecs);
    }

    private byte[] requestInspectionsFromServer() throws IOException {
        String requestUrl = this.inspectionsServerUrls.get().get("INSPECTION_SPEC_REQUEST_URL").get();
        HttpGet httpGet = new HttpGet(this.addClientInfoToUrl(requestUrl));
        httpGet.addHeader("Accept-Encoding", "gzip");
        httpGet.addHeader("Connection", "close");
        return this.executeRequest(httpGet);
    }

    private byte[] sendInspectionsResultsToServer(byte[] bytesToPost) throws IOException {
        String submitUrl = this.inspectionsServerUrls.get().get("INSPECTION_SPEC_SUBMIT_URL").get();
        ByteArrayEntity postContent = new ByteArrayEntity(bytesToPost);
        HttpPost httpPost = new HttpPost(this.addClientInfoToUrl(submitUrl));
        httpPost.addHeader("Accept-Encoding", "gzip");
        httpPost.addHeader("Connection", "close");
        httpPost.addHeader("Content-Encoding", "gzip");
        httpPost.addHeader("Content-Type", "binary/octet-stream");
        httpPost.setEntity(postContent);
        return this.executeRequest(httpPost);
    }

    private String addClientInfoToUrl(String serverUrl) {
        boolean usage = (Boolean)ApplicationSettings.ALLOW_ANONYMOUS_STATISTICS_GATHERING.get();
        return this.httpClientInstanceUtils.addClientInfoToUrl(serverUrl) + "&urs=" + Boolean.toString(usage);
    }

    private byte[] executeRequest(HttpUriRequest request) throws IOException {
        if (!InspectionsSettings.PUSH_INSPECTIONS_ON.getBoolean()) {
            this.stop();
            return new byte[0];
        }
        HttpClient httpClient = this.httpClientProvider.get();
        HttpResponse response = httpClient.execute(request);
        int statusCode = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        if (statusCode != 200 || entity == null) {
            throw new IOException("invalid http response, status: " + statusCode + ", entity: " + (entity != null ? EntityUtils.toString(entity) : "none"));
        }
        byte[] responseBytes = EntityUtils.toByteArray(entity);
        HttpClientUtils.releaseConnection(response);
        return responseBytes;
    }

    @Override
    @Asynchronous(join=Join.NONE)
    public void start() {
        if (InspectionsSettings.PUSH_INSPECTIONS_ON.getBoolean()) {
            this.started.set(true);
            List<InspectionsSpec> specs = Collections.emptyList();
            try {
                byte[] rawInspectionSpecs = this.requestInspectionsFromServer();
                specs = this.parser.parseInspectionSpecs(rawInspectionSpecs);
            }
            catch (IOException e) {
                LOG.error("Error in getting inspections specifications from server", e);
            }
            catch (InvalidDataException e) {
                LOG.error("Error in getting inspections specifications from server", e);
            }
            if (!specs.isEmpty()) {
                this.initInspectionSpecs(specs);
            }
        }
    }

    @Override
    public void stop() {
        if (this.started.compareAndSet(true, false)) {
            this.cancelInspections(this.inspectionsSpecs);
            if (this.processor != null) {
                this.processor.stopped();
                this.processor = null;
            }
        }
    }

    @Override
    public void initialize() {
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    private class SendToServer
    implements Runnable {
        private final InspectionsSpec spec;
        private final InspectionDataContainer insps;

        SendToServer(InspectionsSpec spec, InspectionDataContainer insps) {
            this.spec = spec;
            this.insps = insps;
        }

        @Override
        public void run() {
            try {
                byte[] bytesToSend = InspectionsCommunicatorImpl.this.parser.inspectionResultToByteArray(this.insps);
                InspectionsCommunicatorImpl.this.sendInspectionsResultsToServer(bytesToSend);
            }
            catch (IOException e) {
                this.processError();
            }
        }

        private void processError() {
            this.spec.ensureCancelled();
        }
    }

    private class InspectionSendingErrorHandler
    implements RejectedExecutionHandler {
        private InspectionSendingErrorHandler() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            ((SendToServer)r).processError();
        }
    }

    private class DefaultInspectionsProcessor
    implements InspectionsResultProcessor {
        private static final int QUEUE_SIZE = 10;
        private ExecutorService queueExec;

        private DefaultInspectionsProcessor() {
            this.queueExec = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(10), ExecutorsHelper.daemonThreadFactory("InspectionsSender"), new InspectionSendingErrorHandler());
        }

        @Override
        public synchronized void inspectionsPerformed(InspectionsSpec spec, InspectionDataContainer insps) {
            this.queueExec.execute(new SendToServer(spec, insps));
        }

        @Override
        public synchronized void stopped() {
            this.queueExec.shutdown();
        }
    }
}

