/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.itunes;

import com.google.inject.Singleton;
import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.ComFailException;
import com.jacob.com.ComThread;
import com.jacob.com.Dispatch;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.core.impl.itunes.ItunesMediator;
import org.limewire.core.settings.iTunesSettings;
import org.limewire.external.itunes.windows.com.IITLibraryPlaylist;
import org.limewire.external.itunes.windows.com.IITOperationStatus;
import org.limewire.external.itunes.windows.com.IiTunes;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

@Singleton
public final class ItunesMediatorImpl
implements ItunesMediator {
    private static final Log LOG = LogFactory.getLog(ItunesMediatorImpl.class);
    private final ExecutorService QUEUE = ExecutorsHelper.newProcessingQueue("iTunesAdderThread");

    @Override
    public void addSong(File file) {
        File[] files;
        if (!OSUtils.isWindows() && !OSUtils.isMacOSX()) {
            return;
        }
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        if (!file.exists()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("File: '" + file + "' does not exist");
            }
            return;
        }
        if (file.isDirectory()) {
            files = FileUtils.getFilesRecursive(file, iTunesSettings.ITUNES_SUPPORTED_FILE_TYPES.get());
        } else if (file.isFile() && ItunesMediatorImpl.isSupported(FileUtils.getFileExtension(file))) {
            files = new File[]{file};
        } else {
            return;
        }
        for (File toAdd : files) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Will add '" + toAdd + "' to Playlist");
            }
            if (OSUtils.isWindows()) {
                this.QUEUE.execute(new AddFileToWindowsITunes(toAdd));
                continue;
            }
            if (!OSUtils.isMacOSX()) continue;
            this.QUEUE.execute(new ExecOSAScriptCommand(toAdd));
        }
    }

    private static boolean isSupported(String extension) {
        if (extension.isEmpty()) {
            return false;
        }
        String[] types = iTunesSettings.ITUNES_SUPPORTED_FILE_TYPES.get();
        for (int i = 0; i < types.length; ++i) {
            if (!extension.equalsIgnoreCase(types[i])) continue;
            return true;
        }
        return false;
    }

    private static class ExecOSAScriptCommand
    implements Runnable {
        private final File file;

        public ExecOSAScriptCommand(File file) {
            this.file = file;
        }

        private String[] createOSAScriptCommand(File file) {
            String path = file.getAbsolutePath();
            String playlist = iTunesSettings.ITUNES_PLAYLIST.get();
            String[] command = new String[]{"osascript", "-e", "tell application \"Finder\"", "-e", "set hfsFile to (POSIX file \"" + path + "\")", "-e", "set thePlaylist to \"" + playlist + "\"", "-e", "tell application \"iTunes\"", "-e", "launch", "-e", "if not (exists playlist thePlaylist) then", "-e", "set thisPlaylist to make new playlist", "-e", "set name of thisPlaylist to thePlaylist", "-e", "end if", "-e", "add hfsFile to playlist thePlaylist", "-e", "end tell", "-e", "end tell"};
            return command;
        }

        @Override
        public void run() {
            try {
                Runtime.getRuntime().exec(this.createOSAScriptCommand(this.file));
            }
            catch (IOException err) {
                LOG.debug(err);
            }
        }
    }

    private static class AddFileToWindowsITunes
    implements Runnable {
        private static final String ITUNES_ACTIVEX_NAME = "iTunes.Application";
        private static Boolean ready = null;
        private final File file;

        public AddFileToWindowsITunes(File file) {
            this.file = file;
        }

        @Override
        public void run() {
            try {
                this.addFileToLibrary(this.file);
            }
            catch (ComFailException e) {
                LOG.warn("Error adding file to itunes library", e);
            }
            catch (IllegalStateException e) {
                LOG.warn("Error adding file to itunes library", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean isReady() {
            if (ready != null) {
                return ready;
            }
            try {
                ComThread.InitMTA();
                try {
                    new ActiveXComponent(ITUNES_ACTIVEX_NAME);
                }
                finally {
                    ComThread.Release();
                }
            }
            catch (UnsatisfiedLinkError ex) {
                LOG.error("JACOB is not in the java.library.path.", ex);
                ready = Boolean.FALSE;
                return false;
            }
            catch (ComFailException ex) {
                LOG.error("iTunes ActiveX component not found.", ex);
                ready = Boolean.FALSE;
                return false;
            }
            ready = Boolean.TRUE;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean addFileToLibrary(File newFile) {
            if (!this.isReady()) {
                return false;
            }
            ComThread.InitMTA();
            try {
                ActiveXComponent iTunesCom = new ActiveXComponent(ITUNES_ACTIVEX_NAME);
                Dispatch iTunesController = iTunesCom.getObject();
                IiTunes it = new IiTunes(iTunesController);
                IITLibraryPlaylist pl = it.getLibraryPlaylist();
                IITOperationStatus status = pl.addFile(newFile.getAbsolutePath());
                if (status == null) {
                    boolean bl = false;
                    return bl;
                }
                while (status.getInProgress()) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(10L);
                    }
                    catch (InterruptedException ignored) {
                        // empty catch block
                        break;
                    }
                }
            }
            finally {
                ComThread.Release();
            }
            return true;
        }
    }
}

