/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.library;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.limewire.collection.glazedlists.AbstractListEventListener;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.core.api.library.FriendLibrary;
import org.limewire.core.api.library.PresenceLibrary;
import org.limewire.core.api.library.RemoteLibraryEvent;
import org.limewire.core.api.library.RemoteLibraryManager;
import org.limewire.core.api.search.SearchCategory;
import org.limewire.core.api.search.SearchDetails;
import org.limewire.core.api.search.SearchResult;
import org.limewire.inject.EagerSingleton;
import org.limewire.listener.EventListener;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.Stopwatch;
import org.limewire.util.StringUtils;

@EagerSingleton
public class FriendLibraries {
    private static final Log LOG = LogFactory.getLog(FriendLibraries.class);
    private static final Stopwatch watch = new Stopwatch(LOG);
    private final AtomicBoolean databaseIndexInitialized = new AtomicBoolean(false);
    private final AtomicInteger uniquePresenceId = new AtomicInteger();
    private final Object indexLock = new Object();
    private volatile Index index = new EmptyIndex();
    private final Map<String, LibraryListener> listeners = new ConcurrentHashMap<String, LibraryListener>();
    final Executor processingQueue = ExecutorsHelper.newProcessingQueue("friend-library-index-queue");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Index getIndex(boolean initializeDbIndex) {
        if (initializeDbIndex && !this.databaseIndexInitialized.get()) {
            Object object = this.indexLock;
            synchronized (object) {
                if (!this.databaseIndexInitialized.get()) {
                    this.index = new DatabaseIndex();
                    this.databaseIndexInitialized.set(true);
                }
            }
        }
        return this.index;
    }

    @Inject
    void register(RemoteLibraryManager remoteLibraryManager) {
        remoteLibraryManager.getFriendLibraryList().addListEventListener(new ListEventListener<FriendLibrary>(){

            @Override
            public void listChanged(ListEvent<FriendLibrary> listChanges) {
                while (listChanges.next()) {
                    int type = listChanges.getType();
                    if (type != 2) continue;
                    FriendLibrary friendLibrary = (FriendLibrary)listChanges.getSourceList().get(listChanges.getIndex());
                    new AbstractListEventListener<PresenceLibrary>(){

                        @Override
                        protected void itemAdded(PresenceLibrary item, int idx, EventList<PresenceLibrary> source) {
                            LOG.debugf("adding library for presence {0} to index", (Object)item);
                            LibraryListener listener = new LibraryListener(item);
                            FriendLibraries.this.listeners.put(item.getPresence().getPresenceId(), listener);
                            item.addListener(listener);
                        }

                        @Override
                        protected void itemRemoved(PresenceLibrary item, int idx, EventList<PresenceLibrary> source) {
                            LOG.debugf("removing library for presence {0} from index", (Object)item.getPresence().getPresenceId());
                            final LibraryListener listener = (LibraryListener)FriendLibraries.this.listeners.remove(item.getPresence().getPresenceId());
                            item.removeListener(listener);
                            FriendLibraries.this.processingQueue.execute(new Runnable(){

                                @Override
                                public void run() {
                                    listener.clear();
                                }
                            });
                        }

                        @Override
                        protected void itemUpdated(PresenceLibrary item, PresenceLibrary priorItem, int idx, EventList<PresenceLibrary> source) {
                        }
                    }.install(friendLibrary.getPresenceLibraryList());
                }
            }
        });
    }

    private static String canonicalize(String s) {
        return s.toUpperCase(Locale.US).toLowerCase(Locale.US);
    }

    public Collection<String> getSuggestions(String prefix, SearchCategory category) {
        return this.getIndex(false).getSuggestions(prefix, category);
    }

    public Collection<String> getSuggestions(String prefix, SearchCategory category, FilePropertyKey filePropertyKey) {
        return this.getIndex(false).getSuggestions(prefix, category, filePropertyKey);
    }

    public Collection<SearchResult> getMatchingItems(SearchDetails searchDetails) {
        return this.getIndex(false).getMatchingItems(searchDetails);
    }

    private List<String> extractKeywords(String query) {
        String[] keywords = query.split("\\s");
        ArrayList<String> results = new ArrayList<String>(keywords.length);
        for (String keyword : keywords) {
            if (keyword.isEmpty()) continue;
            results.add(FriendLibraries.canonicalize(keyword));
        }
        return results;
    }

    private SearchResult getSearchResult(int presenceId, int index) {
        for (LibraryListener libraryListener : this.listeners.values()) {
            if (presenceId != libraryListener.presenceId) continue;
            SearchResult result = libraryListener.presenceLibrary.get(index);
            return result;
        }
        throw new IllegalArgumentException(presenceId + " " + index);
    }

    private class DatabaseIndex
    implements Index {
        private final Connection connection;
        private final PreparedStatement insertPropertiesStmt;
        private final PreparedStatement insertSuggestionsStmt;
        private final ImmutableList<PreparedStatement> deleteStmts;

        public DatabaseIndex() {
            try {
                Class.forName("org.hsqldb.jdbcDriver");
            }
            catch (ClassNotFoundException e1) {
                throw new RuntimeException(e1);
            }
            try {
                File[] files;
                File folder = new File(CommonUtils.getUserSettingsDir(), "friend-indices");
                FileUtils.deleteRecursive(folder);
                folder.mkdirs();
                String connectionUrl = "jdbc:hsqldb:file:" + folder.getAbsolutePath() + File.separator + "friend-indices";
                Connection con = DriverManager.getConnection(connectionUrl, "sa", "");
                Statement statement = con.createStatement();
                statement.execute("set property \"hsqldb.cache_scale\" 8");
                statement.execute("set property \"hsqldb.cache_size_scale\" 6");
                con.close();
                this.connection = DriverManager.getConnection(connectionUrl, "sa", "");
                statement = this.connection.createStatement();
                statement.execute("drop table properties if exists");
                statement.execute("drop table suggestions if exists");
                statement.execute("CREATE CACHED TABLE properties (keyword VARCHAR(200), i INT, presence INT, category INT, fileproperty INT)");
                statement.execute("CREATE INDEX propertieskeywordindex on properties (keyword)");
                statement.execute("CREATE INDEX propertiespresenceindex on properties (presence)");
                statement.execute("CREATE CACHED TABLE suggestions (keyword VARCHAR(200), presence INT, category INT, fileproperty INT)");
                statement.execute("CREATE INDEX suggestionskeywordindex on suggestions(keyword)");
                statement.execute("CREATE INDEX suggestionspresenceindex on suggestions (presence)");
                this.insertPropertiesStmt = this.connection.prepareStatement("INSERT INTO properties (keyword, i, presence, category, fileproperty) VALUES (?,?,?,?,?)");
                this.insertSuggestionsStmt = this.connection.prepareStatement("INSERT INTO suggestions (keyword, presence, category, fileproperty) VALUES (?,?,?,?)");
                this.deleteStmts = ImmutableList.of(this.connection.prepareStatement("delete from properties where presence = ?"), this.connection.prepareStatement("delete from suggestions where presence = ?"));
                for (File file : files = FileUtils.getFilesRecursive(folder, new String[0])) {
                    file.deleteOnExit();
                }
                new File(folder, "friend-indices.backup").deleteOnExit();
                new File(folder, "friend-indices.script").deleteOnExit();
            }
            catch (SQLException sql) {
                throw new RuntimeException(sql);
            }
        }

        @Override
        public Collection<SearchResult> getMatchingItems(SearchDetails searchDetails) {
            String criterion;
            LOG.debugf("getMatchingItems for: {0}", (Object)searchDetails);
            SearchCategory category = searchDetails.getSearchCategory();
            StringBuilder sqlQuery = new StringBuilder();
            EnumMap<FilePropertyKey, List> details = new EnumMap<FilePropertyKey, List>(FilePropertyKey.class);
            int totalKeywordCount = 0;
            for (Map.Entry<FilePropertyKey, String> entry : searchDetails.getAdvancedDetails().entrySet()) {
                List keywords = FriendLibraries.this.extractKeywords(entry.getValue());
                totalKeywordCount += keywords.size();
                details.put(entry.getKey(), keywords);
            }
            List keywords = FriendLibraries.this.extractKeywords(searchDetails.getSearchQuery());
            String string = criterion = category != SearchCategory.ALL ? " and category = ?" : "";
            if (!keywords.isEmpty()) {
                sqlQuery.append(StringUtils.explode("select distinct presence, i from properties where keyword like ?" + criterion, " intersect ", keywords.size()));
            }
            if (totalKeywordCount > 0) {
                if (!keywords.isEmpty()) {
                    sqlQuery.append(" intersect ");
                }
                sqlQuery.append(StringUtils.explode("select distinct presence, i from properties where keyword like ? and fileproperty = ?" + criterion, " intersect ", totalKeywordCount));
            }
            try {
                PreparedStatement statement = this.connection.prepareStatement(sqlQuery.toString());
                LOG.debugf("query statement: {0}", (Object)statement);
                int index = 1;
                for (String string2 : keywords) {
                    statement.setString(index++, string2 + "%");
                    if (criterion.isEmpty()) continue;
                    statement.setInt(index++, category.getId());
                }
                for (Map.Entry entry : details.entrySet()) {
                    int fileProperty = ((FilePropertyKey)((Object)entry.getKey())).ordinal();
                    for (String keyword : (List)entry.getValue()) {
                        statement.setString(index++, keyword + "%");
                        statement.setInt(index++, fileProperty);
                        if (criterion.isEmpty()) continue;
                        statement.setInt(index++, category.getId());
                    }
                }
                LOG.debugf("filled in statement: {0}", (Object)statement);
                watch.reset();
                ResultSet resultSet = statement.executeQuery();
                watch.resetAndLog("query took ");
                ArrayList<SearchResult> arrayList = new ArrayList<SearchResult>();
                while (resultSet.next()) {
                    arrayList.add(FriendLibraries.this.getSearchResult(resultSet.getInt(1), resultSet.getInt(2)));
                }
                return arrayList;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Collection<String> getSuggestions(String prefix, SearchCategory category) {
            prefix = FriendLibraries.canonicalize(prefix);
            LOG.debugf("get suggestions: {0}", (Object)prefix);
            watch.reset();
            try {
                PreparedStatement statement;
                if (category == SearchCategory.ALL) {
                    statement = this.connection.prepareStatement("select keyword from suggestions where keyword LIKE ? group by keyword order by count(*) desc limit 8");
                    statement.setString(1, prefix + "%");
                } else {
                    statement = this.connection.prepareStatement("select keyword from suggestions where keyword LIKE ? and category = ? group by keyword order by count(*) desc limit 8");
                    statement.setString(1, prefix + "%");
                    statement.setInt(2, category.getId());
                }
                ResultSet result = statement.executeQuery();
                HashSet<String> suggestions = new HashSet<String>();
                while (result.next()) {
                    String suggestion = result.getString(1);
                    suggestions.add(suggestion);
                }
                if (LOG.isTraceEnabled()) {
                    watch.resetAndLog("query for " + prefix);
                }
                return suggestions;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Collection<String> getSuggestions(String prefix, SearchCategory category, FilePropertyKey filePropertyKey) {
            prefix = FriendLibraries.canonicalize(prefix);
            watch.reset();
            try {
                PreparedStatement statement;
                if (category == SearchCategory.ALL) {
                    statement = this.connection.prepareStatement("select keyword from suggestions where keyword LIKE ? and fileproperty = ? group by keyword order by count(*) desc limit 8");
                    statement.setString(1, prefix + "%");
                    statement.setInt(2, filePropertyKey.ordinal());
                } else {
                    statement = this.connection.prepareStatement("select keyword from suggestions where keyword LIKE ? and fileproperty = ? and category = ? group by keyword order by count(*) desc limit 8");
                    statement.setString(1, prefix + "%");
                    statement.setInt(2, filePropertyKey.ordinal());
                    statement.setInt(3, category.getId());
                }
                ResultSet result = statement.executeQuery();
                HashSet<String> suggestions = new HashSet<String>();
                while (result.next()) {
                    String suggestion = result.getString(1);
                    suggestions.add(suggestion);
                }
                if (LOG.isTraceEnabled()) {
                    watch.resetAndLog("query for " + prefix);
                }
                return suggestions;
            }
            catch (SQLException sql) {
                throw new RuntimeException(sql);
            }
        }

        @Override
        public void index(int presenceId, int index, SearchResult newFile) {
            watch.reset();
            for (FilePropertyKey filePropertyKey : FilePropertyKey.getIndexableKeys()) {
                Object property = newFile.getProperty(filePropertyKey);
                if (property == null) continue;
                String sentence = property.toString();
                this.indexProperty(presenceId, index, newFile, filePropertyKey, sentence);
            }
            if (LOG.isTraceEnabled()) {
                watch.resetAndLog("indexing " + newFile);
            }
        }

        private void indexProperty(int presenceId, int index, SearchResult newFile, FilePropertyKey filePropertyKey, String phrase) {
            SearchCategory category = SearchCategory.forCategory(newFile.getCategory());
            try {
                HashSet<String> keywords = new HashSet<String>();
                keywords.add(FriendLibraries.canonicalize(phrase));
                for (String keyword : phrase.split("\\s")) {
                    keywords.add(FriendLibraries.canonicalize(keyword));
                }
                this.insertWordsIntoPropertiesIndex(this.insertPropertiesStmt, keywords, index, presenceId, category, filePropertyKey);
                this.insertWordIntoSuggestionsIndex(this.insertSuggestionsStmt, phrase, presenceId, category, filePropertyKey);
            }
            catch (SQLException sql) {
                throw new RuntimeException(sql);
            }
        }

        private void insertWordsIntoPropertiesIndex(PreparedStatement statement, Collection<String> keywords, int index, int presenceId, SearchCategory category, FilePropertyKey filePropertyKey) throws SQLException {
            for (String keyword : keywords) {
                int i = 1;
                statement.setString(i++, keyword);
                statement.setInt(i++, index);
                statement.setInt(i++, presenceId);
                statement.setInt(i++, category.getId());
                statement.setInt(i++, filePropertyKey.ordinal());
                statement.addBatch();
            }
            this.insertPropertiesStmt.executeBatch();
        }

        private void insertWordIntoSuggestionsIndex(PreparedStatement statement, String keyword, int presenceId, SearchCategory category, FilePropertyKey filePropertyKey) throws SQLException {
            statement.setString(1, FriendLibraries.canonicalize(keyword));
            statement.setInt(2, presenceId);
            statement.setInt(3, category.getId());
            statement.setInt(4, filePropertyKey.ordinal());
            statement.execute();
        }

        @Override
        public void clear(int presenceId) {
            watch.reset();
            try {
                for (PreparedStatement statement : this.deleteStmts) {
                    statement.setInt(1, presenceId);
                    statement.execute();
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            watch.resetAndLog("clearing");
        }
    }

    private class EmptyIndex
    implements Index {
        private EmptyIndex() {
        }

        @Override
        public Collection<SearchResult> getMatchingItems(SearchDetails searchDetails) {
            return Collections.emptySet();
        }

        @Override
        public Collection<String> getSuggestions(String prefix, SearchCategory category) {
            return Collections.emptySet();
        }

        @Override
        public Collection<String> getSuggestions(String prefix, SearchCategory category, FilePropertyKey filePropertyKey) {
            return Collections.emptySet();
        }

        @Override
        public void index(int presenceId, int index, SearchResult newFile) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear(int presenceId) {
            throw new UnsupportedOperationException();
        }
    }

    static interface Index {
        public Collection<String> getSuggestions(String var1, SearchCategory var2);

        public Collection<String> getSuggestions(String var1, SearchCategory var2, FilePropertyKey var3);

        public Collection<SearchResult> getMatchingItems(SearchDetails var1);

        public void index(int var1, int var2, SearchResult var3);

        public void clear(int var1);
    }

    private class LibraryListener
    implements EventListener<RemoteLibraryEvent> {
        private final int presenceId;
        private final PresenceLibrary presenceLibrary;

        LibraryListener(PresenceLibrary presenceLibrary) {
            this.presenceId = FriendLibraries.this.uniquePresenceId.incrementAndGet();
            this.presenceLibrary = presenceLibrary;
        }

        private void index(int index, SearchResult result) {
            FriendLibraries.this.getIndex(true).index(this.presenceId, index, result);
        }

        private void clear() {
            FriendLibraries.this.getIndex(true).clear(this.presenceId);
        }

        @Override
        public void handleEvent(final RemoteLibraryEvent event) {
            FriendLibraries.this.processingQueue.execute(new Runnable(){

                @Override
                public void run() {
                    switch ((RemoteLibraryEvent.Type)((Object)event.getType())) {
                        case STATE_CHANGED: {
                            break;
                        }
                        case RESULTS_ADDED: {
                            Collection<SearchResult> results = event.getAddedResults();
                            int index = event.getStartIndex();
                            for (SearchResult result : results) {
                                LibraryListener.this.index(index++, result);
                            }
                            break;
                        }
                        case RESULTS_CLEARED: {
                            LibraryListener.this.clear();
                        }
                    }
                }
            });
        }
    }
}

