/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.friend.impl.address;

import com.google.inject.Inject;
import java.io.IOException;
import org.limewire.friend.impl.address.FriendAddress;
import org.limewire.inject.EagerSingleton;
import org.limewire.io.Address;
import org.limewire.io.BadGGEPBlockException;
import org.limewire.io.BadGGEPPropertyException;
import org.limewire.io.GGEP;
import org.limewire.net.address.AddressFactory;
import org.limewire.net.address.AddressSerializer;

@EagerSingleton
public class FriendAddressSerializer
implements AddressSerializer {
    static final String JID = "JID";

    @Override
    @Inject
    public void register(AddressFactory factory) {
        factory.registerSerializer(this);
    }

    @Override
    public boolean canSerialize(Address address) {
        return address instanceof FriendAddress;
    }

    @Override
    public String getAddressType() {
        return "xmpp-address";
    }

    @Override
    public Address deserialize(String address) throws IOException {
        String host;
        int dotIndex;
        int atIndex = address.indexOf(64);
        if (atIndex != -1 && atIndex != address.length() - 1 && (dotIndex = (host = address.substring(atIndex + 1)).indexOf(46)) != -1 && dotIndex != 0 && dotIndex != host.length() - 1) {
            return new FriendAddress(address);
        }
        throw new IOException();
    }

    @Override
    public Address deserialize(byte[] serializedAddress) throws IOException {
        try {
            GGEP ggep = new GGEP(serializedAddress);
            return new FriendAddress(ggep.getString(JID));
        }
        catch (BadGGEPBlockException e) {
            throw new IOException(e);
        }
        catch (BadGGEPPropertyException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte[] serialize(Address address) throws IOException {
        FriendAddress friendAddress = (FriendAddress)address;
        GGEP ggep = new GGEP();
        ggep.put(JID, friendAddress.getFullId());
        return ggep.toByteArray();
    }
}

