/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http.auth;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.Credentials;
import org.apache.http.nio.entity.ConsumingNHttpEntity;
import org.apache.http.nio.protocol.NHttpRequestHandler;
import org.apache.http.nio.protocol.NHttpResponseTrigger;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.UriPatternMatcher;
import org.limewire.http.auth.AuthenticationInterceptor;
import org.limewire.http.auth.Authenticator;
import org.limewire.http.auth.BasicServerAuthScheme;
import org.limewire.http.auth.RequiresAuthentication;
import org.limewire.http.auth.ServerAuthScheme;
import org.limewire.http.auth.ServerAuthState;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;

@Singleton
public class AuthenticationInterceptorImpl
implements AuthenticationInterceptor {
    private static final Log LOG = LogFactory.getLog(AuthenticationInterceptorImpl.class);
    private final Authenticator authenticator;
    private final UriPatternMatcher protectedURIs;

    @Inject
    public AuthenticationInterceptorImpl(Authenticator authenticator) {
        this.authenticator = authenticator;
        this.protectedURIs = new UriPatternMatcher();
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        ServerAuthState authState = new ServerAuthState();
        BasicServerAuthScheme authScheme = new BasicServerAuthScheme(this.authenticator);
        authState.setScheme(authScheme);
        context.setAttribute("http.server.auth", authState);
        if (this.protectedURIs.lookup(request.getRequestLine().getUri()) != null) {
            LOG.debugf("entering protected uri: {0}", (Object)request.getRequestLine().getUri());
            Credentials credentials = authScheme.authenticate(request);
            if (credentials != null) {
                authState.setCredentials(credentials);
                authScheme.setComplete();
            }
        } else {
            authScheme.setComplete();
        }
    }

    @Override
    public NHttpRequestHandler getGuardedHandler(String url, NHttpRequestHandler handler) {
        if (this.isProtected(handler)) {
            this.protectedURIs.register(url, url);
            return new GuardingHandler(handler);
        }
        return handler;
    }

    @Override
    public void unregisterHandler(String urlPattern) {
        this.protectedURIs.unregister(urlPattern);
    }

    private boolean isProtected(NHttpRequestHandler handler) {
        return handler.getClass().getAnnotation(RequiresAuthentication.class) != null;
    }

    private static class GuardingHandler
    implements NHttpRequestHandler {
        private final NHttpRequestHandler handler;

        public GuardingHandler(NHttpRequestHandler handler) {
            this.handler = handler;
        }

        @Override
        public ConsumingNHttpEntity entityRequest(HttpEntityEnclosingRequest request, HttpContext context) throws HttpException, IOException {
            ServerAuthState authState = (ServerAuthState)context.getAttribute("http.server.auth");
            ServerAuthScheme authScheme = authState.getScheme();
            if (authScheme.isComplete()) {
                return this.handler.entityRequest(request, context);
            }
            return null;
        }

        @Override
        public void handle(HttpRequest request, HttpResponse response, NHttpResponseTrigger trigger, HttpContext context) throws HttpException, IOException {
            ServerAuthState authState = (ServerAuthState)context.getAttribute("http.server.auth");
            ServerAuthScheme authScheme = authState.getScheme();
            if (authScheme.isComplete()) {
                this.handler.handle(request, response, trigger, context);
            } else {
                response.setStatusCode(401);
                response.addHeader(authScheme.createChallenge());
                trigger.submitResponse(response);
            }
        }
    }
}

