/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http.entity;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.entity.FileEntity;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.ProducingNHttpEntity;
import org.limewire.http.entity.FilePieceReader;
import org.limewire.http.entity.FileTransferMonitor;
import org.limewire.http.entity.Piece;
import org.limewire.http.entity.PieceListener;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.observer.Shutdownable;
import org.limewire.nio.timeout.StalledUploadWatchdog;

public class FileNIOEntity
extends FileEntity
implements ProducingNHttpEntity {
    private static final Log LOG = LogFactory.getLog(FileNIOEntity.class);
    private final FileTransferMonitor transfer;
    private final File file;
    private ByteBuffer buffer;
    private long length;
    private long begin;
    private long remaining;
    private FilePieceReader reader;
    private Piece piece;
    private IOControl ioctrl;
    private StalledUploadWatchdog watchdog;
    private long timeout = StalledUploadWatchdog.DELAY_TIME;
    private final Shutdownable timeoutable = new Shutdownable(){

        @Override
        public void shutdown() {
            FileNIOEntity.this.timeout();
        }
    };

    public FileNIOEntity(File file, String contentType, FileTransferMonitor transfer, long beginIndex, long length) {
        super(file, contentType);
        this.transfer = transfer;
        this.file = file;
        this.begin = beginIndex;
        this.length = length;
        this.remaining = length;
        if (length < 0L) {
            throw new IllegalStateException("upload end must be >= upload begin");
        }
    }

    public FileNIOEntity(File file, String contentType, FileTransferMonitor transfer) {
        this(file, contentType, transfer, 0L, file.length());
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public long getContentLength() {
        return this.length;
    }

    @Override
    public InputStream getContent() throws IOException {
        final FileInputStream in = new FileInputStream(this.file);
        return new InputStream(){

            @Override
            public int read() throws IOException {
                if (FileNIOEntity.this.remaining == 0L) {
                    return -1;
                }
                FileNIOEntity.this.remaining--;
                return in.read();
            }
        };
    }

    @Override
    public boolean isRepeatable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        if (outstream == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        BufferedInputStream instream = new BufferedInputStream(new FileInputStream(this.file));
        try {
            int l;
            byte[] tmp = new byte[4096];
            ((InputStream)instream).skip(this.begin);
            while (this.remaining > 0L && (l = ((InputStream)instream).read(tmp, 0, (int)Math.min(this.remaining, (long)tmp.length))) != -1) {
                outstream.write(tmp, 0, l);
                this.remaining -= (long)l;
            }
            outstream.flush();
        }
        finally {
            ((InputStream)instream).close();
        }
    }

    public File getFile() {
        return this.file;
    }

    public void initializeReader() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing upload of " + this.file.getName() + " [begin=" + this.begin + ",length=" + this.length + "]");
        }
        if (this.length == 0L) {
            return;
        }
        this.transfer.start();
        this.reader = new FilePieceReader(NIODispatcher.instance().getBufferCache(), this.file, this.begin, this.length, new PieceHandler());
        this.reader.start();
    }

    public void initializeWriter() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void finish() {
        this.deactivateTimeout();
        if (this.reader != null) {
            this.reader.shutdown();
            this.reader = null;
        }
        this.ioctrl = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        int written;
        if (this.ioctrl == null) {
            this.ioctrl = ioctrl;
            this.initializeReader();
        }
        if (this.buffer != null && this.buffer.hasRemaining()) {
            written = encoder.write(this.buffer);
            this.transfer.addAmountUploaded(written);
            if (this.buffer.hasRemaining()) {
                this.activateTimeout();
                return;
            }
            if (this.remaining == 0L) {
                this.reader.release(this.piece);
                encoder.complete();
                return;
            }
        } else if (this.remaining == 0L) {
            encoder.complete();
            return;
        }
        do {
            if (this.buffer == null || !this.buffer.hasRemaining()) {
                if (this.piece != null) {
                    this.reader.release(this.piece);
                }
                FileNIOEntity fileNIOEntity = this;
                synchronized (fileNIOEntity) {
                    this.piece = this.reader.next();
                    if (this.piece == null) {
                        this.buffer = null;
                        ioctrl.suspendOutput();
                        this.activateTimeout();
                        return;
                    }
                    this.buffer = this.piece.getBuffer();
                    this.remaining -= (long)this.buffer.remaining();
                }
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Uploading " + this.file.getName() + " [read=" + this.buffer.remaining() + ",remaining=" + this.remaining + "]");
            }
            written = encoder.write(this.buffer);
            this.transfer.addAmountUploaded(written);
        } while (written > 0 && this.remaining > 0L);
        if (this.remaining == 0L && !this.buffer.hasRemaining()) {
            encoder.complete();
        } else {
            this.activateTimeout();
        }
    }

    protected void activateTimeout() {
        if (this.watchdog == null) {
            this.watchdog = new StalledUploadWatchdog(this.timeout, NIODispatcher.instance().getScheduledExecutorService());
        }
        this.watchdog.activate(this.timeoutable);
    }

    protected void deactivateTimeout() {
        if (this.watchdog != null) {
            this.watchdog.deactivate();
        }
    }

    public int consumeContent(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getClass().getName() + " [file=" + this.file.getName() + "]";
    }

    public void timeout() {
        if (LOG.isWarnEnabled()) {
            LOG.warn("File transfer timed out: " + this.transfer);
        }
        this.transfer.timeout();
    }

    private class PieceHandler
    implements PieceListener {
        private PieceHandler() {
        }

        @Override
        public void readFailed(IOException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Error reading file from disk: " + FileNIOEntity.this.transfer, e);
            }
            FileNIOEntity.this.transfer.failed(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void readSuccessful() {
            FileNIOEntity fileNIOEntity = FileNIOEntity.this;
            synchronized (fileNIOEntity) {
                FileNIOEntity.this.ioctrl.requestOutput();
            }
        }
    }
}

