/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.inject;

import com.google.inject.Provider;

public class Providers {
    public static <T> Provider<T> of(T instance) {
        return new SimpleProvider<T>(instance);
    }

    public static <T> Provider<T> nullProvider(Class<? extends T> forTypeSafety) {
        return new EmptyProvider();
    }

    private static class EmptyProvider<T>
    implements Provider<T> {
        private EmptyProvider() {
        }

        @Override
        public T get() {
            return null;
        }
    }

    private static class SimpleProvider<T>
    implements Provider<T> {
        private final T t;

        public SimpleProvider(T t) {
            this.t = t;
        }

        @Override
        public T get() {
            return this.t;
        }
    }
}

