/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.limewire.concurrent.OnewayExchanger;
import org.limewire.mojito.concurrent.DHTFutureListener;

public class BlockingDHTFutureListener<T>
implements DHTFutureListener<T> {
    private final OnewayExchanger<T, ExecutionException> exchanger = new OnewayExchanger();

    @Override
    public void handleCancellationException(CancellationException e) {
        this.exchanger.cancel();
    }

    @Override
    public void handleExecutionException(ExecutionException e) {
        this.exchanger.setException(e);
    }

    @Override
    public void handleFutureSuccess(T result) {
        this.exchanger.setValue(result);
    }

    @Override
    public void handleInterruptedException(InterruptedException e) {
        this.exchanger.cancel();
    }

    public T get() throws ExecutionException, InterruptedException {
        return this.exchanger.get();
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        return this.exchanger.get(timeout, unit);
    }
}

