/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.messages.impl;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collection;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.io.MessageInputStream;
import org.limewire.mojito.io.MessageOutputStream;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.FindValueResponse;
import org.limewire.mojito.messages.MessageID;
import org.limewire.mojito.messages.impl.AbstractLookupResponse;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.Version;

public class FindValueResponseImpl
extends AbstractLookupResponse
implements FindValueResponse {
    private final Collection<KUID> secondaryKeys;
    private final Collection<? extends DHTValueEntity> entities;
    private final float requestLoad;

    public FindValueResponseImpl(Context context, Contact contact, MessageID messageId, float requestLoad, Collection<? extends DHTValueEntity> entities, Collection<KUID> secondaryKeys) {
        super(context, DHTMessage.OpCode.FIND_VALUE_RESPONSE, contact, messageId, Version.ZERO);
        this.requestLoad = requestLoad;
        this.entities = entities;
        this.secondaryKeys = secondaryKeys;
    }

    public FindValueResponseImpl(Context context, SocketAddress src, MessageID messageId, Version msgVersion, MessageInputStream in) throws IOException {
        super(context, DHTMessage.OpCode.FIND_VALUE_RESPONSE, src, messageId, msgVersion, in);
        this.requestLoad = in.readFloat();
        this.entities = in.readDHTValueEntities(this.getContact(), context.getDHTValueFactoryManager());
        this.secondaryKeys = in.readKUIDs();
    }

    @Override
    public Collection<KUID> getSecondaryKeys() {
        return this.secondaryKeys;
    }

    @Override
    public Collection<? extends DHTValueEntity> getDHTValueEntities() {
        return this.entities;
    }

    @Override
    public float getRequestLoad() {
        return this.requestLoad;
    }

    @Override
    protected void writeBody(MessageOutputStream out) throws IOException {
        out.writeFloat(this.requestLoad);
        out.writeDHTValueEntities(this.entities);
        out.writeKUIDs(this.secondaryKeys);
    }

    public String toString() {
        return "FindValueResponse: " + this.entities;
    }
}

