/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.messages.impl;

import java.io.IOException;
import java.math.BigInteger;
import java.net.SocketAddress;
import org.limewire.mojito.Context;
import org.limewire.mojito.io.MessageInputStream;
import org.limewire.mojito.io.MessageOutputStream;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.MessageID;
import org.limewire.mojito.messages.PingResponse;
import org.limewire.mojito.messages.impl.AbstractResponseMessage;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.Version;

public class PingResponseImpl
extends AbstractResponseMessage
implements PingResponse {
    private final SocketAddress externalAddress;
    private final BigInteger estimatedSize;

    public PingResponseImpl(Context context, Contact contact, MessageID messageId, SocketAddress externalAddress, BigInteger estimatedSize) {
        super(context, DHTMessage.OpCode.PING_RESPONSE, contact, messageId, Version.ZERO);
        this.externalAddress = externalAddress;
        this.estimatedSize = estimatedSize;
    }

    public PingResponseImpl(Context context, SocketAddress src, MessageID messageId, Version msgVersion, MessageInputStream in) throws IOException {
        super(context, DHTMessage.OpCode.PING_RESPONSE, src, messageId, msgVersion, in);
        this.externalAddress = in.readSocketAddress();
        this.estimatedSize = in.readDHTSize();
    }

    @Override
    public SocketAddress getExternalAddress() {
        return this.externalAddress;
    }

    @Override
    public BigInteger getEstimatedSize() {
        return this.estimatedSize;
    }

    @Override
    protected void writeBody(MessageOutputStream out) throws IOException {
        out.writeSocketAddress(this.externalAddress);
        out.writeDHTSize(this.estimatedSize);
    }

    public String toString() {
        return "PingResponse: externalAddress=" + this.externalAddress + ", estimatedSize=" + this.estimatedSize;
    }
}

